/* Distributed Checksum Clearinghouse
 *
 * ask for and administrative operation
 *
 * Copyright (c) 2005 by Rhyolite Software, LLC
 *
 * This agreement is not applicable to any entity which sells anti-spam
 * solutions to others or provides an anti-spam solution as part of a
 * security solution sold to other entities, or to a private network
 * which employs the DCC or uses data provided by operation of the DCC
 * but does not provide corresponding data to other users.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * Parties not eligible to receive a license under this agreement can
 * obtain a commercial license to use DCC and permission to use
 * U.S. Patent 6,330,590 by contacting Commtouch at http://www.commtouch.com/
 * or by email to nospam@commtouch.com.
 *
 * A commercial license would be for Distributed Checksum and Reputation
 * Clearinghouse software.  That software includes additional features.  This
 * free license for Distributed ChecksumClearinghouse Software does not in any
 * way grant permision to use Distributed Checksum and Reputation Clearinghouse
 * software
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE, LLC DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE, LLC
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.3.42-1.30 $Revision$
 */

#include "dcc_clnt.h"


/* ask for an administrative operation */
DCC_OPS					/* DCC_OP_INVALID=failed, else result */
dcc_aop(DCC_EMSG emsg,			/* result if DCC_OP_ERROR or _INVALID */
	DCC_CLNT_CTXT *ctxt, u_char grey, SRVR_INX anum,
	DCC_AOPS aop, u_int32_t val1, u_char val2, u_char val3, u_char val4,
	u_char *val5, u_int val5_len,
	AOP_RESP *resp,
	DCC_SOCKU *resp_su)		/* IP address of server used */
{
	DCC_ADMN_REQ req;
	DCC_EMSG loc_emsg;
	char respbuf[DCC_OPBUF];

	memset(&req, 0, sizeof(req));
	req.date = htonl(time(0));
	req.aop = aop;
	req.val1 = ntohl(val1);
	req.val2 = val2;
	req.val3 = val3;
	req.val4 = val4;
	if (val5_len != 0)
		memcpy(req.val5, val5, val5_len);
	memset(resp, 0, sizeof(*resp));
	if (!dcc_clnt_op(loc_emsg, ctxt,
			 (grey ? DCC_CLNT_FG_GREY : 0) | DCC_CLNT_FG_NO_FAIL,
			 &anum, 0, resp_su,
			 &req.hdr, sizeof(req)-MAX_DCC_ADMN_REQ_VAL5+val5_len,
			 DCC_OP_ADMN,
			 &resp->hdr, sizeof(*resp))) {
		dcc_pemsg(dcc_ex_code, emsg, "%s: %s",
			  dcc_aop2str(0, 0, aop, val1),
			  loc_emsg);
		return DCC_OP_INVALID;
	}

	if (resp->hdr.op ==  DCC_OP_OK)
		return DCC_OP_OK;
	if (resp->hdr.op == DCC_OP_ADMN) {
		/* clear signature after possible string */
		int len = (ntohs(resp->hdr.len)
			   - (sizeof(resp->resp)
			      - sizeof(resp->resp.val.string)));
		if (len < ISZ(resp->resp.val.string))
			resp->resp.val.string[len] = '\0';
		return DCC_OP_ADMN;
	}
	if (resp->hdr.op == DCC_OP_ERROR) {
		dcc_pemsg(dcc_ex_code, emsg, "%s: %s",
			  dcc_aop2str(0,0, aop, val1),
			  resp->resp.val.string);
		return DCC_OP_ERROR;
	}
	dcc_pemsg(EX_PROTOCOL, emsg, "%s unexpected response: %s",
		  dcc_aop2str(0, 0, aop, val1),
		  dcc_hdr_op2str(respbuf, sizeof(respbuf), &resp->hdr));
	return DCC_OP_INVALID;
}
