/* Distributed Checksum Clearinghouse
 *
 * Copyright (c) 2005 by Rhyolite Software, LLC
 *
 * This agreement is not applicable to any entity which sells anti-spam
 * solutions to others or provides an anti-spam solution as part of a
 * security solution sold to other entities, or to a private network
 * which employs the DCC or uses data provided by operation of the DCC
 * but does not provide corresponding data to other users.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * Parties not eligible to receive a license under this agreement can
 * obtain a commercial license to use DCC and permission to use
 * U.S. Patent 6,330,590 by contacting Commtouch at http://www.commtouch.com/
 * or by email to nospam@commtouch.com.
 *
 * A commercial license would be for Distributed Checksum and Reputation
 * Clearinghouse software.  That software includes additional features.  This
 * free license for Distributed ChecksumClearinghouse Software does not in any
 * way grant permision to use Distributed Checksum and Reputation Clearinghouse
 * software
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE, LLC DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE, LLC
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.3.42-1.18 $Revision$
 */

#include "dcc_defs.h"


/* convert IPv4 address to IPv6 */
void
dcc_ipv4toipv6(struct in6_addr *dst, const struct in_addr src)
{
	/* do it in an order that allows dst==src */
	dst->s6_addr32[3] = src.s_addr;
	dst->s6_addr32[0] = 0;
	dst->s6_addr32[1] = 0;
	dst->s6_addr32[2] = htonl(0xffff);
}



/* try to convert IPv6 address to IPv4 address */
u_char					/* 1=did it */
dcc_ipv6toipv4(struct in_addr *dst, const struct in6_addr *src)
{
	if (DCC_IN6_ADDR_V4MAPPED(src)) {
		dst->s_addr = src->s6_addr32[3];
		return 1;
	}

	if (src->s6_addr32[0] != 0
	    || src->s6_addr32[1] != 0
	    || src->s6_addr32[2] != 0)
		return 0;

	if (src->s6_addr32[3] == ntohl(1))
		dst->s_addr = ntohl(0x7f000001);
	else
		dst->s_addr = src->s6_addr32[3];
	return 1;
}



void
dcc_su2ip(DCC_IP *ip, const DCC_SOCKU *su)
{
	memset(ip, 0, sizeof(*ip));
	ip->port = *DCC_SU_PORT(su);
	ip->family = su->sa.sa_family;
	if (su->sa.sa_family == AF_INET)
		ip->u.v4 = su->ipv4.sin_addr;
	else
		ip->u.v6 = su->ipv6.sin6_addr;
}



/* try to convert IPv6 DCC_SOCKU to IPv4 */
u_char					/* 1=did it */
dcc_ipv6sutoipv4(DCC_SOCKU *dst, const DCC_SOCKU *src)
{
	struct in_addr addr4;

	if (src->sa.sa_family != AF_INET6) {
		if (src != dst)
			*dst = *src;
		return (src->sa.sa_family == AF_INET);
	}

	if (!dcc_ipv6toipv4(&addr4, &src->ipv6.sin6_addr)) {
		if (src != dst)
			*dst = *src;
		return 0;
	}

	dcc_mk_su(dst, AF_INET, &addr4, *DCC_SU_PORT(src));
	return 1;
}



/* try to convert IPv4 DCC_SOCKU to IPv6 */
u_char					/* 1=did it */
dcc_ipv4sutoipv6(DCC_SOCKU *dst, const DCC_SOCKU *src)
{
	struct in6_addr addr6;

	if (src->sa.sa_family != AF_INET) {
		if (src != dst)
			*dst = *src;
		return (src->sa.sa_family == AF_INET6);
	}

	dcc_ipv4toipv6(&addr6, src->ipv4.sin_addr);
	dcc_mk_su(dst, AF_INET6, &addr6, *DCC_SU_PORT(src));
	return 1;
}
