/* Distributed Checksum Clearinghouse
 *
 * Copyright (c) 2005 by Rhyolite Software, LLC
 *
 * This agreement is not applicable to any entity which sells anti-spam
 * solutions to others or provides an anti-spam solution as part of a
 * security solution sold to other entities, or to a private network
 * which employs the DCC or uses data provided by operation of the DCC
 * but does not provide corresponding data to other users.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * Parties not eligible to receive a license under this agreement can
 * obtain a commercial license to use DCC and permission to use
 * U.S. Patent 6,330,590 by contacting Commtouch at http://www.commtouch.com/
 * or by email to nospam@commtouch.com.
 *
 * A commercial license would be for Distributed Checksum and Reputation
 * Clearinghouse software.  That software includes additional features.  This
 * free license for Distributed ChecksumClearinghouse Software does not in any
 * way grant permision to use Distributed Checksum and Reputation Clearinghouse
 * software
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE, LLC DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE, LLC
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.3.42-1.20 $Revision$
 */

#include "dcc_defs.h"
#include "dcc_xhdr.h"


char *
dcc_tgts2str(char *buf, u_int buf_len, DCC_TGTS tgts, u_char grey_on)
{
	switch (tgts) {
	case DCC_TGTS_TOO_MANY:
		if (grey_on)
			STRLCPY(buf, DCC_XHDR_GREY_PASS, buf_len);
		else
			STRLCPY(buf, DCC_XHDR_TOO_MANY, buf_len);
		break;
	case DCC_TGTS_OK:
		STRLCPY(buf, DCC_XHDR_OK, buf_len);
		break;
	case DCC_TGTS_OK2:
		if (grey_on)		/* DCC_TGTS_GREY_WHITE */
			STRLCPY(buf, DCC_XHDR_OK, buf_len);
		else
			STRLCPY(buf, DCC_XHDR_OK2, buf_len);
		break;
	case DCC_TGTS_DEL:
		STRLCPY(buf, DCC_XHDR_DEL, buf_len);
		break;
	case DCC_TGTS_REP_ADJ:
		STRLCPY(buf, DCC_XHDR_TGTS_REP_ADJ, buf_len);
		break;
	case DCC_TGTS_OK_MX:
		STRLCPY(buf, DCC_XHDR_OK_MX, buf_len);
		break;
	case DCC_TGTS_OK_MXDCC:
		STRLCPY(buf, DCC_XHDR_OK_MXDCC, buf_len);
		break;
	case DCC_TGTS_INVALID:
		STRLCPY(buf, DCC_XHDR_INVALID, buf_len);
		break;
	default:
		if (tgts & DCC_TGTS_SPAM)
			snprintf(buf, buf_len, "%d spam",
				 tgts & ~DCC_TGTS_SPAM);
		else
			snprintf(buf, buf_len, "%d",
				 tgts);
		break;
	}

	return buf;
}
