I. Perl script beschrijving.
   -------------------------

dchub kan een perl interpreter starten om scripts te ondersteunen. Gebruik
-d om de directory met alle scripts te definieren en -s om het eerste
perl script om te laden te definieren.

NB: als u de -d optie gebruikt, moet u ook -s gebruiken (en vice-versa).
    Als u -d en -s niet gebruikt, wordt de perl interpreter niet
    geinitialiseerd (beste oplossing als u geen scripts wilt gebruiken).

* Als de interpreter geladen wordt, roept dchub de dchub_perl_init functie
  aan om enkele waarden te initialiseren. Zijn parameters is de string
  opgegeven met -d.

* Perl scripts worden aangeroepen als gebeurtenissen plaatsvinden. Als
  sommige gebeurtenissen plaatsvinden, roept dchub een functie met de naam
  dchub_perl_handler aan. Deze functie ontvangt een hash tabel (laten we het
  %evt_array noemen) die de volgende ingang bevat:
  "gebeurtenis": is de naam van de plaatsvindende gebeurtenis
  "bijnaam": is de naam van de gebruiker die de gebeurtenis gegenereerd heeft
         direct of niet).
  "argc": is het aantal optionele agumenten dat opgegeven is.
         Als optionele argumenten opgenomen zijn, worden ze "0","1","2","3", ...
	 genoemd



II. Standaard scripts.
    ------------------

In het dchub pakket is er een scripts directory die een bestand genaamd main.pl
bevat

main.pl levert een algemene cdhub_perl_init an een algemene dchub_perl_handler.
Als de standaard dchub_perl_handler aangeroepen wordt voor een gebeurtenis XYZ,
probeert het een functie genaamd dchub_XYZ_handler aan te roepen met %evt_array
als parameter. Als deze functie niet bestaat, probeert het een bestand genaamd
XYZ.pl vanuit script_dir te laden. Als dit laden ook mislukt, negeert de handler
de gebeurtenis. Als het laden wel lukt, wordt nog eens geprobeerd om 
dchub_XYZ_handler aan te roepen. Als de functie nog steeds niet bestaat, negeert
de handler de gebeurtenis.

NB over geladen scripts: Geladen scripts blijven in het geheugen geladen totdat
     de perl interpreter eindigd of herstart wordt. Dus globale variabelen
     bestaan met dezelfde verplichtingen.

III. Lijst met gedefinieerde gebeurtenissen met hun parameters
     ---------------------------------------------------------

gebeurtenis|
naam       | argc | argument beschrijving
-----------+------+-------------------------------------------------------------
search     |  1   | de $Search aanvraag zelf. Formaat van de aanvraag is
           |      | beschreven in manage_cnx.c, functie search_process
           |      | Deze gebeurtenis vindt plaats als iemand een aanvraag doet.
-----------+------+-------------------------------------------------------------
unisearch  |  1   | de $UniSearch aanvraag zelf. Formaat van de aanvraag is
	   |      | beschreven in manage_cnx.c, functie unisearch_process
           |      | Deze gebeurtenis vindt plaats als iemand een aanvraag doet.
-----------+------+-------------------------------------------------------------
myinfo     |  1   | de $MyINFO string zelf. Formaat van de string is 
           |      | beschreven in manage_cnx.c, functie myinfo_process
           |      | Deze gebeurtenis vindt plaats als iemand zijn persoonlijke 
           |      | informatie updates (gedeelde gegevens grootte, e-mail,
	   | 	  | weg/hier).
-----------+------+-------------------------------------------------------------
getnicklist|  0   | deze gebeurtenis vindt plaats als iemand de lijst met hub
           |      | gebruikers opvraagt.
-----------+------+-------------------------------------------------------------
globalchat |  1   | het bericht zelf (formaat: "<bijnaam> bericht|"). 
           |      | Deze gebeurtenis vindt plaats als iemand een bericht naar de
           |      | publieke chat zendt.
-----------+------+-------------------------------------------------------------
privchat   |  2   | 1ste argument is de doelbijnaam
           |      | 2de argument is de berichtinhoud
           |      | Deze gebeurtenis vindt plaats als iemand een bericht op een
	   |	  | prive chat zend.
           |      | NB: bericht gezonden door Hub-Security genereert deze
           |      |     gebeurtenis niet.
-----------+------+-------------------------------------------------------------
revconnect |  2   | 1ste argument is de doelbijnaam
           |      | 2de argument is het RevConnecttome bericht
           |      | Deze gebeurtenis vindt plaats als iemand (A) een verbinding
	   |	  | met iemand (B) anders wilt leggen, maar (A) is een
	   |	  | passieve gebruiker.
-----------+------+-------------------------------------------------------------
connecttome|  2   | 1ste argument is de doelbijnaam
           |      | 2de argument is het ConnectToMe bericht
	   |	  | Deze gebeurtenis vindt plaats als iemand (A) een verbinding
	   |	  | met iemand (B) anders wilt leggen en (A) is een actieve
	   |	  | gebruiker.
-----------+------+-------------------------------------------------------------
unknowncmd |  2   | 1ste argument is de bijnaam die de gebeurtenis genereert
           |      | 2de argument is het commando
	   |	  | Deze gebeurtenis vindt plaats als iemand een onbekend DC
	   |	  | commando naar de hub zendt. Technisch, is het met dit
	   |	  | commando mogelijk om nieuwe zelfgemaakte commando's in te
	   |	  | bouwen.
-----------+------+-------------------------------------------------------------
quit       |  0   | Deze gebeurtenis vindt plaats als iemand de hub verlaat.
-----------+------+-------------------------------------------------------------


IV. Lijst van dchub functies beschikbaar van perl scripts
    -----------------------------------------------------

paar definities om beschrijvingen te vergemakkelijken:
* een dcline is een regel in het DCformaat. Bijv. het begint met een $ (behalve
  voor globale chat) en eindigd met een |
* bijnaam is de bijnaam van een gebruiker. Tenzij het vermeld is, hoeft de
  bijnaam niet tot een gebruiker te behoren (geldig).

a) algemene uitvoer functies
   -------------------------

De volgende functies geven een algemene interface naar dchub uitvoer functies.
Technisch, door deze functies te gebruiken, is het mogelijk elke DC commando
naar iedereen te zenden.

dchub::send_to_named_user( string bijnaam, string dcline)

    * zend de opgegeven dcline naar de gebruiker genaamd bijnaam.

dchub::send_to_all_users( string dcline)

    * zend de opgegeven dcline naar alle verbonden gebruikers.


b) toegewijde chat functies
   ------------------------

dchub::send_gchat_msg( string zender_bijnaam, string bericht)

    * zend een bericht op de globale chat als gebruiker "zender_bijnaam". Deze
      functie bouwt het juiste DC bericht van de gegeven informatie.

dchub::send_pchat_msg( string zender_bijnaam, string doel_bijnaam, string bericht)

    * zend een prive bericht als gebruiker "zender_bijnaam" naar gebruiker
      "doel_bijnaam". Deze functie bouwt het juiste DC bericht van de gegeven
      informatie.


c) overige functies
   ----------------

dchub::disconnect(string bijnaam)

    * verbreekt de verbinding met de gebruiker van de opgegeven bijnaam.

dchub::kick(string bijnaam)

    * hetzelfde als disconnect, maar een verwijderbericht wordt op de globale
      chat weergegeven.

dchub::forcemove(string bijnaam, string doel_adres)

    * stuur de opgegeven gebruiker door naar het doel adres.

dchub::redirect(string bijnaam)

    * stuur de opgegeven gebruiker door naar "REDIR_ADDR".

dchub::redirectto(string bijnaam, string ip)

    * stuur de opgegeven gebruiker door naar het opgegeven adres (ip).

dchub::userlist()

    * verkrijg de lijst van hub gebruikers.

dchub::oplist()

    * verkrijg de lijst van hubbeheerders.

dchub::lstmultihubs()

    (Niet Beschikbaar) verkrijg de lijst van hubs die met deze hub gelinkt zijn.

dchub::nickinfo(string bijnaam)

    * verkrijg informatie over de opgegeven bijnaam.
      De verkregen string bevat de volgende velden en gebruikt $ als veld
      scheider:
         + verbindingstype
         + gedeelde grootte
         + gebruiker e-mail
         + gebruiker beschrijving
         + gebruiker optie (bit 0: altijd ingesteld)
                    	   (bit 1: =0: gebruiker hier, =1: gebruiker weg)
                           (bit 2: =0: client is normaal, =1, client is server ==online, langer dan 2 dagen)
                    	   (bit 3: =0: normale upload, =1: snelle upload == upload snelheid groter dan 100KB/s)
         + op flag   (==0: normal user)
                     (bit 0: =1: Administrator permissies)
                     (bit 1: =1: Meester permissies)
                     (bit 2: =1: Bot permissies)
                     (bit 3: =1: unused)
                     (bit 4: =1: Hub permissies)        
         + client versie

dchub::nick_duration(string bijnaam)

    * geeft het aantal seconden verstreken sinds het begin van deze verbinding
      Deze functie is hoofdzakelijk bruikbaar als sommige gebeurtenissen periodiek zijn en u
      wilt ze niet allemaal beantwoorden (zoals de $MyINFO, alleen de eerste is bruikbaar om
      ten minste "ok" berichten weer te geven).

dchub::nick_type(string bijnaam)

    * geeft het type "registratie" gebruikt door de bijnaam.
      Deze functie geeft "M" voor hubmeesters, "O" voor operators, "N" voor normale
      geregistreerde gebruikers en "U" voor ongeregistreerde gebruikers.


d) hub configuratie
   ----------------

dchub::get_max_users()

    * verkrijg de max aantal gebruikers toegestaan op de hub.

dchub::get_txtdescription()

    * verkrijg de hub beschrijving (voor hub registratie op DChublist)

dchub::get_hubip()

    * verkrijg het hub adres (voor hub registratie op DChublist)


e) database toegang
   ----------------

dchub::db_get(string sleutelnaam)

    * verkrijg de waarde die overeenkomt met de opgegeven sleutel. De verkregen
      waarde is altijd een string.

dchub::db_set(string sleutelnaam, sleutelwaarde)

    * zet de waarde geassocieerd met de opgegeven sleutel. De sleutel kan een integer, float of
      string zijn.



