/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * dc_com.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: dc_com.h,v 2.0 2003/01/30 12:50:44 eric Exp $
*/

#ifndef __DC_COM_H__
#define __DC_COM_H__
#include <time.h>

extern char last_cmd[5120];       /* contains the first string of the last send_dc_line call */ 
                                  /* mainly used for debug features.                         */

extern time_t last_cmd_time;		/* time() of the last successfully sent command */

/****************************************************/
/* write the given strings on the socket            */
/* a space will be written between each string      */
/* a | will be added at the end                     */
/***********************************************************/
/* to avoid network problem, we use send instead of write, */
/* cf. get_a_dc_line comment to understand why             */
/***********************************************************/
void send_dc_line(int sck,...);

/**************************************/
/* get a DC line (always ends by a |) */
/************************************************************************/
/* theory: DC client used send (not write) to send data over network    */
/*         so there is (invisible) message boundary inside network data */
/*         Thus, if you use recv to obtain data, we are sure to obtain  */
/*         a line ending by a |. However, we can receive more than one  */
/*         line at the same time.                                       */
/* real: to avoid buffer overflow and to be sure to have exactly one    */
/*       line, we read byte by byte network data. It is less efficient  */
/*       but it is safer and who cares about efficency to get 50 bytes. */
/*******************************************************************************/
/* input: sck= socket to read from                                             */
/* output: NULL or a GString (must be freed when no more used) ending with a | */
/*******************************************************************************/
GString *get_a_dc_line(int sck);

#endif
