/* DChub - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * edb_warper.c: Copyright (C) Uriel Chemouni <chemou_u@epita.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: edb_warper.c,v 2.4 2003/04/06 08:45:22 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#define HASH_SIZE 57

#include <stdlib.h>
#include <string.h>
#include "edb_warper.h"
#include <stdio.h>
#include <time.h>

static char	*gl_file_db_name=NULL;

t_db_sym	**init_symbol_db_table(void)
{
	t_db_sym	**out;
 
	out = malloc (HASH_SIZE * sizeof(t_db_sym*));
	bzero(out, HASH_SIZE * sizeof(t_db_sym*));
	return (out);
}

static int hach_str(const char *str)
{
	int len=0;
	int hash=0;

	if (str == NULL)
	{
		/* BUG */
		return (0);
	}
	len = strlen(str);
	while (len--)
	{
		unsigned char c;

		c = str[len];
		if ((c >= 'A') && (c <= 'Z'))
			hash += c - ('A' - 'a');
		else
			hash += c;
	}
	return (hash%HASH_SIZE);
}

const t_db_sym	*get_const_db_sym(const char *str, const t_db_sym **table)
{
	const t_db_sym	*tmp;
	int	i;
 
	i = hach_str (str); /*(hach(str) % HASH_SIZE);*/
	tmp = table[i];
	while (tmp)
	{
		if (strcasecmp(str, tmp->name))
			tmp = tmp->next;
		else
			return (tmp);
	}
	return (0);
}

static const char	*conv_table[] =
{
	"int",
	"float",
	"str"
};

char *e_db_type_get(t_db_sym **table,const char *key)
{
	const t_db_sym *tmp;

	tmp = get_const_db_sym(key, (const t_db_sym **)table);
	if ( (tmp!=NULL) && (tmp->type >= 0) && (tmp->type < 3) )
	{
		if (tmp->type > 2)
		{
			printf ("data base is corupted\n");
			return (strdup(conv_table[0]));
		}
		return (strdup(conv_table[tmp->type]));
	}
	return (0);
}

int e_db_data_del(t_db_sym **table, char *kn)
{
	return(del_db_sym(kn, table));
}

int	e_db_close(t_db_sym **conf_file)
{
	dump_db_table(gl_file_db_name, (const t_db_sym **)conf_file);
	return (0);
}

int e_db_flush(void)
{
	return (0);
}

char *e_db_str_get(t_db_sym **conf_file, const char *key)
{
	const t_db_sym	*tmp;

	tmp = get_const_db_sym(key, (const t_db_sym **)conf_file);
	if (tmp == NULL)
		return (NULL);
	return (strdup(tmp->str_value));
}

int e_db_str_set(t_db_sym **conf_file, const char *key, const char* value) /* ret 0 if ok */
{
	t_db_sym	*tmp;

	tmp = get_db_sym(key, conf_file);
	if (tmp == NULL)
	{
		put_db_sym(key, conf_file);
		tmp = get_db_sym(key, conf_file);
		tmp->type = 2;
	}
	if (tmp->str_value)
		free(tmp->str_value);
	tmp->str_value = strdup(value);
	return (0);
}

int e_db_int_get(t_db_sym **conf_file, const char *key, int *val) /* ret 0 if ok */
{
	 t_db_sym *tmp;
	 tmp = get_db_sym(key, conf_file);
	 if (tmp == NULL)
		return (0);
	 *val = tmp->int_value;
	 return (1);
}

int e_db_int_set(t_db_sym **conf_file, const char *key, int val) /* ret 0 if ok */
{
	t_db_sym	*tmp;

	tmp = get_db_sym(key, conf_file);
	if (tmp == NULL)
	{
		put_db_sym(key, conf_file);
		tmp = get_db_sym(key, conf_file);
		tmp->type = 0;
	}
	tmp->int_value = val;
	return (0);
}

int e_db_float_set(t_db_sym **conf_file, const char *key, float val) /* ret 0 if ok */
{
	t_db_sym	*tmp;

	tmp = get_db_sym(key, conf_file);
	if (tmp == NULL)
	{
		put_db_sym(key, conf_file);
		tmp = get_db_sym(key, conf_file);
		tmp->type = 1;
	}
	tmp->float_value = val;
	return (0);
}

int e_db_float_get(t_db_sym **conf_file, const char *key, float *val) /* ret 0 if ok */
{
	t_db_sym	*tmp;

	tmp = get_db_sym(key, conf_file);
	if (tmp == NULL)
		return (1);
	*val = tmp->float_value;
	return (0);
}

t_db_sym	*get_db_sym(const char *str, t_db_sym **table)
{
	t_db_sym	*tmp;
	int	i;
	
	i = hach_str (str);/*(hach(str) % HASH_SIZE);*/
	tmp = table[i];
	while (tmp)
	{
		if (strcasecmp(str, tmp->name))
			tmp = tmp->next;
		else
			return (tmp);
	}
	return (0);
}

int put_db_sym(const char *str, t_db_sym **table)
{
	const t_db_sym	*db_sym1;
	int		i;

	db_sym1 = get_const_db_sym(str, (const t_db_sym **)table);
	if (db_sym1 == 0)
	{
		t_db_sym	*db_sym;
	
		db_sym = malloc(sizeof (t_db_sym));
		memset(db_sym, 0, sizeof (t_db_sym));
		i = hach_str(str);
		db_sym->next = table[i];
		table[i] = db_sym;
		db_sym->name = strdup(str);
		return (0);
	}
	return (-1);
}

int chain_db_sym(t_db_sym *db_sym, t_db_sym **table)
{
	const t_db_sym	*tmp;
	int		i;

	tmp = get_const_db_sym(db_sym->name, (const t_db_sym **)table);
	if (tmp == NULL)
	{
		i = hach_str (db_sym->name);
		db_sym->next = table[i];
		table[i] = db_sym;
		return (0);
	}
	return (-1); 
}

static int tab_count;
static char **e_db_dump_key_list_out;

int dump_key_intra(const t_db_sym *ent)
{
	e_db_dump_key_list_out[tab_count] = strdup(ent->name);
	tab_count++;
	return (0);
}

char **e_db_dump_key_list(t_db_sym **table,int *nb_ret)
{
	tab_count = 0;
	*nb_ret = hash_db_table_len((const t_db_sym **)table);
	e_db_dump_key_list_out = malloc(sizeof(char*) * *nb_ret);
	db_sym_explore_const(dump_key_intra, (const t_db_sym **)table);
	return (e_db_dump_key_list_out);
}

int del_db_sym(const char *str, t_db_sym **table)
{
	t_db_sym	*tmp;
	t_db_sym	*old;
	int	i;
	 
	i = hach_str (str);
	tmp = table[i];
	old = NULL;
	while (tmp)
	{
		if (strcasecmp(str, tmp->name)!=0)
		{
			old = tmp;       /* save the old */
			tmp = tmp->next; /* switch to the next one */
		}
		else
		{
			free(tmp->name);
			if (old == NULL) /* if there is no older */
			{
				table[i] = table[i]->next; /* replace next element from the table */
			}
			else
			{
				old->next = tmp->next; /* else link the next from the old one */
			}
			free(tmp);
			return(0);
		}
	}
	return (-1);
}


int db_sym_explore_const(int (*fnc)(const t_db_sym *), const t_db_sym **table)
{
	int	i;
	const t_db_sym	*tmp;
	
	for (i = 0; i < HASH_SIZE; i++)
	{
		tmp = table[i];
		while (tmp)
		{
			fnc(tmp);
			tmp = tmp->next;
		}
	}
	return(0);
}

int db_sym_explore(int (*fnc)(t_db_sym *), t_db_sym **table)
{
	int	i;
	t_db_sym	*tmp;
	t_db_sym	*tmp2;
	
	for (i = 0; i < HASH_SIZE; i++)
	{
		tmp = table[i];
		while(tmp)
		{
			tmp2 = tmp->next;
			fnc(tmp);
			tmp = tmp2;
		}
	}
	return(0);
}

int hash_db_table_len(const t_db_sym **table)
{
	int	i;
	const t_db_sym	*tmp;
	int	len;

	for (len = i = 0; i < HASH_SIZE; i++)
	{
		tmp = table[i];
		while(tmp)
		{
			tmp = tmp->next;
			len++;
		}
	}
	return (len);
}

int dump_db_table(const char *filename, const t_db_sym **table)
{
	FILE	*file;
	const t_db_sym	*tmp;
	int	i;
	int	len;

	if (table == NULL)
		return (-1);

	len = hash_db_table_len(table);
	printf("start dump db in %s  ", filename);
	file=fopen(filename, "w");
	if (file == NULL)
	{
		perror("fopen");
		return(-2);
	}
	fprintf(file, "%d\n", len);
	for (i = 0; i < HASH_SIZE; i++)
	{
		tmp = table[i];
		while(tmp)
		{
			/* A first write of the row data from the structure (verty dirty) */
			if (fwrite(tmp, 1, sizeof(t_db_sym) - 4, file) != (sizeof(t_db_sym) - 4))
			/* the -4 is due to a change in the datastucture to keep compatibility.*/
			{
				fclose(file);
				return (-3);
			}
			fputs(tmp->name, file);
			fputc('\0', file);
			
			if (tmp->str_value == NULL)
				fputs("", file);
			else
				fputs(tmp->str_value, file);
			fputc('\0', file);
			tmp = tmp->next;
		}
	}
	fclose(file);
	printf("[ok]\n");
	return (0);
}

int free_db_sym(t_db_sym *ptr)
{
	if (ptr->name)
		free(ptr->name);
	if (ptr->str_value)
		free(ptr->str_value);
	free(ptr);
	return (0);
}

static char	*fgets_line(FILE *file, int end)
{
	char	*out;
	unsigned int	s;
	int	i;
	int	c;
	 
	s = 48;
	out=malloc(s);
	out[0] = '\0';
	i = 0;
	while (1)
	{
		c = fgetc(file);
		if (c == EOF)
		{
			free (out);
			return (NULL);
		}
		if (i >= s)
		{
			s *= 2;
			out = realloc(out, s);
		}
		if (c == end)
		{
			out[i] = 0;
			return (out);
		}
		out[i++] = c;
	}
}

t_db_sym	**e_db_open(const char *filename)
{
	t_db_sym **out;
	 
	out = load_db_table(filename);
	if (out == NULL)
		out = init_symbol_db_table();
	return(out);
}

t_db_sym **load_db_table(const char *filename)
{
	FILE	*file;
	t_db_sym	*tmp;
	int	len_exp;
	t_db_sym **table;
	int	len = 0;

	if (gl_file_db_name != 0)
		free(gl_file_db_name);
	gl_file_db_name = strdup(filename);
	/* printf("start load db from %s\n", filename); */
	file=fopen(filename, "r");
	if (file == NULL)
		return NULL;
	if (fscanf(file, "%d\n", &len_exp) != 1)
		return NULL;
	table = init_symbol_db_table();
	while (1)
	{
		tmp = malloc(sizeof(t_db_sym));
		if ((fread(tmp, 1, sizeof(t_db_sym) - 4, file) != (sizeof(t_db_sym) - 4)))
			break;
		len++;
		tmp->name = NULL;
		tmp->str_value = NULL;
		if ((tmp->name = fgets_line(file, '\0')) == 0)
			goto load_error;
		if ((tmp->str_value = fgets_line(file, '\0')) == 0)
		{
			free(tmp->name);
			
			load_error:
			printf("%s file is corupted %d entry read\n", filename, len);
			free (tmp);
			db_sym_explore(free_db_sym, table);
			fclose(file);
			free (table);
			return (0);
		}
		chain_db_sym(tmp, table);
	}
	fclose(file);
	if (len != len_exp)
		fprintf(stderr, "WARNING database is corrupted.");
	printf("%d Key%s loaded from %s.\n", len, (len>1)?"s":"",filename);
	return (table);
}
