/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * emb_perl.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: emb_perl.h,v 2.0 2003/01/30 12:50:44 eric Exp $
*/

#ifndef __EMB_PERL_H__
#define __EMB_PERL_H__

/******************************************/
/* initialize persistent perl interpreter */
/******************************************/
void init_perl(void);

/************************************/
/* exit persistent perl interpreter */
/************************************/
void exit_perl(void);

/****************************/
/* restart perl interpreter */
/****************************/
void restart_perl(void);

/****************************************************************/
/* send an event (with its arguments) to the perl event handler */
/****************************************************************/
void send_evt_to_script(const char *evt_name, const char *evt_emitter, int nb_args, ...);

/*************************************/
/* clear all autoloaded perl handler */
/*************************************/
void clear_autoloaded_perl_handlers(void);

#endif
