/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * main_cnx_handshake.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: main_cnx_handshake.h,v 2.2 2003/02/16 08:00:35 eric Exp $
*/

#ifndef __MAIN_CNX_HANDSHAKE_H__
#define __MAIN_CNX_HANDSHAKE_H__

#include "xf_io.h"

/**************************************/
/* check if the given string is an IP */
/**************************************/
/* output: TRUE=yes, FALSE=no */
/******************************/
gboolean is_ip(char *str);

#define MAX_CNX_HANDSHAKE_TIME 9

typedef enum
{
	STEP_LOCK_SENT=0,
	STEP_KEY_VALID,
	STEP_WANT_PASSWD,
	STEP_HANDSHAKE_DONE,
} LOG_STEP;

typedef struct
{
	XF_IO *xfio;	/* I/O to monitor */
	char *created_lock;
	LOG_STEP log_step;

	char *temp_nick;
	char *temp_passwd;
	int temp_privilege;
	unsigned int temp_ext_flag;
} CNX_HSHAKE;

/****************************************************/
/* register a new socket into the handshake handler */
/****************************************************/
/* if remote_addr ==NULL, the function computes it */
/***************************************************/
void cnx_handshake_register_new_fd(int sock_fd, struct in_addr *remote_addr);

/***********************************************/
/* function initializing the handshake handler */
/***********************************************/
GED_CALLBACKS *cnx_handshake_init(void);
#endif
