/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * my_poll.c: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: my_poll.c,v 2.0 2003/01/30 12:50:45 eric Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_SYS_POLL_H
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#ifdef WIN32
	#include <windows.h>
	#include <winsock2.h>
#endif


#include "my_poll.h"

#define local_max(a,b) (((a)>(b))?(a):(b) )

/*********************************/
/* emulate poll() using select() */
/*********************************/
int poll(struct pollfd *ufds, unsigned int nfds, int timeout)
{
	int out;
	struct timeval tv;

	
	tv.tv_sec=timeout/1000;
	tv.tv_usec=(timeout%1000)*1000;

	if(nfds==0)
	{
		out=select(0,NULL,NULL,NULL,&tv);
	}
	else
	{
		fd_set rd, wr, excpt;
		int i;
		int mx=-1;

		FD_ZERO(&rd);
		FD_ZERO(&wr);
		FD_ZERO(&excpt);

		for(i=0;i<nfds;i++)
		{
			mx=local_max(mx,ufds[i].fd);
			if(ufds[i].events&POLLIN)
				FD_SET(ufds[i].fd,&rd);
			if(ufds[i].events&POLLOUT)
				FD_SET(ufds[i].fd,&wr);
			if(ufds[i].events&POLLPRI)
				FD_SET(ufds[i].fd,&excpt);
		}

		out=select(mx+1,&rd,&wr,&excpt,&tv);
		if(out>0)
		{
			for(i=0;i<nfds;i++)
			{
				ufds[i].revents=0;

				if(FD_ISSET(ufds[i].fd,&rd))
					ufds[i].revents|=POLLIN;
				if(FD_ISSET(ufds[i].fd,&wr))
					ufds[i].revents|=POLLOUT;
				if(FD_ISSET(ufds[i].fd,&excpt))
					ufds[i].revents|=POLLERR;
			}
		}
	}

	return out;
}

#endif

