<?php
/*
 * $Id: class.boViews.inc.php,v 1.2.2.1 2002/02/15 02:49:54 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

class boViews
{
	function add()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_HAVE_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.htmlViews');
		$obj->ShowEntryForm();
		print('<p>');
		$obj->PrintAll();
	}

	function dbadd()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_HAVE_WO']))
			return PrintPermissionDenied();

		$objDB = CreateObject('dcl.dbViews');
		$objDB->Connect();
		$objDB->InitFromGlobals();

		$objView = CreateObject('dcl.boView');
		$objView->SetFromURL();
		$objDB->viewurl = $objView->GetURL();

		$objDB->Add();

		$objH = CreateObject('dcl.htmlView');
		$objH->Render($objView);
	}

	function delete()
	{
		commonHeader();

		$obj = CreateObject('dcl.dbViews');
		$obj->Connect();
		$obj->Load($GLOBALS['id']);
		if ($obj->whoid == $GLOBALS['DCLID'])
			ShowDeleteYesNo(STR_CMMN_VIEW, 'boViews.dbdelete', $obj->viewid, $obj->name, false);
		else
			PrintPermissionDenied();
	}

	function dbdelete()
	{
		$classSubName = 'Views';

		commonHeader();
		$obj = CreateObject('dcl.db' . $classSubName);
		$obj->connect();
		$obj->Load($GLOBALS['id']);

		if ($obj->whoid == $GLOBALS['DCLID'])
		{
			$obj->Delete();
			print(STR_BO_DELETED);
		}
		else
			PrintPermissionDenied();

		$objHTML = CreateObject('dcl.html' . $classSubName);
		$objHTML->PrintAll();
	}

	function exec()
	{
		commonHeader();
		$objDB = CreateObject('dcl.dbViews');
		$objDB->Connect();
		$objDB->Load($GLOBALS['viewid']);

		if ($objDB->ispublic == 'N' && $objDB->whoid != $GLOBALS['DCLID'])
			PrintPermissionDenied();

		$objView = CreateObject('dcl.boView');
		$objView->SetFromURLString($objDB->viewurl);

		if (IsSet($GLOBALS['btnNav']) && IsSet($GLOBALS['startrow']) && IsSet($GLOBALS['numrows']))
		{
			if ($GLOBALS['btnNav'] == '<<')
			{
				$objView->startrow = $GLOBALS['startrow'] - $GLOBALS['numrows'];
				if ($objView->startrow < 0)
					$objView->startrow = 0;
				$objView->numrows = $GLOBALS['numrows'];
			}
			else
			{
				$objView->startrow = $GLOBALS['startrow'] + $GLOBALS['numrows'];
				$objView->numrows = $GLOBALS['numrows'];
			}
		}
		else
		{
			$objView->numrows = 15;
			$objView->startrow = 0;
		}

		$objH = CreateObject('dcl.htmlView');
		$objH->Render($objView);
	}

	function page()
	{
		commonHeader();
		$objView = CreateObject('dcl.boView');
		$objView->SetFromURL();

		if (IsSet($GLOBALS['btnNav']) && IsSet($GLOBALS['startrow']) && IsSet($GLOBALS['numrows']))
		{
			if ($GLOBALS['btnNav'] == '<<')
			{
				$objView->startrow = $GLOBALS['startrow'] - $GLOBALS['numrows'];
				if ($objView->startrow < 0)
					$objView->startrow = 0;
				$objView->numrows = $GLOBALS['numrows'];
			}
			else
			{
				$objView->startrow = $GLOBALS['startrow'] + $GLOBALS['numrows'];
				$objView->numrows = $GLOBALS['numrows'];
			}
		}
		else
		{
			$objView->numrows = 15;
			$objView->startrow = 0;
		}

		$objH = CreateObject('dcl.htmlView');
		$objH->Render($objView);
	}

	function export()
	{
		// Silent function to export tab delimited file and force browser to 
		// force the user to save the file.
		$hdr =  'Content-Type: application/binary; name=dclexport.txt' . phpCrLf;
		$hdr .= 'Content-Disposition: attachment; filename=dclexport.txt' . phpCrLf . phpCrLf;
		header($hdr);

		$objView = CreateObject('dcl.boView');
		$objView->SetFromURL();

		// Make object, run query, and (for now) blindly dump data.  The first
		// record will contain column headings.  Any tabs within data will be replaced
		// by spaces since our fields our tab delimited.
		$strObj = 'db' . ucfirst($objView->table);
		$obj = CreateObject('dcl.' . $strObj);
		$obj->Connect();
		$obj->Query($objView->GetSQL());

		$record = '';
		if (count($objView->columnhdrs) > 0)
		{
			while (list($key, $val) = each($objView->columnhdrs))
			{
				$val = str_replace(phpTab, ' ', $val);
				if ($record != '')
					$record .= phpTab;

				$record .= $val;
			}
		}

		// Output field headings
		echo $record . phpCrLf;

		// Now for the records
		while ($obj->next_record())
		{
			$record = '';
			for ($i = 0; $i < $obj->NumFields(); $i++)
			{
				if ($i > 0)
					$record .= phpTab;

				if ($objView->table == 'tickets' && $obj->GetFieldName($i) == 'seconds')
					$record .= str_replace(phpTab, ' ', $obj->GetHoursText());
				else
					$record .= str_replace(phpTab, ' ', $obj->f($i));
			}

			echo $record . phpCrLf;
		}

		exit; // Don't output footer
	}
}
?>
