<?php
/*
 * $Id: class.dbConfig.inc.php,v 1.2 2001/09/23 21:33:38 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

class dbConfig extends dclDB
{
	var $dcl_config_name;
	var $dcl_config_field;
	var $dcl_config_int;
	var $dcl_config_double;
	var $dcl_config_date;
	var $dcl_config_datetime;
	var $dcl_config_varchar;

	function dbConfig()
	{
           // Table Fields
		$this->fieldArray = array(
				'dcl_config_name', 
				'dcl_config_field', 
				'dcl_config_int',
				'dcl_config_double',
				'dcl_config_date',
				'dcl_config_datetime',
				'dcl_config_varchar'
			);

           // Foreign Keys
		$this->foreignKeys = array();

		$this->cacheEnabled = true;
		$this->dclDB();
	}

	function Add()
	{
		if ($this->conn == 0)
		{
			if(!$this->Connect())
				return -1;
		}

		$query  = 'INSERT INTO dcl_config ';
		$query .= '(dcl_config_name, dcl_config_field, ' . $this->dcl_config_field;
		$query .= ') VALUES (\'';
		$query .= $this->DBAddSlashes($this->dcl_config_name) . "','";
		$query .= $this->DBAddSlashes($this->dcl_config_field) . "',";

		switch($this->dcl_config_field)
		{
			case 'dcl_config_date':
				$query .= $this->DisplayToSQL($this->dcl_config_date);
				break;
			case 'dcl_config_datetime':
				$query .= $this->DisplayToSQL($this->dcl_config_datetime);
				break;
			case 'dcl_config_varchar':
				$query .= "'" . $this->DBAddSlashes($this->dcl_config_varchar) . "'";
				break;
			default:
				eval('$query .= $this->' . $this->dcl_config_field . ';');
				break;
		}

		$query .= ')';

		if ($this->Insert($query) == -1)
		{
			print(sprintf(STR_DB_CFGINSERTERR, $query));
		}
	}

	function Edit()
	{
		if ($this->conn == 0)
		{
			if(!$this->Connect())
				return -1;
		}

		$query  = 'UPDATE dcl_config SET ';
		$query .= 'dcl_config_field=\'' . $this->DBAddSlashes($this->dcl_config_field) . '\',';

		$var_dbl = 'NULL';
		$var_int = 'NULL';
		$var_dt = 'NULL';
		$var_ts = $this->emptyTimestamp;
		$var_vc = 'NULL';

		switch($this->dcl_config_field)
		{
			case 'dcl_config_date':
				$var_dt = $this->DisplayToSQL($this->dcl_config_date);
				break;
			case 'dcl_config_datetime':
				$var_ts = $this->DisplayToSQL($this->dcl_config_datetime);
				break;
			case 'dcl_config_varchar':
				$var_vc = "'" . $this->DBAddSlashes($this->dcl_config_varchar) . "'";
				break;
			case 'dcl_config_double':
				$var_dbl = $this->dcl_config_double;
				break;
			case 'dcl_config_int':
				$var_int = $this->dcl_config_int;
				break;
		}
		$query .= 'dcl_config_int=' . $var_int . ',';
		$query .= 'dcl_config_double=' . $var_dbl . ',';
		$query .= 'dcl_config_date=' . $var_dt . ',';
		$query .= 'dcl_config_datetime=' . $var_ts . ',';
		$query .= 'dcl_config_varchar=' . $var_vc . ' ';
		$query .= 'WHERE dcl_config_name=\'' . $this->DBAddSlashes($this->dcl_config_name) . '\'';

		$this->Execute($query);
	}

	function Delete()
	{
		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$query = 'delete from dcl_config where dcl_config_name=\'';
		$query .= $this->DBAddSlashes($this->dcl_config_name) . '\'';

		$this->Execute($query);
	}

	function GetRow()
	{
		$this->Clear();

		if (!$this->res || count($this->Record) < 1)
			return -1;

		$this->dcl_config_name = $this->f('dcl_config_name');
		$this->dcl_config_field = $this->f('dcl_config_field');
		$this->dcl_config_int = $this->f('dcl_config_int');
		$this->dcl_config_double = $this->f('dcl_config_double');
		$this->dcl_config_date = $this->f('dcl_config_date');
		$this->dcl_config_datetime = $this->f('dcl_config_datetime');
		$this->dcl_config_varchar = $this->f('dcl_config_varchar');
	}

	function Load($sName = '')
	{
		global $dcl_info;

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT dcl_config_name, dcl_config_field, dcl_config_int,';
		$sql .= 'dcl_config_double, dcl_config_date, dcl_config_datetime,';
		$sql .= 'dcl_config_varchar FROM dcl_config';

		if (!$this->Query($sql))
			return -1;

		while ($this->next_record())
		{
			$sData = $this->f($this->f('dcl_config_field'));
			if ($this->f('dcl_config_field') == 'dcl_config_date')
				$dcl_info[$this->f('dcl_config_name')] = $this->FormatDateForDisplay($sData);
			elseif ($this->f('dcl_config_field') == 'dcl_config_datetime')
				$dcl_info[$this->f('dcl_config_name')] = $this->FormatTimestampForDisplay($sData);
			else
				$dcl_info[$this->f('dcl_config_name')] = $sData;
		}

		$this->FreeResult();

		return 1;
	}

	function Clear()
	{
		$this->dcl_config_name = '';
		$this->dcl_config_field = '';
		$this->dcl_config_int = 0;
		$this->dcl_config_double = 0.0;
		$this->dcl_config_date = '';
		$this->dcl_config_datetime = '';
		$this->dcl_config_varchar = '';
	}
}
?>
