<?php
/*
 * $Id: class.htmlAttributesetmapping.inc.php,v 1.2.2.1 2002/02/15 07:06:27 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('attr');

class htmlAttributesetmapping
{
	function Show($setid, $typeid)
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		if ($typeid < 1 || $typeid > 4)
		{
			print('<center>');
			PrintWithChocoFont('[htmlAttributesetmapping::Show] ' . STR_ATTR_INVALIDTYPE);
			print('</center');
			return;
		}

		$typeText = '';
		$table = '';
		switch($typeid)
		{
			case 1:
				$typeText = STR_ATTR_ACTIONS;
				$table = 'actions';
				break;
			case 2:
				$typeText = STR_ATTR_PRIORITIES;
				$table = 'priorities';
				break;
			case 3:
				$typeText = STR_ATTR_SEVERITIES;
				$table = 'severities';
				break;
			case 4:
				$typeText = STR_ATTR_STATUSES;
				$table = 'statuses';
				break;
			default:
		}

		$obj = CreateObject('dcl.dbAttributesets');
		$obj->Connect();
		$obj->Load($setid);

		$objDB = CreateObject('dcl.db' . ucfirst($table));
		$objDB->Connect($obj->conn);

		$objDB->Query("SELECT id,name FROM $table ORDER BY name");
		$arrAll = $objDB->FetchAllRows();

		$arrSelected = array();
		$objMap = CreateObject('dcl.dbAttributesetsmap');
		$objMap->Connect($obj->conn);
		$objMap->LoadMapForType($setid, $typeid);
		while ($objMap->next_record())
		{
			$arrSelected[$objMap->f(2)] = 1;
		}
		$objMap->FreeResult();

		$htmlAvailable = '';
		$htmlSelected = '';
		$arrSelectedData = array();
		for ($i = 0; $i < count($arrAll); $i++)
		{
			if (!IsSet($arrSelected[$arrAll[$i][0]]))
				$htmlAvailable .= '<option value="' . $arrAll[$i][0] . '">' . $arrAll[$i][1];
			else
				$arrSelectedData[$arrAll[$i][0]] = $arrAll[$i][1];
		}

		while (list($key, $val) = each($arrSelected))
			$htmlSelected .= '<option value="' . $key . '">' . $arrSelectedData[$key];

		$Template = CreateTemplate(array('hForm' => 'htmlAttributesetmapping.tpl'));
		$Template->set_block('hForm', 'weight', 'hWeight');
		$Template->set_block('hForm', 'noweight', 'hNoWeight');
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());

		$Template->set_var('TXT_EDITATTRIBUTESET', STR_ATTR_EDITATTRIBUTESET);
		$Template->set_var('VAL_NAME', $obj->name);
		$Template->set_var('TXT_TYPE', STR_ATTR_TYPE);
		$Template->set_var('VAL_TYPE', $typeText);
		$Template->set_var('VAL_SETID', $setid);
		$Template->set_var('VAL_TYPEID', $typeid);
		$Template->set_var('TXT_AVAILABLEVALUES', STR_ATTR_AVAILABLEVALUES);
		$Template->set_var('OPT_AVAILABLE', $htmlAvailable);
		$Template->set_var('TXT_ALL', STR_CMMN_ALL);
		$Template->set_var('TXT_SEL', STR_CMMN_SEL);
		$Template->set_var('TXT_USEDVALUES', STR_ATTR_USEDVALUES);
		$Template->set_var('OPT_SELECTED', $htmlSelected);
		$Template->set_var('BTN_UP', STR_CMMN_UP);
		$Template->set_var('BTN_DN', STR_CMMN_DN);
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);

		// Up/Down Buttons
		if ($typeid == 2 || $typeid == 3)
		{
			$Template->set_var('hNoWeight', '');
			$Template->parse('hWeight', 'weight');
		}
		else
		{
			$Template->set_var('hWeight', '');
			$Template->parse('hNoWeight', 'noweight');
		}

		$Template->pparse('out', 'hForm');
	}
}
?>
