<?php
/*
 * $Id: class.htmlProducts.inc.php,v 1.5.2.1.2.3 2003/01/26 19:03:43 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('prod');
LoadStringResource('wo');
LoadStringResource('tck');

class htmlProducts
{
	function createCombo($default = 0, $cbName = 'product', $longShort = 'name', $reportTo = 0, $size = 0, $activeOnly = true, $inputHandler=false)
	{
		print $this->GetCombo($default, $cbName, $longShort, $reportTo, $size, $activeOnly, $inputHandler);
	}

	function GetCombo($default = 0, $cbName = 'product', $longShort = 'name', $reportTo = 0, $size = 0, $activeOnly = true, $inputHandler = false)
	{
		$objDBProducts = CreateObject('dcl.dbProducts');
		$objDBProducts->Connect();
		$objDBProducts->cacheEnabled = false;
		$whereClause = '';

		if ($reportTo > 0 || $activeOnly == true)
		{
			$whereClause = ' WHERE ';
			if ($reportTo > 0)
				$whereClause = " reportto=$reportTo";

			if ($activeOnly == true)
			{
				if ($reportTo > 0)
					$whereClause .= ' AND';
				$whereClause .= ' active=\'Y\'';
			}
		}

		$objDBProducts->Query("SELECT id,$longShort FROM products" . $whereClause . " ORDER BY $longShort");

		$o = CreateObject('dcl.htmlSelect');
		$o->vDefault = $default;
		$o->sName = $cbName;
		$o->iSize = $size;
		$o->sZeroOption = STR_PROD_SELECTONE;
		$o->aOptions = $objDBProducts->FetchAllRows();
		$objDBProducts->FreeResult();
		if ($inputHandler)
			$o->sOnChange = 'productSelChange(this.form);';

		return $o->GetHTML();
	}

	function GetOptionsCombo($cbName)
	{
		global $g_oSec, $dcl_info;

		$o = CreateObject('dcl.htmlSelect');
		$o->sName = $cbName;
		$o->iSize = 1;
		$o->vDefault = 'boProducts.viewModules';

		$o->AddOption('boProducts.viewModules', 'View Modules*');
		$o->AddOption('boProducts.viewWO', STR_PROD_VIEWWO);
		$o->AddOption('boProducts.viewTck', STR_PROD_VIEWTICKETS);

		if ($g_oSec->HasSecLvl($dcl_info['DCL_ADD_USER']))
		{
			$o->AddOption('boProducts.modify', STR_CMMN_EDIT);
			$o->AddOption('boProducts.delete', STR_CMMN_DELETE);
		}

		$o->AddOption('boWatches.addWorkorder', 'Watch Workorders*');
		$o->AddOption('boWatches.addTicket', 'Watch Tickets*');

		return $o->GetHTML();
	}

	function PrintAll($orderBy = 'name')
	{
		global $dcl_info;

		$objDBProduct = CreateObject('dcl.dbProducts');
		$objDBProduct->Connect();

		$query = 'SELECT a.id,a.active,a.short,a.name,b.short,c.short,d.name,e.name ';
		$query .= 'FROM products a,personnel b,personnel c,attributesets d,attributesets e ';
		$query .= 'WHERE a.reportto=b.id AND a.ticketsto=c.id ';
		$query .= "AND a.wosetid=d.id AND a.tcksetid=e.id ORDER BY a.$orderBy";
		$objDBProduct->Query($query);
		$allRecs = $objDBProduct->FetchAllRows();

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
			$titleLink = '<a class="adark" href="' . menuLink('', 'menuAction=boProducts.add') . '">[ ' . STR_CMMN_NEW . ' ]</a>';
		else
			$titleLink = '';

		if (count($allRecs) > 0)
		{
			$allName = array(
					0 => STR_PROD_ID,
					1 => STR_PROD_ACTIVEABB,
					2 => STR_PROD_SHORT,
					3 => STR_PROD_NAME,
					4 => STR_PROD_REPORTTO,
					5 => STR_PROD_TICKETSTO,
					6 => STR_PROD_WOATTR,
					7 => STR_PROD_TCKATTR);

			$allName[] = STR_PROD_OPTIONS;
			for ($i = 0; $i < count($allRecs); $i++)
			{
				$options = '<a class="adark" href="' . menuLink('', 'menuAction=boProducts.view&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_VIEW . '</a>';
				$allRecs[$i][] = $options;
			}
			PrintArrayAsChocoTable($allName, $allRecs, sprintf(STR_PROD_TABLETITLE, $orderBy), '', $titleLink);
		}
		else
		{
			print('<center>');
			print(STR_PROD_NOPRODS . '&nbsp;&nbsp;' . $titleLink);
			print('</center>');
		}
	}

	function ShowEntryForm($obj = '')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$isEdit = is_object($obj);
		$Template = CreateTemplate(array('hForm' => 'htmlProductsForm.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());

		$hidden_vars = '';
		if ($isEdit)
		{
			$Template->set_var('TXT_FUNCTION', STR_PROD_EDIT);
			$hidden_vars .= '<input type="hidden" name="menuAction" value="boProducts.dbmodify">';
			$hidden_vars .= '<input type="hidden" name="id" value="' . $GLOBALS['id'] . '">';
		}
		else
		{
			$Template->set_var('TXT_FUNCTION', STR_PROD_ADD);
			$hidden_vars .= '<input type="hidden" name="menuAction" value="boProducts.dbadd">';
		}

		$Template->set_var('HIDDEN_VARS', $hidden_vars);

		// Labels
		$Template->set_var('TXT_ACTIVE', STR_PROD_ACTIVE);
		$Template->set_var('TXT_SHORT', STR_PROD_SHORT);
		$Template->set_var('TXT_NAME', STR_PROD_NAME);
		$Template->set_var('TXT_REPORTTO', STR_PROD_REPORTTO);
		$Template->set_var('TXT_TICKETSTO', STR_PROD_TICKETSTO);
		$Template->set_var('TXT_WOATTRIBUTESET', STR_PROD_WOATTRIBUTESET);
		$Template->set_var('TXT_TCKATTRIBUTESET', STR_PROD_TICKETATTRIBUTESET);
		$Template->set_var('BTN_OK', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_PROD_HIGHLIGHTEDNOTE);

		// Data
		$objHTMLPersonnel = CreateObject('dcl.htmlPersonnel');
		$objHA = CreateObject('dcl.htmlAttributesets');
		if ($isEdit)
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo($obj->active, 'active', 0, false));
			$Template->set_var('VAL_SHORT', $obj->short);
			$Template->set_var('VAL_NAME', $obj->name);
			$Template->set_var('CMB_REPORTTO', $objHTMLPersonnel->GetCombo($obj->reportto, 'reportto'));
			$Template->set_var('CMB_TICKETSTO', $objHTMLPersonnel->GetCombo($obj->ticketsto, 'ticketsto'));
			$Template->set_var('CMB_WOATTRIBUTESET', $objHA->GetCombo($obj->wosetid, 'wosetid'));
			$Template->set_var('CMB_TCKATTRIBUTESET', $objHA->GetCombo($obj->tcksetid, 'tcksetid'));
		}
		else
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo('Y', 'active', 0, false));
			$Template->set_var('VAL_SHORT', '');
			$Template->set_var('VAL_NAME', '');
			$Template->set_var('CMB_REPORTTO', $objHTMLPersonnel->GetCombo($GLOBALS['DCLID'], 'reportto'));
			$Template->set_var('CMB_TICKETSTO', $objHTMLPersonnel->GetCombo($GLOBALS['DCLID'], 'ticketsto'));
			$Template->set_var('CMB_WOATTRIBUTESET', $objHA->GetCombo(0, 'wosetid'));
			$Template->set_var('CMB_TCKATTRIBUTESET', $objHA->GetCombo(0, 'tcksetid'));
		}

		$Template->pparse('out', 'hForm');
	}

	function my($rowlimit = 5)
	{
		global $dcl_info;

		$obj = CreateObject('dcl.dbProducts');
		$obj->Connect();

		$query = sprintf('SELECT id,name FROM products WHERE (reportto=%d or ticketsto=%d) AND active=\'Y\' ORDER BY name ',
				$GLOBALS['DCLID'], $GLOBALS['DCLID']);

		if ($rowlimit > 0)
			$obj->LimitQuery($query, 0, $rowlimit);
		else
			$obj->Query($query);

		if ($rowlimit == 0)
		{
			print('<center>');
			BeginChocoTable(false, '50%');
		}
		else
			BeginChocoTable(false);
		print('<tr><th><a class="alightu" href="' . menuLink('', 'menuAction=boProducts.showmy') . '">');
		print(STR_PROD_MYPROD);
		print('</a>');
		if ($rowlimit > 0)
			PrintWithChocoFont("&nbsp;&nbsp;(Top $rowlimit)");
		print('</th></tr>');

		if ($obj->next_record())
		{
			$i = 0;
			do
			{
				if ($i++ % 2 == 0)
					print('<tr><td bgcolor="#ffffff">');
				else
					print('<tr><td bgcolor="' . $dcl_info['DCL_COLOR_LIGHT'] . '">');
				print('<a class="adark" href="' . menuLink('', 'menuAction=boProducts.view&id=' . $obj->f('id')) . '">' . $obj->f('name') . '</a>');
				print('</td></tr>');
			} while ($obj->next_record());
		}
		else
		{
			print('<tr><td bgcolor="#ffffff">');
			print(STR_PROD_NOTLEAD);
			print('</td></tr>');
		}

		print('</td></tr></table>');
	}

	function showdetail($id, $which = 'modules')
	{
		global $dcl_info;

		$obj = CreateObject('dcl.dbProducts');
		$obj->Connect();
		$obj->Load($id);

		$objPers = CreateObject('dcl.dbPersonnel');
		$objPers->Connect($obj->conn);

		$objStat = CreateObject('dcl.dbStatuses');
		$objStat->Connect($obj->conn);

		$Template = CreateTemplate(array('hForm' => 'htmlProductsDetail.tpl'));
		$Template->set_block('hForm', 'statuses', 'hStatuses');
		$Template->set_block('hForm', 'nostatuses', 'hNoStatuses');
		$Template->set_block('hForm', 'activity', 'hActivity');
		$Template->set_var('hStatuses', '');
		$Template->set_var('hNoStatuses', '');
		$Template->set_var('hActivity', '');

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('TXT_ACTIVE', STR_PROD_ACTIVE);
		$Template->set_var('TXT_REPORTTO', STR_PROD_REPORTTO);
		$Template->set_var('TXT_TICKETSTO', STR_PROD_TICKETSTO);
		$Template->set_var('TXT_ACTIVITY', STR_PROD_ACTIVITYLAST7DAYS);
		$Template->set_var('TXT_GO', STR_CMMN_GO);

		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('CMB_ACTION', $this->GetOptionsCombo('menuAction'));

		$Template->set_var('VAL_ID', $id);
		$Template->set_var('VAL_NAME', $obj->name);
		$Template->set_var('VAL_ACTIVE', $obj->active);
		$objPers->Load($obj->reportto);
		$Template->set_var('VAL_REPORTTO', $objPers->short);
		$objPers->Load($obj->ticketsto);
		$Template->set_var('VAL_TICKETSTO', $objPers->short);

		// Quick status summary here
		if ($which == 'modules')
			$obj->Query("SELECT status,count(*),sum(etchours),sum(totalhours) FROM workorders WHERE product=$id GROUP BY status");
		elseif ($which == 'workorders')
			$obj->Query("SELECT status,count(*),sum(etchours),sum(totalhours) FROM workorders WHERE product=$id GROUP BY status");
		else
			$obj->Query("SELECT status,count(*) FROM tickets WHERE product=$id GROUP BY status");

		if ($obj->next_record())
		{
			do
			{
				$objStat->Load($obj->f(0));
				$Template->set_var('VAL_STATUSNAME', $objStat->name);
				$Template->set_var('VAL_STATUSCOUNT', $obj->f(1));

				if ($which == 'workorders')
				{
					if ($objStat->id == 2)
						$Template->set_var('VAL_STATUSHOURS', sprintf('(%0.2fh)', $obj->f(3)));
					else
						$Template->set_var('VAL_STATUSHOURS', sprintf('(%0.2fh)', $obj->f(2)));
				}
				else
					$Template->set_var('VAL_STATUSHOURS', '');

				$Template->parse('hStatuses', 'statuses', true);
			}
			while ($obj->next_record());
		}
		else
		{
			if ($which == 'workorders')
				$Template->set_var('TXT_NOITEMS', STR_PROD_NOWORKORDERS);
			else
				$Template->set_var('TXT_NOITEMS', STR_PROD_NOTICKETS);

			$Template->parse('hNoStatuses', 'nostatuses', true);
		}

		$dt = new DCLTimestamp;
		$dtToday = new DCLTimestamp;
		$dtToday->time = time();

		$dt->time = $dtToday->time - (86400 * 7);

		$table = $which;
		if ($table == 'modules')
			$table = 'workorders';

		$obj->Query(sprintf("SELECT count(*) FROM $table a, statuses b WHERE a.product=$id AND a.status=b.id AND (b.dcl_status_type!=2 or (b.dcl_status_type=2 AND a.closedon between '%s' and '%s')) AND a.createdon<'%s'", $dt->ToDB(), $dtToday->ToDB(), $dt->ToDB()));
		$obj->next_record();
		$Template->set_var('TXT_ACTIVITYTYPE', STR_PROD_PREEXISTING);
		$Template->set_var('VAL_ACTIVITYCOUNT', $obj->f(0));
		$Template->parse('hActivity', 'activity', true);

		$obj->Query(sprintf("SELECT count(*) FROM $table WHERE product=$id AND createdon between '%s' and '%s'", $dt->ToDB(), $dtToday->ToDB()));
		$obj->next_record();
		$Template->set_var('TXT_ACTIVITYTYPE', STR_PROD_CREATED);
		$Template->set_var('VAL_ACTIVITYCOUNT', $obj->f(0));
		$Template->parse('hActivity', 'activity', true);

		$obj->Query(sprintf("SELECT count(*) FROM $table a, statuses b WHERE product=$id AND a.status=b.id AND b.dcl_status_type=2 AND closedon between '%s' and '%s'", $dt->ToDB(), $dtToday->ToDB()));
		$obj->next_record();
		$Template->set_var('TXT_ACTIVITYTYPE', STR_PROD_CLOSED);
		$Template->set_var('VAL_ACTIVITYCOUNT', $obj->f(0));
		$Template->parse('hActivity', 'activity', true);

		$obj->Query("SELECT count(*) FROM $table a, statuses b WHERE product=$id AND a.status=b.id AND b.dcl_status_type!=2");
		$obj->next_record();
		$Template->set_var('TXT_ACTIVITYTYPE', STR_PROD_OUTSTANDING);
		$Template->set_var('VAL_ACTIVITYCOUNT', $obj->f(0));
		$Template->parse('hActivity', 'activity', true);

		$Template->pparse('out', 'hForm');

		if ($which == 'modules')
		{
			// Print any modules for this product
			$obj->Query("SELECT product_module_id, active, module_name FROM dcl_product_module WHERE product_id = $id ORDER BY module_name");
			$allRecs = $obj->FetchAllRows();

			if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
				$titleLink = '<a class="adark" href="' . menuLink('', 'menuAction=htmlProductModules.add&product_id=' . $id) . '">[ ' . STR_CMMN_NEW . ' ]</a>';
			else
				$titleLink = '';

			if (count($allRecs) > 0)
			{
				$allName = array(
						0 => STR_PROD_ID,
						1 => STR_PROD_ACTIVEABB,
						2 => STR_PROD_NAME);

				if (count($allRecs) > 0 && $GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
				{
					$allName[] = STR_CMMN_OPTIONS;
					for ($i = 0; $i < count($allRecs); $i++)
					{
						$options = '<a class="adark" href="' . menuLink('', 'menuAction=htmlProductModules.modify&product_module_id=' . $allRecs[$i][0]) . '">' . STR_CMMN_EDIT . '</a>';
						$options .= '&nbsp;';
						$options .= '<a class="adark" href="' . menuLink('', 'menuAction=htmlProductModules.delete&product_module_id=' . $allRecs[$i][0]) . '">' . STR_CMMN_DELETE . '</a>';
						$allRecs[$i][] = $options;
					}
				}
				PrintArrayAsChocoTable($allName, $allRecs, sprintf('Product Modules Ordered By %s', 'Name'), '', $titleLink);
			}
			else
			{
				print('<center>');
				print('No Modules*' . '&nbsp;&nbsp;' . $titleLink);
				print('</center>');
			}
		}
		else
		{
			// This shows the non-closed work orders/tickets grouped by status
			$objView = CreateObject('dcl.boView');
			if ($which == 'workorders')
			{
				$objView->title = sprintf(STR_PROD_WOTITLE, $obj->name);
				$objView->style = 'report';
				$objView->table = 'workorders';
				$objView->AddDef('columns', '', array('jcn', 'seq', 'priorities.name', 'severities.name', 'responsible.short', 'deadlineon', 'summary'));
				$objView->AddDef('columnhdrs', '', array(
						STR_WO_STATUS,
						STR_WO_JCN,
						STR_WO_SEQ,
						STR_WO_PRIORITY,
						STR_WO_SEVERITY,
						STR_WO_RESPONSIBLE,
						STR_WO_DEADLINE,
						STR_WO_SUMMARY));

				$objView->AddDef('filter', 'product', $id);
				$objView->AddDef('filternot', 'status', '2');
				$objView->AddDef('order', '', array('jcn', 'seq'));
				$objView->AddDef('groups', '', array('statuses.name'));
			}
			else
			{
				$objView->title = sprintf(STR_PROD_TICKETTITLE, $obj->name);
				$objView->style = 'report';
				$objView->table = 'tickets';
				$objView->AddDef('columns', '', array('ticketid', 'priorities.name', 'severities.name', 'responsible.short', 'summary'));
				$objView->AddDef('columnhdrs', '', array(
						STR_TCK_STATUS,
						STR_TCK_TICKET . '#',
						STR_TCK_PRIORITY,
						STR_TCK_TYPE,
						STR_TCK_RESPONSIBLE,
						STR_TCK_SUMMARY));

				$objView->AddDef('filter', 'product', $id);
				$objView->AddDef('filternot', 'statuses.dcl_status_type', '2');
				$objView->AddDef('order', '', array('ticketid'));
				$objView->AddDef('groups', '', array('statuses.name'));
			}

			$objHV = CreateObject('dcl.htmlView');
			$objHV->Render($objView);
		}
	}
}
?>
