<?php
/*
 * $Id: class.htmlWorkOrderForm.inc.php,v 1.2.2.2.2.5 2002/10/31 14:51:37 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('wo');

class htmlWorkOrderForm
{
	function Show($jcn = 0, $objWO = '', $objTck = '')
	{
		global $dcl_info;

		$isEdit = is_object($objWO);
		$isTicket = is_object($objTck);

		if (!$GLOBALS['g_oSec']->HasSecLvl($isEdit ? $GLOBALS['dcl_info']['DCL_MOD_WO'] : $GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$objJS = CreateObject('dcl.jsAttributesets');
		$objHTMLProducts = CreateObject('dcl.htmlProducts');
		$objHTMLAccounts = CreateObject('dcl.htmlAccounts');
		$objHTMLPersonnel = CreateObject('dcl.htmlPersonnel');
		$objHTMLModules = CreateObject('dcl.htmlProductModules');
		$objProduct = CreateObject('dcl.dbProducts');

		$objJS->bPriorities = true;
		$objJS->bSeverities = true;
		$objJS->bModules = true;
		$objJS->DisplayAttributeScript();

		$Template = CreateTemplate(array('hForm' => 'htmlWorkOrderForm.tpl'));

		$Template->set_block('hForm', 'seqneedjcn', 'hSeqneedjcn');
		$Template->set_block('hForm', 'assign', 'hAssign');
		$Template->set_block('hForm', 'responsible', 'hResponsible');
		$Template->set_block('hForm', 'priority', 'hPriority');
		$Template->set_block('hForm', 'inproject', 'hInproject');
		$Template->set_block('hForm', 'chooseproject', 'hChooseproject');

		$Template->set_var('hSeqneedjcn', '');
		$Template->set_var('hAssign', '');
		$Template->set_var('hResponsible', '');
		$Template->set_var('hPriority', '');
		$Template->set_var('hInproject', '');
		$Template->set_var('hChooseproject', '');

		$title = '';
		if ($isTicket)
		{
			$title = sprintf(STR_WO_TICKET, $objTck->ticketid);
			$obj = $objTck;
		}
		elseif ($isEdit)
		{
			$title = sprintf(STR_WO_EDITWO, $objWO->jcn, $objWO->seq);
			$obj = $objWO;
		}
		elseif ($jcn == 0)
		{
			$title = STR_WO_ADDWO;
		}
		else
		{
			if ($jcn > 0)
				$title = sprintf(STR_WO_ADDSEQJCN, $jcn);
			else
				$title = STR_WO_ADDSEQ;
		}

		if (!$isEdit && !$isTicket)
			$title .= '&nbsp;' . GetHelpLink();

		$Template->set_var('TXT_TITLE', $title);

		$hiddenvars = '';
		if ($isEdit)
		{
			$hiddenvars = GetHiddenVar('menuAction', 'boWorkorders.dbmodifyjcn');
			$hiddenvars .= GetHiddenVar('jcn', $obj->jcn);
			$hiddenvars .= GetHiddenVar('seq', $obj->seq);
		}
		else
		{
			$hiddenvars = GetHiddenVar('menuAction', 'boWorkorders.dbnewjcn');

			if ($isTicket)
				$hiddenvars .= GetHiddenVar('ticketid', $objTck->ticketid);

			if ($jcn > 0)
				$hiddenvars .= GetHiddenVar('jcn', $jcn);
			elseif ($jcn == -1)
				$Template->parse('hSeqneedjcn', 'seqneedjcn');
		}

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_JSDATEFORMAT', GetJSDateFormat());
		$Template->set_var('VAL_FORMACTION', menuLink());

		$Template->set_var('TXT_JCN', STR_WO_JCN);
		$Template->set_var('TXT_PRODUCT', STR_WO_PRODUCT);
		$Template->set_var('TXT_ACCOUNT', STR_WO_ACCOUNT);
		$Template->set_var('TXT_RESPONSIBLE', STR_WO_RESPONSIBLE);
		$Template->set_var('TXT_DEADLINE', STR_WO_DEADLINE);
		$Template->set_var('TXT_ESTSTART', STR_WO_ESTSTART);
		$Template->set_var('TXT_ESTEND', STR_WO_ESTEND);
		$Template->set_var('TXT_ESTHOURS', STR_WO_ESTHOURS);
		$Template->set_var('TXT_IAMRESPONSIBLE', STR_WO_IAMRESPONSIBLE);
		$Template->set_var('TXT_REVISION', STR_WO_REVISION);
		$Template->set_var('TXT_PRIORITY', STR_WO_PRIORITY);
		$Template->set_var('TXT_SEVERITY', STR_WO_SEVERITY);
		$Template->set_var('TXT_CONTACT', STR_WO_CONTACT);
		$Template->set_var('TXT_CONTACTPHONE', STR_WO_CONTACTPHONE);
		$Template->set_var('TXT_SUMMARY', STR_WO_SUMMARY);
		$Template->set_var('TXT_NOTES', STR_WO_NOTES);
		$Template->set_var('TXT_DESCRIPTION', STR_WO_DESCRIPTION);
		$Template->set_var('TXT_ADDTOPROJECT', STR_WO_ADDTOPROJECT);
		$Template->set_var('TXT_ADDALLSEQ', STR_WO_ADDALLSEQ);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_WO_HIGHLIGHTEDNOTE);
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('VAL_DCLID', $GLOBALS['DCLID']);
		$Template->set_var('TXT_MODULE', 'Module*');

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'])
		{
			$objHTMLPriorities = CreateObject('dcl.htmlPriorities');
			$objHTMLSeverities = CreateObject('dcl.htmlSeverities');

			if ($isEdit || $isTicket)
			{
				$objProduct->Connect();
				$objProduct->Query('SELECT wosetid FROM products WHERE id=' . $obj->product);
				$objProduct->next_record();
				$setid = $objProduct->f(0);

				$Template->set_var('CMB_RESPONSIBLE', $objHTMLPersonnel->GetCombo($obj->responsible, 'responsible', 'lastfirst', 0, false, $dcl_info['DCL_HAVE_WO']));

				if ($isEdit)
				{
					$Template->set_var('CMB_PRIORITY', $objHTMLPriorities->GetCombo($obj->priority, 'priority', 'name', 0, false, $setid));
					$Template->set_var('CMB_SEVERITY', $objHTMLSeverities->GetCombo($obj->severity, 'severity', 'name', 0, false, $setid));
					$Template->set_var('VAL_DEADLINEON', $obj->deadlineon);
					$Template->set_var('VAL_ESTSTARTON', $obj->eststarton);
					$Template->set_var('VAL_ESTENDON', $obj->estendon);
					$Template->set_var('VAL_ESTHOURS', $obj->esthours);
				}
				else
				{
					$Template->set_var('CMB_PRIORITY', $objHTMLPriorities->GetCombo(0, 'priority', 'name', 0, false, $setid));
					$Template->set_var('CMB_SEVERITY', $objHTMLSeverities->GetCombo(0, 'severity', 'name', 0, false, $setid));
				}
			}
			else
			{
				$Template->set_var('CMB_RESPONSIBLE', $objHTMLPersonnel->GetCombo($GLOBALS['DCLID'], 'responsible', 'lastfirst', 0, true, $dcl_info['DCL_HAVE_WO']));
				$Template->set_var('CMB_PRIORITY', $objHTMLPriorities->GetCombo());
				$Template->set_var('CMB_SEVERITY', $objHTMLSeverities->GetCombo());
			}

			if (!$isEdit)
			{
				if ($dcl_info['DCL_AUTO_DATE'] == 'Y')
				{
					$Template->set_var('VAL_DEADLINEON', date($dcl_info['DCL_DATE_FORMAT']));
					$Template->set_var('VAL_ESTSTARTON', date($dcl_info['DCL_DATE_FORMAT']));
					$Template->set_var('VAL_ESTENDON', date($dcl_info['DCL_DATE_FORMAT']));
				}
				else
				{
					$Template->set_var('VAL_DEADLINEON', '');
					$Template->set_var('VAL_ESTSTARTON', '');
					$Template->set_var('VAL_ESTENDON', '');
				}

				$Template->set_var('VAL_ESTHOURS', '');
			}

			$Template->parse('hAssign', 'assign');
			$Template->parse('hPriority', 'priority');
		}
		elseif ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'])
		{
			if (IsSet($GLOBALS['responsible']))
				$Template->set_var('CHK_RESPONSIBLE', ' checked');

			$Template->parse('hResponsible', 'responsible');
		}

		if ($isEdit)
		{
			$Template->set_var('VAL_REVISION', htmlspecialchars($obj->revision));
			$Template->set_var('VAL_CONTACT', htmlspecialchars($obj->contact));
			$Template->set_var('VAL_CONTACTPHONE', htmlspecialchars($obj->contactphone));
			$Template->set_var('VAL_SUMMARY', htmlspecialchars($obj->summary));
			$Template->set_var('VAL_NOTES', htmlspecialchars($obj->notes));
			$Template->set_var('VAL_DESCRIPTION', htmlspecialchars($obj->description));
			$Template->set_var('CMB_PRODUCT', $objHTMLProducts->GetCombo($obj->product, 'product', 'name', 0, 0, false, true));
			$Template->set_var('CMB_MODULE', $objHTMLModules->GetCombo($obj->module_id, 'module_id', 0, false, $obj->product));
			$Template->set_var('CMB_ACCOUNT', $objHTMLAccounts->GetCombo($obj->account, 'account', 'name', 0, false));
		}
		elseif ($isTicket)
		{
			$Template->set_var('VAL_REVISION', '');
			$Template->set_var('VAL_CONTACT', htmlspecialchars($obj->contact));
			$Template->set_var('VAL_CONTACTPHONE', htmlspecialchars($obj->contactphone));
			$Template->set_var('VAL_SUMMARY', htmlspecialchars($obj->summary));
			$Template->set_var('VAL_DESCRIPTION', htmlspecialchars($obj->issue));

			$notes = 'Copied from ticket dcl://tickets/' . $obj->ticketid;
			if ($obj->contactemail != '')
				$notes .= phpCrLf . sprintf('%s: %s', STR_WO_CONTACTEMAIL, htmlspecialchars($obj->contactemail));

			$Template->set_var('VAL_NOTES', htmlspecialchars($notes));
			$Template->set_var('CMB_PRODUCT', $objHTMLProducts->GetCombo($obj->product, 'product', 'name', 0, 0, false, true));
			$Template->set_var('CMB_MODULE', $objHTMLModules->GetCombo($obj->module_id, 'module_id', 0, false, $obj->product));
			$Template->set_var('CMB_ACCOUNT', $objHTMLAccounts->GetCombo($obj->account, 'account', 'name', 0, false));
		}
		else
		{
			$Template->set_var('VAL_REVISION', '');
			$Template->set_var('VAL_CONTACT', '');
			$Template->set_var('VAL_CONTACTPHONE', '');
			$Template->set_var('VAL_SUMMARY', '');
			$Template->set_var('VAL_NOTES', '');
			$Template->set_var('VAL_DESCRIPTION', '');
			$Template->set_var('CMB_PRODUCT', $objHTMLProducts->GetCombo(0, 'product', 'name', 0, 0, true, true));
			$Template->set_var('CMB_MODULE', $objHTMLModules->GetCombo(0, 'module_id', 0, true));
			$Template->set_var('CMB_ACCOUNT', $objHTMLAccounts->GetCombo());
		}

		if (!$isEdit)
		{
			// If not editing, display project options (if any)
			$objPM = CreateObject('dcl.dbProjectmap');
			$objPM->Connect();

			if (($jcn > 0 && $objPM->LoadByWO($jcn, 0) != -1) || ($GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'] && IsSet($GLOBALS['projectid'])))
			{
				$objDBPrj = CreateObject('dcl.dbProjects');
				$objDBPrj->Connect();
				
				if ($objPM->projectid > 0)
					$objDBPrj->Load($objPM->projectid);
				else
				{
					$objDBPrj->Load($GLOBALS['projectid']);
					$hiddenvars .= GetHiddenVar('projectid', $GLOBALS['projectid']);
					$hiddenvars .= GetHiddenVar('project', $GLOBALS['projectid']);
					$hiddenvars .= GetHiddenVar('return_to', 'boProjects.viewproject');
				}

				$Template->set_var('TXT_WILLBEPARTOFPROJECT', sprintf(STR_WO_WILLBEPARTOFPROJECT, $objDBPrj->name));
				$Template->parse('hInproject', 'inproject');
			}
			elseif ($GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'])
			{
				$objPrj = CreateObject('dcl.htmlProjects');
				$Template->set_var('CMB_PROJECT', $objPrj->GetCombo(0, 'projectid'));
				$Template->parse('hChooseproject', 'chooseproject');
			}
		}

		$Template->set_var('HIDDEN_VARS', $hiddenvars);
		
		$Template->pparse('out', 'hForm');
	}
}
?>
