<?php
    /*
     * $Id: login.php,v 1.3.2.2.2.1 2002/11/11 04:17:23 mdean Exp $
     *
     * Double Choco Latte - Source Configuration Management System
     * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
     *
     * This program is free software; you can redistribute it and/or
     * modify it under the terms of the GNU General Public License
     * as published by the Free Software Foundation; either version 2
     * of the License, or (at your option) any later version.
     *
     * This program is distributed in the hope that it will be useful,
     * but WITHOUT ANY WARRANTY; without even the implied warranty of
     * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     * GNU General Public License for more details.
     *
     * You should have received a copy of the GNU General Public License
     * along with this program; if not, write to the Free Software
     * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
     *
     * Select License Info from the Help menu to view the terms and conditions of this license.
     */

if (!IsSet($GLOBALS['LOGIN_PHP_INCLUDED']))
{
	$GLOBALS['LOGIN_PHP_INCLUDED'] = 1;

	include('inc/config.php');
	include('inc/functions.inc.php');

	function Refresh($toHere = 'index.php', $id = 0, $pwd = '', $DCLUI = 2, $defLang = 'en', $domain = 'default')
	{
		global $DCLINFO, $HTTP_SERVER_VARS;

		$bIsLogin = (substr($toHere, 0, 9) == 'index.php');

		if ($bIsLogin)
		{
			$theCookie = '';
			if (IsSet($HTTP_SERVER_VARS['QUERY_STRING']))
				$toHere .= sprintf('%srefer_to=%s', strpos($toHere, '?') > 0 ? '&' : '?', urlencode($HTTP_SERVER_VARS['QUERY_STRING']));
		}
		else
			$theCookie = $id . '/' . $DCLUI . '/' . $pwd . '/' . $defLang . '/' . $domain;

		if ($GLOBALS['cookieMethod'] == 'header')
		{
			$hdr = '';
			if ($GLOBALS['redirMethod'] == 'php')
				$hdr = "Location: $toHere\n";

			$hdr .= "Set-Cookie: DCLINFO=$theCookie\n";
			$hdr .= "Set-Cookie: DCLTYPEMENU=$DCLUI\n";
			$hdr .= "\n";

			Header($hdr);
			if ($bIsLogin)
				exit;
		}

		if ($GLOBALS['cookieMethod'] == 'php')
		{
            // Feature by Brian Cooke
			SetCookie('DCLTYPEMENU', $DCLUI);
			SetCookie('DCLINFO', $theCookie);
			if ($GLOBALS['redirMethod'] == 'php')
			{
				Header("Location: $toHere\n\n");
				if ($bIsLogin)
					exit;
			}
		}

		print('<html><head>');

		if ($GLOBALS['cookieMethod'] == 'meta')
		{
			print("<meta http-equiv=\"Set-Cookie\" content=\"DCLINFO=$theCookie\">");
			print("<meta http-equiv=\"Set-Cookie\" content=\"DCLTYPEMENU=$DCLUI\">");
		}

		print("<meta http-equiv=\"refresh\" content=\"00;URL=$toHere\">");
		print('</head>');
		if ($bIsLogin)
		{
			print('<body bgcolor="#FFFFFF"></body></html>');
			exit;
		}
	}

	function privateKeyEncrypt($thisString)
	{
		global $dcl_info;

		return md5($thisString . $dcl_info['DCL_PRIVATE_KEY']);
	}

	if (!IsSet($GLOBALS['DBPERSONNEL_PHP_INCLUDED']))
	{
		include('inc/class.dbPersonnel.inc.php');
		$GLOBALS['DBPERSONNEL_PHP_INCLUDED'] = 1;
	}

	$obj = new dbPersonnel;
	$obj->Connect();
	$obj->cacheEnabled = false;

	if ($obj->conn)
	{
		if (IsSet($HTTP_COOKIE_VARS['DCLINFO']) && !IsSet($HTTP_POST_VARS['UID']))
		{
			if (ereg('^([0-9]{1,10})/([0-9])/([[:alnum:]]{32})/([[:alnum:]]{2,5})/([[:alnum:]]*)$', $HTTP_COOKIE_VARS['DCLINFO'], $reg))
			{
				$GLOBALS['DCLID'] = $reg[1];
				$GLOBALS['DCLUI'] = $reg[2];
				if ($obj->Load($GLOBALS['DCLID']) != -1)
				{
					if ($obj->active == 'Y')
					{
						$testPwd = privateKeyEncrypt($obj->pwd);
						if ($reg[3] != $testPwd)
							Refresh();

						$GLOBALS['SEC'] = $obj->security;
						$GLOBALS['DCLNAME'] = $obj->short;
						$GLOBALS['USEREMAIL'] = $obj->email;
					}
					else
						Refresh('index.php?cd=1');
				}
				else
					Refresh('index.php?cd=1');
			}
			else
				Refresh('index.php?cd=2');
		}
		else
		{
			if ($obj->Query('SELECT id,pwd FROM personnel WHERE short=\'' . $HTTP_POST_VARS['UID'] . '\' AND active=\'Y\'') != -1)
			{
				if ($obj->next_record())
				{
					$id = $obj->f(0);
					$userpwd = $obj->f(1);
					$thispwd = md5($HTTP_POST_VARS['PWD']);
					if ($thispwd == $userpwd)
					{
						$thispwd = privateKeyEncrypt(md5($HTTP_POST_VARS['PWD']));

						$menuAction = 'menuAction=htmlMyDCL.show';
						if (IsSet($HTTP_POST_VARS['refer_to']))
							$menuAction = urldecode($HTTP_POST_VARS['refer_to']);

						if ($HTTP_POST_VARS['DCLUI'] == 1 || $HTTP_POST_VARS['DCLUI'] == 2) // Tree/Frames
							Refresh('listFrame.php?' . $menuAction, $id, $thispwd, $HTTP_POST_VARS['DCLUI'], $HTTP_POST_VARS['LANG'], $HTTP_POST_VARS['DOMAIN']);
						else
							Refresh('main.php?' . $menuAction, $id, $thispwd, $HTTP_POST_VARS['DCLUI'], $HTTP_POST_VARS['LANG'], $HTTP_POST_VARS['DOMAIN']);
					}
					else
						Refresh('index.php?cd=1');
				}
				else
					Refresh('index.php?cd=1');
			}
			else
				Refresh('index.php?cd=1');
		}
	}
	else
		Refresh('index.php?cd=3');
}
?>
