/* -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * Exception.h
 *   Header for the exception handler class.
 *
 * $Id: Exception.h,v 1.8 2002/04/08 07:11:28 benoit Exp $
 *
 * Copyright (c) 2000-2001 Remi Lefebvre <remi@debian.org>
 * Copyright (c) 2000 Benoit Joly <benoit@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#include <string>

#ifndef EXCEPTION_H
#define EXCEPTION_H

/**
 * Generic exception class for DDT
 */

class DdtException
{
  public:
    /// Default Constructor
    DdtException() { debugMessage = "generic error"; }
    
    /// Constructor
    DdtException(const char *errmsg) { debugMessage = errmsg; }

    /// Destructor
    virtual ~DdtException() { }

    /// return error message
    virtual std::string message() const { return debugMessage; }
    
  protected:
    /// A variable to contain a string error message.
    std::string debugMessage;
    
};


/**
 * Class representing a Database specific error
 */
class DbError : public DdtException
{
  public:
    /// default constructor
    DbError() { }

    /// constructor taking an error string argument
    DbError(const char *errmsg) { debugMessage = errmsg; }
};


#endif
