/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * $Id: UDP.h,v 1.6 2000/12/27 16:59:27 rex Exp $
 *
 * Copyright (c) 2000 Remi Lefebvre  <remi@dhis.net>
 *                and Luca Filipozzi <lfilipoz@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#ifndef UDP_H
#define UDP_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <iostream>
//#include <unistd.h>
//#include <fcntl.h>
#include <netinet/in.h>

class UDP
{
  public:
    UDP (unsigned int clientport, unsigned int serverport);   // server constructor
    UDP (char *hostaddr, unsigned int clientport, unsigned int serverport); // client constructor
    ~UDP ();

    // server
    int recv   (void *buf, int bufSize, unsigned long *from);
    int sendTo (unsigned long ipAddress, void *buf, int bufSize);

    // client
    int send   (void *buf, int bufSize);
    
  protected:
    UDP () { /* hide the default constructor */ };

  private:
    unsigned int clientport_;
    unsigned int serverport_;

    struct sockaddr_in  server_addr_;
    struct sockaddr_in  client_addr_;
    bool isClient_;

  public:
    int send_sd_;
    int recv_sd_;
};

#endif // UDP_H
