/* -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * Mutex.cc
 *
 * $Id: Mutex.cc,v 1.3 2000/12/27 16:59:27 rex Exp $
 *
 * Copyright (c) 2000 Benoit Joly <benoit@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#include <pthread.h>
#include <errno.h>
#include "Mutex.h"
#include "Exception.h"

Mutex::Mutex ()
{
    int l_error;
    l_error = pthread_mutex_init (&a_mutex, NULL); //static mutex
    if (l_error != 0)
    {
        switch (l_error)
        {
            case EAGAIN:
                throw DdtException ("Cannot init mutex");
                break;
                
            case ENOMEM:
                throw DdtException ("No memory available");
                break;
                
            case EPERM:
                throw DdtException ("Dont have permission");
                break;
                
            case EBUSY:
                throw DdtException ("Cannot init mutex");
                break;
                
            case EINVAL:
                throw DdtException ("Invalid Mutex");
                break;
                
            default:
                throw DdtException ("DEFAULT ERROR");
                break;	 
        }
    }
}

Mutex::~Mutex ()
{
    pthread_mutex_destroy(&a_mutex);
}

void Mutex::lock ()
{
    int l_error;
    l_error = pthread_mutex_lock (&a_mutex);
    if (l_error == 0)
    {
        return;
    }
    else
    {
        switch (l_error)
        {
            case EINVAL:
                throw DdtException ("Invalid mutex");
                break;
                
            case EAGAIN:
                throw DdtException ("Invalid mutex");
                break;
                
            case EDEADLK:
                throw DdtException ("Already own this mutex");
                break;
                
            case EPERM:
                throw DdtException ("Dont have permisision");
                break;

            default:
                throw DdtException ("DEFAULT ERROR");
                break;
        }
    }
}

void Mutex::unlock ()
{
    int l_error;
    l_error = pthread_mutex_unlock (&a_mutex);
    if (l_error == 0)
    {
        return;
    }
    else
    {
        switch(l_error)
        {
            case EINVAL:
                throw DdtException ("Invalid mutex");
                break;
                
            case EAGAIN:
                throw DdtException("Invalid mutex");
                break;
                
            case EDEADLK:
                throw DdtException ("Already own this mutex");
                break;
                
            case EPERM:
                throw DdtException ("Dont have permisision");
                break;
                
            default:
                throw DdtException ("DEFAULT ERROR");
                break;
        }
    }
}

bool Mutex::trylock ()
{
    int l_error;
    l_error = pthread_mutex_trylock (&a_mutex);
    if (l_error == 0)
    {
        return true;
    }
    else if (l_error == EBUSY)
    {
        return false;
    }
    else
    {
        switch (l_error)
        {
            case EINVAL:
                throw DdtException ("Invalid mutex");
                break;
                
            case EAGAIN:
                throw DdtException ("Invalid mutex");
                break;
                
            case EDEADLK:
                throw DdtException ("Already own this mutex");
                break;
                
            case EPERM:
                throw DdtException ("Dont have permisision");
                break;
                
            default:
                throw DdtException("DEFAULT ERROR");
                break;
        }
    }
}
