package com.tildemh.debbuggtk;


import org.gnu.gtk.*;
import org.gnu.gnome.*;
import org.gnu.gnome.event.*;

/**
 * Bug reporter page for package specific info
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: BRPackageSpecific.java,v 1.4 2003/12/07 11:09:46 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class BRPackageSpecific extends DruidPageStandard implements DruidPageSetupListener, DruidPageChangeListener {

	private boolean contentSet = false;
	private String pkg = "error - pkg not set";
	private String message = "None";
	private Label head;
	private Label msg;

	public BRPackageSpecific(){
		super();
		addListener( (DruidPageSetupListener) this );
		addListener( (DruidPageChangeListener) this );
		setLogo( BugReporter.getLogo() );
	}

	public void setDetails( String pkg, String message ){
		this.pkg = pkg;
		this.message = message;
		System.out.println("\n\n\nSetting message to\n:"+message);
	}


	public void druidPageSetupEvent( DruidPageSetupEvent event ){
		if ( event.isOfType( DruidPageSetupEvent.Type.PREPARE ) ){
			if (!contentSet){
				// make the page
				setTitle("Package Specific");
				VBox vb = getLayout();

				head = new Label("");
				head.setLineWrap(true);
				vb.packStart(head, false, true, 0);

				msg = new Label("");
				msg.setLineWrap(true);
				ScrolledWindow sw = new ScrolledWindow( new Adjustment(0,0,100,1,10,10), new Adjustment(0,0,100,1,10,10) );
				sw.addWithViewport(msg);
				vb.packStart(sw, true, true, 0);

				Label foot = new Label("Note: The maintainers of the package may have requested this program to do other things too - It's too stupid TODO them at the moment.");
				foot.setLineWrap(true);
				vb.packStart( foot, false, true, 0);

				vb.showAll();
				contentSet = true;
			}
			head.setText( "The Debian maintainers of the "+pkg+" package have requested that the following message is displayed before you report a bug:");
			System.out.println("\n\nSetting message label to \n"+message);
			msg.setText(message);
		}
	}

	public boolean druidPageChangeEvent( DruidPageChangeEvent event ){
		if ( event.isOfType( DruidPageChangeEvent.Type.NEXT ) ){
			// TODO: fix these!
		}else if ( event.isOfType( DruidPageChangeEvent.Type.BACK ) ){
			// TODO: fix these!
		}else if ( event.isOfType( DruidPageChangeEvent.Type.CANCEL ) ){
		}
		return false;
	}
	
}
