package com.tildemh.debbuggtk;

import com.tildemh.debbug.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;

/**
 * <p>Window for creating and editing virtual listings
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: VirtualListingEditor.java,v 1.7 2004/04/21 20:20:05 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class VirtualListingEditor extends Window{
	

	private ListingSelectorHandler handler;
	private static int number =123456;

	private Entry name;

	private SimpleList list;
	
	public VirtualListingEditor(ListingSelectorHandler handler){
		super(WindowType.TOPLEVEL);
		this.handler = handler;
		
		setTitle("New Virtual Listing");
		setModal(true);
		setBorderWidth(15);
		
		VBox vbox = new VBox(false, 15);
		add(vbox);

		Label intro = new Label("Standard listings take lists of bug reports from web servers, usually for a particular package. Virtual listings allow you to define your own listings, for example so you can group together all reports which you're interested in fixing.");
		intro.setLineWrap( true );
		vbox.packStart( intro , false, false, 0 );

		HBox hb = new HBox( false, 0 );
		vbox.packStart(hb, false, false, 0);
		hb.packStart( new Label("Listing Name: "), false, false, 0);
		name = new Entry();
		name.setText("New Listing");
		hb.packStart( name, true, true, 0);
		

		Label l = new Label( "Please enter bug reports to include in the listing. This can be changed later by...  sending me a patch :)" );
		l.setLineWrap(true);
		vbox.packStart( l, false, false, 0 );

		hb = new HBox( false, 0);
		vbox.packStart( hb, true, true, 0);
		
		list = new SimpleList();
		list.setEditable(true);
//		list.setSelectable(true);
		ScrolledWindow sw = new ScrolledWindow(null, null);
		sw.setPolicy( PolicyType.AUTOMATIC, PolicyType.AUTOMATIC );
		sw.add( list );
		hb.packStart( sw, true, true, 0);

		ButtonBox bb = new VButtonBox();
		hb.packStart(bb, false, false, 0);
		bb.setLayout( ButtonBoxStyle.START );

		Button add = new Button( GtkStockItem.ADD );
		bb.packStart(add);
		add.addListener( new ButtonListener(){
			public void buttonEvent( ButtonEvent e ){
				if (e.isOfType(ButtonEvent.Type.CLICK)){
					list.addEnd("" + number++);
				}
			}
		});

		Button rm = new Button( GtkStockItem.REMOVE );
		bb.packStart( rm );
		rm.addListener( new ButtonListener(){
			public void buttonEvent( ButtonEvent e ){
				if (e.isOfType(ButtonEvent.Type.CLICK)){
					for(int i = 0; i < list.getSize(); i++){
						if (list.getSelected(i)){
							list.remove(i);
							i--;
						}
						
					}
				}
			}
		});

				
		bb = new HButtonBox();
		bb.setLayout(ButtonBoxStyle.END);

		Button apply = new Button(GtkStockItem.APPLY);
		apply.addListener( new ButtonListener(){
			public void buttonEvent( ButtonEvent event ){
				if (event.isOfType( ButtonEvent.Type.CLICK )){
					apply();
				}
			}
		});
		bb.add(apply);
				
		
		Button close = new Button(GtkStockItem.CANCEL);
		close.addListener( new ButtonListener(){
			public void buttonEvent( ButtonEvent event ){
				if (event.isOfType( ButtonEvent.Type.CLICK )){
					closeWin();
				}
			}
		});
		bb.add(close);
		vbox.packStart(bb, false, false, 0);
		//showAll();
	}

	/**
	 * Closes the window
	 */
	private void closeWin(){
		hide();
	}

	private void apply(){
		
		// todo check listing doesn't already exist
		if (Cache.getInstance().virtualListingExists( name.getText() ) ){
			MessageDialog md = new MessageDialog(this , DialogFlags.MODAL.or(DialogFlags.DESTROY_WITH_PARENT), MessageType.ERROR, ButtonsType.CLOSE, 
					"A virtual listing with that name already exists. Please chose a different name", true);
			md.run();
			md.destroy();
			return;
		}
			
		// make new virtual listing
		Listing l = null; // TODO new Listing( ListingType.VIRTUAL, name.getText() );
		int[] bugNumbers = new int[list.getSize()];
		for( int i = 0; i < list.getSize(); i++){
			bugNumbers[i] = Integer.parseInt( list.getValue(i) );
		}
//TODO		l.setBugNumbers( bugNumbers );
		Cache.getInstance().store( l );

		handler.listingSelected( l.getName(), l.getType() );

		// close window
		hide();
	}

		
}
