package com.tildemh.debbuggtk;

import com.tildemh.debbug.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;
import java.io.*;

/**
 * Simple program to display a bug report
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: BugViewer.java,v 1.4 2002/12/23 15:23:16 mark Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class BugViewer{
	
	/**
	 * Create a new window
	 */
	public BugViewer(Bug bug){
		makeWindow(bug);
	}

	private Entry number;
	private BugReport report;
	private Window window;
	private BTS bts;

	private void makeWindow(Bug bug){
		window = new Window(WindowType.TOPLEVEL);
		window.setTitle("Debian Bug Report Viewer - #"+bug.getNumber()+" - "+bug.getTitle());
		window.addListener(new LifeCycleListener() {
                        public void lifeCycleEvent(LifeCycleEvent event) {
                                if (event.isOfType(LifeCycleEvent.Type.DELETE) || event.isOfType(LifeCycleEvent.Type.DESTROY))
                                        Gtk.mainQuit();
                        }
                });


		VBox vbox = new VBox(false, 0);
		window.add(vbox);

		
		HBox controlBox = new HBox(false, 10);
		vbox.packStart(controlBox, false, false, 10);
	

		Label no = new Label("Bug #");
		controlBox.packStart(no, false, false, 0);

		number = new Entry();
		controlBox.packStart(number);

		Button change = new Button(GtkStockItem.APPLY);
		change.addListener( new ButtonListener(){
			public void buttonEvent( ButtonEvent event ){
				if (event.isOfType( ButtonEvent.Type.CLICK )){
					setBug( number.getText() );
				}
			}
		});
		
		controlBox.packStart(change);

		Button newWin = new Button(GtkStockItem.NEW);
		controlBox.packStart(newWin);

		HSeparator hs = new HSeparator();
		vbox.packStart(hs, false, false, 0);

		bts = new BTS();
		report = new BugReport(bug, bts);
		vbox.packStart(report, true, true, 0);
		
		window.showAll();
	}

	public void setBug(String bugNo){
		try{
			Bug bug = loadBug(bugNo);
			window.setTitle("Debian Bug Report Viewer - #"+bug.getNumber()+" - "+bug.getTitle());
			report.setBug(bug);
		}catch(Exception e){
			// todo - show an error message
			System.err.println(e.toString());
		}
	}
	
	private Bug loadBug(String toShow) throws Exception{
		Bug bug;
		File f = new File(toShow);
		if (f.exists()){
			StringBuffer htmlPage = new StringBuffer();
			FileReader reader = new FileReader(toShow);
			int ch =0;
			while ((ch = reader.read()) != -1){
				htmlPage.append((char)ch);
			}
		
			bug = WWWBugParser.makeBug(htmlPage.toString());
		}else{
			BTS bts = new BTS();
			bug = bts.getBug(Integer.parseInt(toShow), false);
		}
		return bug;
	}
		

	/**
	 * shows a bug report 
	 * @param toshow bug number to download, or filename.
	 */
	public BugViewer(String toShow) throws Exception{
		makeWindow( loadBug( toShow ) );
	}

	public static void main(String[] args){
		if (args.length != 1){
			System.out.println("Usage: viewbug bug_number");
			System.exit(1);
		}
		
		Gtk.init(args);
		try{
			BugViewer vb = new BugViewer(args[0]);
			Gtk.main();
		}catch(Exception e){
			System.out.println("An exception occured: "+e);
			System.out.println("Debugging Information:");
			e.printStackTrace();
		}
	}
}
