package com.tildemh.debbuggtk;

import com.tildemh.debbug.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;
import org.gnu.gnome.*;
import org.gnu.gnome.event.*;
import org.gnu.gdk.*;
import org.gnu.glib.Type;
import java.io.*;

/**
 * Application for monitoring bugs in the Debian Bug Tracking System (bts).
 *
 * <p>This will eventually work in a similar way to an email on nntp client -
 * you will select a number of packages to monitor (set up email acount /
 * subscrie to newsgroup); then a list of bugs will be downloaded. Whenever you
 * synchronise with the server, updated items will be highlighted.
 *
 * <p>The interaction with the bts is done through the {@link
 * com.tildemh.jdebbug} package. Much of the functionality of viewing package
 * bug listings and bug reports is done elsewhere in the {@link
 * com.tildemh.debbuggtk} package. These are also used in a number of other
 * applications, such as {@link com.tildemh.debbuggtk.BugViewer} 
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: BugWatcher.java,v 1.8 2002/12/23 16:12:54 mark Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class BugWatcher implements MenuItemListener, ButtonListener{

//	private App app;
	private org.gnu.gtk.Window app;
	private AppBar appbar;

	private BugReport report;
	private PkgReport listing;
	private BTS bts;
	
	/**
	 */
	public BugWatcher(){
		bts = new BTS();
		app = new org.gnu.gtk.Window(org.gnu.gtk.WindowType.TOPLEVEL);
		app.setTitle("BugWatcher");
//		app = new App("BugWatcher", "bw");
		app.addListener(new LifeCycleListener() {
			public void lifeCycleEvent(LifeCycleEvent event) {
				if (event.isOfType(LifeCycleEvent.Type.DELETE) || event.isOfType(LifeCycleEvent.Type.DESTROY))
					Gtk.mainQuit();
			}
		});

		// Create and add the AppBar
//		appbar = new AppBar(true, true, PreferencesType.ALWAYS);
//		app.setStatusBar(appbar);

		// Create and add the Menu
//		UIInfo[] menuInfo = buildMyMenus();
//		app.createMenus(menuInfo);
//		app.installMenuHints(menuInfo);
		
		// create the ToolBar
//		app.createToolBar(buildMyToolbar());

		// create the main window area
		app.add(buildMainView());
//		app.setContent(buildMainView());
			
		app.showAll();
	}


	/**
	 * build the menus
	 */
	protected UIInfo[] buildMyMenus() {

		UIInfo fileMenu[] = {
//				UIInfo.newItem("New Window", "Open a new application window", (MenuItemListener)this),
/*				UIInfo.separator(),
				UIInfo.openItem((MenuItemListener)this),
				UIInfo.saveItem((MenuItemListener)this),
				UIInfo.saveAsItem((MenuItemListener)this),
				UIInfo.revertItem((MenuItemListener)this),
				UIInfo.printItem((MenuItemListener)this),
				UIInfo.printSetupItem((MenuItemListener)this),
				UIInfo.separator(),
				UIInfo.closeItem((MenuItemListener)this),
				UIInfo.quitItem((MenuItemListener)this),
				UIInfo.end()
		*/
		};

		 UIInfo helpMenu[] = {
/*			UIInfo.aboutItem(new MenuItemListener() {
				public void menuItemEvent(MenuItemEvent event) {
						helpAbout();
				}
			}),
			UIInfo.end()
*/		};

		 UIInfo mainMenu[] = {
/*			UIInfo.subtree("_File", fileMenu),
			UIInfo.subtree("_Help", helpMenu),
			UIInfo.end()
*/		};

		return mainMenu;
	}


	/**
	 * build toolbar
	 */
	protected UIInfo[] buildMyToolbar() {
		UIInfo toolbar[] = {
/*				UIInfo.itemStock("Cut", "Cut", (ButtonListener)this, GnomeStockItem.CUT),
				UIInfo.itemStock("Copy", "Copy", (ButtonListener)this, GnomeStockItem.COPY),
				UIInfo.itemStock("Paste", "Paste", (ButtonListener)this, GnomeStockItem.PASTE),
				UIInfo.separator(),
				UIInfo.itemStock("Clear", "Clear", (ButtonListener)this, GnomeStockItem.CLEAR),
				UIInfo.separator(),
				UIInfo.itemStock("Quit", "Quit", (ButtonListener)this, GnomeStockItem.QUIT),
				UIInfo.end()
*/		};

		return toolbar;
	}


	TreeView pkgView;
	ListStore pkgStore;
	
	/**
	 * build the main page content
	 */
	public VBox buildMainView() {
		VBox mainBox = new VBox(false, 10);
                

		///////////////////////////
		// Main layout
		VPaned mainPanes = new VPaned();
		
		HPaned topBox = new HPaned();
		mainPanes.pack1(topBox, false, true);

		/// TODO!!!!
		PkgReportListener listingListener = new PkgReportListener(){
			public void selChanged(com.tildemh.debbug.Bug bug){
				System.out.println("Selected bug "+bug.getNumber());
//				report.setBug(Integer.toString(bug.getNumber()));
				try{
					report.setBug( bts.getBug(bug.getNumber(), false) );
				}catch(Exception e){
					System.out.println("ERROR: getting bug "+e);
					e.printStackTrace();
				}
			}
		};
		listing = new PkgReport(listingListener);
		ScrolledWindow listWin = new ScrolledWindow( new Adjustment(0,0,0,0,0,0), new Adjustment(0,0,0,0,0,0));
		listWin.setPolicy( PolicyType.AUTOMATIC, PolicyType.AUTOMATIC);
//		listWin.setShadowType( ShadowType.ETCHED_IN );
		listWin.add(listing);
		topBox.pack2(listWin, true, true);



		report = new BugReport(bts);
		mainPanes.pack2(report, true, true);

		
		pkgStore = new ListStore( new Type[] { Type.JAVA_OBJECT(), Type.STRING(), Type.STRING() } );
		pkgView = new TreeView( pkgStore );
		
		TreeViewColumn col1 = new TreeViewColumn();
		CellRendererText rend = new CellRendererText();
		col1.packStart(rend, false);
		col1.addAttributeMapping( rend, CellRendererText.Attribute.TEXT, 2);
		pkgView.appendColumn(col1);
		
		TreeViewColumn col2 = new TreeViewColumn();
		CellRendererText rend2 = new CellRendererText();
		col2.packStart(rend2, false);
		col2.addAttributeMapping( rend2, CellRendererText.Attribute.TEXT, 1);
		pkgView.appendColumn(col2);
		
//		pkgView.setHeadersVisible(false);
		pkgView.getSelection().addListener( new TreeSelectionListener(){
			public void selectionChangedEvent(TreeSelectionEvent event){

				TreeSelectionForEach fe = new TreeSelectionForEach(){
					public void forEach(TreeModel model, TreePath path, TreeIter iter){
						ListingType type = (ListingType) pkgStore.getObjectValue(iter, 0);
						String pkg = pkgStore.getStringValue(iter, 1);
						
						try{
							Listing list = bts.getListing( type,  pkg, false, false );
							listing.setPackage( list );
						}catch( ListingNotFound e ){
							// fixme
							e.printStackTrace();
						}catch( ServerError e ){
							e.printStackTrace();
							//fixme
						}
			
					}
				};				
				pkgView.getSelection().forEachSelected(fe);
			}
});

		ScrolledWindow pkgWin = new ScrolledWindow( new Adjustment(0,0,0,0,0,0), new Adjustment(0,0,0,0,0,0));
		pkgWin.setPolicy( PolicyType.AUTOMATIC, PolicyType.AUTOMATIC);
		pkgWin.add(pkgView);
		topBox.pack1(pkgWin, false, true);
		
		TreeIter iter = pkgStore.appendRow();
		pkgStore.setValue(iter, 0, ListingType.MAINT);
		pkgStore.setValue(iter, 1, "mh@debian.org");
		pkgStore.setValue(iter, 2, "Maintainer");
		
		iter = pkgStore.appendRow();
		pkgStore.setValue(iter, 0, ListingType.SOURCE);
		pkgStore.setValue(iter, 1, "galeon-snapshot");
		pkgStore.setValue(iter, 2, "Source");
		
		iter = pkgStore.appendRow();
		pkgStore.setValue(iter, 0, ListingType.SOURCE);
		pkgStore.setValue(iter, 1, "galeon");
		pkgStore.setValue(iter, 2, "Source");
		
		iter = pkgStore.appendRow();
		pkgStore.setValue(iter, 0, ListingType.SOURCE);
		pkgStore.setValue(iter, 1, "gjdoc");
		pkgStore.setValue(iter, 2, "Source");
		
		iter = pkgStore.appendRow();
		pkgStore.setValue(iter, 0, ListingType.SOURCE);
		pkgStore.setValue(iter, 1, "evolution");
		pkgStore.setValue(iter, 2, "Source");
		
		
		mainBox.add(mainPanes);
                
		return mainBox;
	}


	/**
	 * Handler for help-&gt;about
	 */
	 public void helpAbout() {
		String title = "BugWatcher";
		String version = "Version 0.0.0";
		String license = "LGPL";
		String comments = "Debian Bug Tracking System Monitor";
		String[] authors = { "Mark Howard <mh@tildemh.com>"};
		String[] documenters = { "Mark Howard <mh@tildemh.com>"};
		String translator = "None yet...";
		About about = new About(title, version, license, comments, authors, documenters, translator, (Pixbuf) null);
		about.show();
	}

	 public static void main(String[] args) {


		 Gtk.init(args);
//		Program prog = Program.initGnomeUI("BugWatcher", "1.0", args);
		BugWatcher bw = new BugWatcher();

		Gtk.main();
	}

	

	/**
	 *//////////////////////////////////////
	// Callback for the menu events
        public void menuItemEvent(MenuItemEvent event) {
//                app.message("menu callback");
        }
        
        public void buttonEvent(ButtonEvent event) {
        }


		
//	private MenuItemListener newListener =  new MenuItemListener(){
//			public void menuItemEvent(org.gnu.gtk.event.MenuItemEvent event){
//				PkgSelector sel = new PkgSelector();
//				sel.showAll();
//			}
//	};

}
