package com.tildemh.debbuggtk;

import com.tildemh.debbug.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;
import java.io.*;
import java.util.*;

/**
 * List of Listings which are being watched. This is used so that the package
 * list can be loaded and saved when needed. At some point, it will probably
 * also include detailes of which bug reports have been read, etc.
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: WatchedList.java,v 1.1 2002/12/23 16:12:54 mark Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class WatchedList implements Serializable{

	private transient LinkedList items;
	private Item[] itemArray;

	/**
	 * Sun's jvm doesn't work with libc at the moment. GIJ doesn't seem to be
	 * working either. kaffe works fine... except it can't serialize
	 * LinkedLists. we convert them to arrays so all will be well.
	 */
	 private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException{
		 Object[] objs = items.toArray();
		 itemArray = new Item[ objs.length ];
		 for (int i =0; i< objs.length; i++){
			 itemArray[i] = (Item) objs[i];
		 }
		 out.defaultWriteObject();
	 }
	 /**
	  * Convert arrays back to linkedlists.
	  */
	 private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException{
		 in.defaultReadObject();
		 items = new LinkedList();
		 for(int i = 0; i < itemArray.length; i++){
			 items.addLast( itemArray[i] );
		 }
		 itemArray = null;
	 }

	 public void save() throws IOException{
		File f = new File( System.getProperty("user.home") +"/.debbug-java/bugwatcher/watched" );
		 System.out.println("DEBUG: writing watched list to "+f.toString() );
		
		ObjectOutputStream out = new ObjectOutputStream( new FileOutputStream(f) );

		out.writeObject(this);
		out.flush();
		out.close();
	 }

	 public static WatchedList load() throws IOException, Exception{
		 File f = new File( System.getProperty("user.home") +"/.debbug-java/bugwatcher/watched" );
		System.out.println("DEBUG: reading file from " + f.toString() );
		
		if (!f.exists()) throw new IOException("Watched list doesn't exist");

		WatchedList list = null;
		try{
			ObjectInputStream in = new ObjectInputStream( new FileInputStream(f) );
			Object o = in.readObject();
			in.close();
			if (! (o instanceof WatchedList)){
				throw new Exception("WatchedList file not instance of WatchedList");
			}
			list = (WatchedList) o;
		}catch(OptionalDataException e){
			e.printStackTrace();
			throw new Exception("File found - OptionalDataException: "+e);
		}catch(ClassNotFoundException e){
			e.printStackTrace();
			throw new Exception("File Found - ClassNotFoundException: "+e);
		}catch(IOException e){
			e.printStackTrace();
			throw new Exception("File Found - IOException: "+e);
		}
		return list;

	 }

	
	public WatchedList(){
	}

	public void add(Item item){
		items.add(item);	
	}
	public LinkedList getItems(){
		return items;
	}

	public class Item implements Serializable{
		private ListingType type;
		private String name;
		
		public Item(ListingType type, String name){
			this.type = type;
			this.name = name;
		}
		public ListingType getType(){
			return type;
		}
		public String getName(){
			return name;
		}
	}
}
	
