package com.tildemh.debbug;


/**
 * Debian Bug Tracking System interaction. This class is used to obtain bug
 * reports and listings. Methods will take simple package name or bug number
 * inputs and this class will determine whether to download the reports, or use
 * the versions in cache.
 *
 * <p>todo: get bugs/listings in background using a separate thread. 
 * 
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: BTS.java,v 1.35 2004/06/29 12:04:46 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class BTS{

	private Cache cache;
	private static BTS instance = null;
	private static final boolean DEBUG = false;
	public static Thread GUITHREAD = null;

	/**
	 * Creates a new BTS Object
	 */
	private BTS(){
		cache = Cache.getInstance();
	}
	public static BTS getInstance(){
		if (null == instance) instance = new BTS();
		return instance;
	}

	/**
	 * Returns a bug report, or a new report with no content (in which case
	 * bug.update() should be called).
	 */
	public Bug getBug( Integer bugNumber ){
		int number = bugNumber.intValue();
		Bug bug = null;
		try{ 
			bug = cache.getBug(number, true);
		}catch(CacheMiss e){
			if (DEBUG) System.out.println("DEBUG: cache miss "+number+"\n"+e);
		}catch(CacheError e){
			if (DEBUG) System.out.println("DEBUG: cache error "+number+"\n"+e);
		}
		if (bug == null){
			if (DEBUG) System.out.println("BTS.getBug() - making new bug");
			bug = Bug.makeBug( bugNumber );
		}

		return bug;
	}

    /**
	 * Returns a listing, possibly an empty one;
	 */
	public Listing getListing( ListingType type, String name ){
		if (DEBUG) System.out.println("BTS.getListing()"+type+name);
		return getListing( new ListingStub(type,name) );
	}
	public Listing getListingIfCached( ListingStub stub ){		
		Listing list = null;
		try{ 
			if (DEBUG) System.out.println("1");
			list = cache.getListing( stub );
			if (DEBUG) System.out.println("1");
		}catch(CacheMiss e){
			e.printStackTrace();
			list = null;
		}catch(CacheError e){
			e.printStackTrace();
			// TODO: handle better
			list = null;
		}
		return list;
	}
	public Listing getListing( ListingStub stub ){
		Listing list = getListingIfCached( stub );
		if (list == null){
			list = Listing.makeListing( stub );
			cache.store( list );
		}
		return list;
	}

}
