package com.tildemh.debbug;

//import java.util.Locale;
//import java.util.LinkedList;

/**
 * Status field for a bug report or listing. This is related to how the user has
 * interacted with the bug - whether they have read the bug, commented on the
 * bug, are interested in the bug, or whether it has been updated since the user
 * last read it. 
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: Status.java,v 1.4 2003/07/01 19:43:19 mark Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class Status implements java.io.Serializable{

	private int value;		// integer representation
	private String name;		// name 


	/** 
	 */
	public Status(int value, String name){
		this.value = value;
		this.name = name;
	}

	public static transient Status NEW = new Status(0, "New");
	public static transient Status READ = new Status(1, "Read");
	public static transient Status UPDATED = new Status(2, "Updated");
	public static transient Status INVALID = new Status(3, "Invalid");

	/**
	 * @return true if two tags are the same
	 */
	public boolean equals ( Status test ){
		return this.value == test.getValue();
	}

	public static Status parse( String s ){
		if( s.equals("New")){
			return NEW;
		}else if (s.equals("Read")){
			return READ;
		}else if (s.equals("Updated")){
			return UPDATED;
		}else{
			throw new RuntimeException("Unknown status - "+s);
			// TODO: don't use a runtimeexception
		}
	}
	
	/** 
	 * @return internal representation of tag
	 */
	public int getValue(){
		return value;
	}

	/**
	 */
	public String toString(){
		return name;
	}
}
