package com.tildemh.debbuggtk;

import org.gnu.gtk.*;
import org.gnu.gtk.event.*;
import org.gnu.glade.*;
import org.gnu.gnome.*;
import java.io.*;

/**
 * Dialog to show on exit if there remain pending items in the control queue
 * 
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: ExitWarning.java,v 1.3 2004/04/21 20:20:05 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class ExitWarning implements LifeCycleListener{
	

	public static void run(){
		if (! ControlQueue.getInstance().isEmpty() ){
			new ExitWarning();
		}else{
			Gtk.mainQuit();
		}
	}

	private org.gnu.gtk.Window app;
	/**
	 */
	private ExitWarning(){
		WindowIcon.setDefaultIcon(DebbugGtk.ICON);
		
		String filename = DebbugGtk.GLADE_XML_DIR+"exitwarning.glade";
		LibGlade glade = null;
		try {
			glade = new LibGlade(filename, this, null);
			app = (Window) glade.getWidget("exitWarning");
			app.addListener( (LifeCycleListener) this  );
			app.showAll();
		} catch (GladeXMLException e) {
			System.err.println("Error parsing glade XML file." + e);
		} catch (FileNotFoundException e) {
			System.err.println("Glade XML file not found.");
		} catch (IOException e) {
			System.err.println("Error reading glade XML file.");
		}
	}

////////////////////////////////////////////////////////////////////////////////
// Events defined in the glade file.
////////////////////////////////////////////////////////////////////////////////
	
	public void sendControl(){
		ControlQueue.getInstance().generateMail();
		exit();
	}

	public void exit(){
		app.hide();
		Gtk.mainQuit();
	}


	public void lifeCycleEvent(LifeCycleEvent event) {
				//ignore
	}
	public boolean lifeCycleQuery(LifeCycleEvent event ){
		if (event.isOfType(LifeCycleEvent.Type.DELETE) ){
			System.err.println("Delete event - returning true");
			exit();
			return true;
		}else{
			System.err.println("Destroy event - returning false");
			 event.isOfType(LifeCycleEvent.Type.DESTROY);
			exit();
			 return false;
		}
	}

		
}
