package com.tildemh.debbuggtk;



/**
 * State of the listing viewer
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: ListingState.java,v 1.12 2003/08/31 13:30:40 mark Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class ListingState {
	
	private int id; 
	private int current;
	private int max;
	private String desc;
	private int bug;

	private ListingState( int id, int current, int max, String desc ){
		this.id = id;
		this.current = current;
		this.max = max;
		this.desc = desc;
	}

	public static ListingState IDLE = 			new ListingState(0, 0, 1, "Idle");
	public static ListingState FILTERING =	 	new ListingState( 1, 0, 1, "Filtering reports");
	public static ListingState LOADING = 		new ListingState( 2, 0, 1, "Loading reports");
	public static ListingState REFRESHING = 	new ListingState( 3, 0, 1, "Refreshing reports");
	public static ListingState ERROR = 			new ListingState( 4, 0, 1, "Error" );
	public static ListingState DLLISTING = 		new ListingState( 5, 0, 1, "Loading package list" );
	public static ListingState UPDATING = 		new ListingState( 6, 0, 1, "Contacting server..." );
	public static ListingState INTERPRET_LISTING = 		new ListingState( 7, 0, 1, "Interpreting listing" );

	public boolean ofType( ListingState other ){
		return id == other.getID();
	}

	public int getID(){
		return id;
	}
	public int getCurrent(){
		return current;
	}
	public ListingState nextState(){
		return new ListingState( id, current + 1, max, desc);
	}

	public void setCurrent( int current ){
		this.current = current;
	}
	public int getMax(){
		return max;
	}
	public void setMax( int max ){
		this.max = max;
	}
	public String getDesc(){
		return desc;
	}
	public void setBug( int bug ){
		this.bug = bug;
	}
	public int getBug(){
		return bug;
	}

	public static ListingState filtering( int max ){
		return new ListingState(1, 0, max, "Filtering reports");
	}
	public static ListingState loading( int max ){
		return new ListingState(2, 0, max, "Loading reports");
	}
	public static ListingState refreshing( int max ){
		return new ListingState(3, 0, max, "Refreshing reports");
	}
	public static ListingState error( int current, int max, String msg ){
		return new ListingState(4, current, max, msg);
	}

	public String toString(){
		if (id == 1 || id == 2 || id ==3)
			return desc + " ("+current+"/"+max+") Next: #"+bug;
		else
			return desc;
	}
		
}

