package com.tildemh.debbuggtk;

import java.util.*;

/**
 * Various utility methods
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: Util.java,v 1.2 2004/03/20 17:02:32 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2004
 */
public class Util{
	
	private Util(){ // no instantiation
	}

	public static String wordWrap( String source, int length ){
		StringBuffer result = new StringBuffer();

		StringTokenizer lineTok = new StringTokenizer( source, "\n", true );
		String line;
		try{
			while( true ){
				line = lineTok.nextToken();
				// break line if > 80 chars
				StringTokenizer wordTok = new StringTokenizer( line, " \t\n\r\f", true );
				StringBuffer wrappedLine = new StringBuffer();
				
				try{
					
					while ( true ){
						if (wrappedLine.equals(" "))
							wrappedLine = new StringBuffer();
						if (wrappedLine.equals("\n "))
							wrappedLine = new StringBuffer("\n");
						String next = wordTok.nextToken();
						if (wrappedLine.length() == 0 && next.length() > length ){
							// line > length. split by character
							while( next.length() > length ){
								result.append( next.substring(0, length) );
								result.append( "\n" );
								next = next.substring( length );
							}
							if (next.equals(" ")){
								wrappedLine = new StringBuffer();							
							}else{
								wrappedLine = new StringBuffer( next );							
							}
						}else if (wrappedLine.length() + next.length() > length){
							// break the line
							result.append( wrappedLine );
							result.append( "\n" );
							if (next.equals(" ")){
								wrappedLine = new StringBuffer();							
							}else{
								wrappedLine = new StringBuffer( next );							
							}
						}else{
							wrappedLine.append(next);
						}
					}
					
				}catch(NoSuchElementException e){
				}
				
				result.append( wrappedLine );
			}
		}catch(NoSuchElementException e){
			// we're done!
		}

		return result.toString();		
	}

}
