/* usplash
 *
 * usplash-testcard-theme.c - definition of testcard theme
 *
 * Copyright (c) 2006 Petter Reinholdtsen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

 /* Based on usplash-testcard-theme.c from the usplash package */

#include "usplash-theme.h"

/* Pixmap structure from autogenerated debian-edu-usplash.c */
extern struct bogl_pixmap pixmap___debian_edu_usplash;

/* Font structure built-in to bogl */
extern struct bogl_font font_helvB10;

/* Theme definition */
struct usplash_theme usplash_theme = {
  .version = THEME_VERSION,

  /* Background and font */
  .pixmap = &pixmap___debian_edu_usplash,
  .font   = &font_helvB10,

  /* Palette indexes */
  .background             = 0x0,
  .progressbar_background = 0x8,
  .progressbar_foreground = 0x9,
  .text_background        = 0x0,
  .text_foreground        = 0xf,
  .text_success           = 0xf,
  .text_failure           = 0x4,

  /* Progress bar position and size in pixels */
  .progressbar_x      = 200,
  .progressbar_y      = 240,
  .progressbar_width  = 240,
  .progressbar_height = 10,

  /* Text box position and size in pixels */
  .text_x      = 140,
  .text_y      = 256,
  .text_width  = 360,
  .text_height = 124,

  /* Text details */
  .line_height  = 15,
  .line_length  = 32,
  .status_width = 30,
};
