#!/bin/bash

# $Id: nightkill.sh,v 1.2 2004/04/25 19:56:24 pere Exp $
# This script could be run every night, to kill stray processes. 

KEEPONES="root USER daemon"
USERLIMIT=10000

# New location for config file [pere 2004-04-25]
if [ -f /etc/skolelinux/nightkill.conf ] ; then 
  mv /etc/skolelinux/nightkill.conf /etc/debian-edu/nightkill.conf
fi

if [ -f /etc/debian-edu/nightkill.conf ] ; then 
  . /etc/debian-edu/nightkill.conf
fi 

for EVERY in $KEEPONES ; do 
  KEEP="${KEEP:+$KEEP|}^$EVERY"
done


ps auxw | grep -vE $KEEP | \
  while read PUSER PID NULL ; do 
    [ $(id -u $PUSER) -ge $USERLIMIT ] && kill $PID ; 
  done

sleep 10
  
ps auxw | grep -vE $KEEP | \
  while read PUSER PID NULL ; do 
    [ $(id -u $PUSER) -ge $USERLIMIT ] && kill -9 $PID ; 
  done
