# debpartial-mirror - partial debian mirror package tool
# (c) 2004 Otavio Salvador <otavio@debian.org>, Henrique Vilela <jacare@ucpel.tche.br>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
# $Id$

import ConfigParser

# Process the configuration options
class Config:
    # Initialize these vars
    __mirror = {}
    __dists = {}
    __exclude = {}

    __suggests = ""
    __recomends = ""
    __provides = ""
    
    def __init__(self, filename):
        cnf = ConfigParser.ConfigParser()
        cnf.read(filename)
        for section in cnf.sections():
            for option in cnf.options(section):
                if section == "mirror":
                    if option == "archs" or option == "files":
                        self.__mirror[option] = cnf.get(section, option).split(" ")
                    else:
                        self.__mirror[option] = cnf.get(section, option)
                else:
                    if not self.__dists.has_key(section):
                        self.__dists[section] = {}
                        self.__exclude[section] = []


                    if option == "filter" or option == "packages":
                        filters = cnf.get(section, option).split(" ")

                        for rule in filters:
                            rule = rule.split(":")

                            if not self.__dists[section].has_key(rule[0]):
                                self.__dists[section][rule[0]] = []

                            if option == "filter":
                                self.__dists[section][rule[0]].append({"section": rule[1], "priority": rule[2], "package": "*"})
                            else:
                                self.__dists[section][rule[0]].append({"section": "*", "priority": "*", "package": rule[1]})
                    elif option == "exclude":
                        filters = cnf.get(section, option).split(" ")

                        for rule in filters:
                            self.__exclude[section].append(rule)
                    elif option == 'include-task' or option == 'exclude-task':
                        self.__dists[section][option] = cnf.get(section, option)
                    else:
                        raise IOError, option + ' is unknowdow, please check your configuration file.'

    def getValue(self, section, option):
        if self.__options.has_key(section):
            if self.__option[section].has_key(option):
                return self.__option[section][option]
        return ""
        
    def getMirror(self):
        return self.__mirror

    def __getMirrorOption(self, option):
        if self.__mirror.has_key(option):
            return self.__mirror[option]
        return ""

    def getServer(self):
        return self.__getMirrorOption("server");

    def getArchs(self):
        return self.__getMirrorOption("archs");

    def getFiles(self):
        return self.__getMirrorOption("files");

    def getLocalDirectory(self):
        return self.__getMirrorOption("local_directory");

    def getDists(self):
        return self.__dists

    def getSuggests(self):
        if self.__getMirrorOption('get_suggests') == 'true':
            return True
        else:
            return False
        
    def getRecomends(self):
        if self.__getMirrorOption('get_recomends') == 'true':
            return True
        else:
            return False

    def getProvides(self):
        if self.__getMirrorOption('get_provides') == 'true':
            return True
        else:
            return False

    def getSections(self, dist_name):
        if self.__dists.has_key(dist_name):
            dists = {}
            for d in self.__dists[dist_name].keys():
                if d != 'include-task' and d != 'exclude-task':
                    dists[d] = self.__dists[dist_name][d]
            return dists
        return ""

    def getFilters(self, dist_name, section_name):
        if self.__dists.has_key(dist_name):
            if self.__dists[dist_name].has_key(section_name):
                return self.__dists[dist_name][section_name]
        return ""

    def getIncludeTask(self, dist_name):
        if self.__dists.has_key(dist_name):
            if self.__dists[dist_name].has_key('include-task'):
                return self.__dists[dist_name]['include-task']
        return ''

    def getExcludeTask(self, dist_name):
        if self.__dists.has_key(dist_name):
            if self.__dists[dist_name].has_key('exclude-task'):
                return self.__dists[dist_name]['exclude-task']
        return ''

    def getExcludes(self, dist_name):
        if self.__exclude.has_key(dist_name):
            return self.__exclude[dist_name]
        return []
