
/* prdeb.c */

/* This file provides the print_deb() function to format and print out a
 * single DEB datum.  It takes two arguments: `find', which if true
 * causes deb_ln() to prefix its deb output with a ram-no; and a datum
 * `d', which if zero defaults to the global `datum'.  */

#include "prdeb.h"
#include "strx.h"
#include "argp.h"
#include "sel.h"
#include "color.h"
#include "datum.h"
#include "gen.h"

void print_deb( int find, const struct datum *d ) {

  if ( !d ) d = &datum;
  if ( opt.no_title ) find = 0; /* don't print ram-no if -T */

  if ( opt.selections ) {
    ENTRY entry, *ep;
    char deb[WIDTH_DATA+1];
    strxcpy( deb, datum.deb, datum.debX );
    entry.key  = deb;
    entry.data = 0  ;
    if ( !hsearch_r( entry, FIND, &ep, &sel ) ) return;
  }

  if ( opt.wide ) {
    char *const max =
      datum.buf + WIDTH_DATA - 1 + ( find ? -N_DIG : 0 );
    if ( datum.descX > max ) {
      datum .descX = max;
      *datum.descX = '\0';
    }
    if ( datum.desc > datum.descX ) datum.desc = datum.descX;
  }

  if ( find && !opt.no_title ) printf(
    "%s%s ",
    COLOR(  datum.ram_s, RAMNO_C )
  );
  if (         !opt.no_maint ) printf(
    "%s "  ,
    color2( datum.maint, datum.maintX, C_MAINT, C_DOT )
  );
  if (         !opt.no_pri   ) printf(
    "%s "  ,
    color2(
      datum.pri, datum.priX ,
      COLOR_PRI( datum.pri ),
      C_DOT
    )
  );
  printf                             (
    "%s"   ,
    color2( datum.deb  , datum.debX  , C_DEB  , C_DOT )
  );
  if (         !opt.no_desc  ) printf(
    "%s%s%s%s",
    opt.wide ? " " : NEWLN   ,
    COLOR( datum.desc, DESC ),
    opt.wide ? ""  : NEWLN
  );
  printf( "%s", NEWLN );

}

