# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import gtk

from tools import consts


mCurrentDir = consts.dirUsr


def openFiles(parent, title, filterPatterns={}):
    """
        Return a list of files, None if any
        The format of filter must be {'Name1': ['filter1', 'filter2'], 'Name2': ['filter3'] ... }
    """
    global mCurrentDir

    dlg = gtk.FileChooserDialog(title, parent, gtk.FILE_CHOOSER_ACTION_OPEN, (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL, gtk.STOCK_OPEN, gtk.RESPONSE_OK))

    # Set some specific options and restore the previously used directory
    dlg.set_select_multiple(True)
    dlg.set_current_folder(mCurrentDir)

    # Add filters
    for name,patterns in filterPatterns.iteritems():
        filter = gtk.FileFilter()
        filter.set_name(name)
        map(filter.add_pattern, patterns)
        dlg.add_filter(filter)

    files = None
    if dlg.run() == gtk.RESPONSE_OK:
        files = dlg.get_filenames()

    # Save the directory for the next time and destroy the dialog
    mCurrentDir = dlg.get_current_folder()
    dlg.destroy()

    return files


def openDirectory(parent, title):
    """ Return a directory, None if any """
    global mCurrentDir

    dlg = gtk.FileChooserDialog(title, parent, gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER, (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL, gtk.STOCK_OPEN, gtk.RESPONSE_OK))

    # Set some specific options and restore the previously used directory
    dlg.set_select_multiple(False)
    dlg.set_current_folder(mCurrentDir)

    directory = None
    if dlg.run() == gtk.RESPONSE_OK:
        directory = dlg.get_filename()

    # Save the directory for the next time and destroy the dialog
    mCurrentDir = dlg.get_current_folder()
    dlg.destroy()

    return directory


def save(parent, title, defaultFile, defaultDir=None):
    """ Return a filename chosen by the user, None if any """
    global mCurrentDir

    dlg = gtk.FileChooserDialog(title, parent, gtk.FILE_CHOOSER_ACTION_SAVE, buttons=(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL, gtk.STOCK_SAVE, gtk.RESPONSE_OK))

    # Set some specific options and restore the previously used directory
    dlg.set_current_name(defaultFile)
    dlg.set_do_overwrite_confirmation(True)

    if defaultDir is None: dlg.set_current_folder(mCurrentDir)
    else:                  dlg.set_current_folder(defaultDir)

    file = None
    if dlg.run() == gtk.RESPONSE_OK:
        file = dlg.get_filename()

    # Save the directory for the next time and destroy the dialog
    mCurrentDir = dlg.get_current_folder()
    dlg.destroy()

    return file
