# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import dircache, gtk.glade, media, media.playlist, os

from tools   import consts
from gettext import gettext as _


def sec2str(duration):
    """ Return a formatted string based on the given duration in seconds """
    hours    = duration / 3600
    duration = duration % 3600
    minutes  = duration / 60
    seconds  = duration % 60

    if hours == 0: return '%u:%02u' % (minutes, seconds)
    else:          return '%u:%02u:%02u' % (hours, minutes, seconds)


def listDir(directory, listHiddenFiles=False):
    """ Return a list of tuples (filename, fullPath) with the given directory content """
    return [(filename, os.path.join(directory, filename)) for filename in dircache.listdir(directory) if listHiddenFiles or filename[0] != '.']


def loadGladeFile(file, root=None):
    """ Load the given Glade file and return the tree of widgets """
    if root is None: return gtk.glade.XML(os.path.join(consts.dirRes, file), domain=consts.appNameShort)
    else:            return gtk.glade.XML(os.path.join(consts.dirRes, file), root, consts.appNameShort)
