#  macro QT4_ADD_DBUS_INTERFACE(outfiles interface basename header ... )
#        create a the interface header and implementation files with the 
#        given basename from the given interface xml file and add it to 
#        the list of sources
#
#        The optional headers are included by the generated code.
#
# macro QT4_ADD_DBUS_SHARED_INTERFACE(outfiles interface basename visibilitymacro header ... )
#        Same as QT4_ADD_DBUS INTERFACE, but adds the visibilitymacro for all classes.

INCLUDE(FindQt4)

FIND_FILE(SED "sed")
MARK_AS_ADVANCED(SED)


MACRO(QT4_ADD_DBUS_INTERFACE _sources _interface _basename)
    GET_FILENAME_COMPONENT(_infile ${_interface} ABSOLUTE)
    SET(_header ${CMAKE_CURRENT_BINARY_DIR}/${_basename}.h)
    SET(_impl   ${CMAKE_CURRENT_BINARY_DIR}/${_basename}.cpp)
    SET(_moc    ${CMAKE_CURRENT_BINARY_DIR}/${_basename}.moc)
    SET(_include)

    FOREACH (it ${ARGN})
        SET(_include ${_include} -i ${it})
    ENDFOREACH (it)
  
    ADD_CUSTOM_COMMAND(OUTPUT ${_impl} ${_header}
        COMMAND ${QT_DBUSXML2CPP_EXECUTABLE} ${_include} -m -p ${_basename} ${_infile}
        DEPENDS ${_infile})
  
    SET_SOURCE_FILES_PROPERTIES(${_impl} PROPERTIES SKIP_AUTOMOC TRUE)
    
    QT4_GENERATE_MOC(${_header} ${_moc})
  
    SET(${_sources} ${${_sources}} ${_impl} ${_header} ${_moc})
    MACRO_ADD_FILE_DEPENDENCIES(${_impl} ${_moc})
  
ENDMACRO(QT4_ADD_DBUS_INTERFACE)
 
MACRO(QT4_ADD_DBUS_SHARED_INTERFACE _sources _interface _basename _macro)
    GET_FILENAME_COMPONENT(_infile ${_interface} ABSOLUTE)
    SET(_header ${CMAKE_CURRENT_BINARY_DIR}/${_basename}.h)
    SET(_impl   ${CMAKE_CURRENT_BINARY_DIR}/${_basename}.cpp)
    SET(_moc    ${CMAKE_CURRENT_BINARY_DIR}/${_basename}.moc)
    SET(_include)

    FOREACH (it ${ARGN})
        SET(_include ${_include} -i ${it})
    ENDFOREACH (it)

    ADD_CUSTOM_COMMAND(OUTPUT ${_impl} ${_header}
        COMMAND ${QT_DBUSXML2CPP_EXECUTABLE} ${_include} -m -p ${_basename} ${_infile}
        COMMAND ${SED} -i -e \"s/class /class ${_macro} /\" ${_header}
        DEPENDS ${_infile})

    SET_SOURCE_FILES_PROPERTIES(${_impl} PROPERTIES SKIP_AUTOMOC TRUE)

    QT4_GENERATE_MOC(${_header} ${_moc})

    SET(${_sources} ${${_sources}} ${_impl} ${_header} ${_moc})
    MACRO_ADD_FILE_DEPENDENCIES(${_impl} ${_moc})

ENDMACRO(QT4_ADD_DBUS_SHARED_INTERFACE)

