/*
 * A Decibel TextChannel GUI
 * Copyright (C) 2008 George Goldberg <grundleborg@googlemail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "channelhandler.h"

#include <Decibel/AccountManager>
#include <Decibel/DBusNames>

#include <KDE/KApplication>
#include <KDE/KCmdLineArgs>
#include <KDE/KAboutData>

int main(int argc, char ** argv)
{
    /*
     * we must register the Decibel types immediately
     * at the start of the program
     */
    Decibel::registerTypes();

    /*
     * set up our KApplication
     */
    KAboutData aboutData("TextChannelGUI",
                         0,
                         ki18n("Decibel TextChannel GUI"),
                         "0.1",
                         ki18n("Decibel TextChannel GUI"),
                         KAboutData::License_GPL,
                         ki18n("(c) 2008"),
                         ki18n("George Goldberg <grundleborg@googlemail.com>"),
                         "http://decibel.kde.org",
                         "submit@bugs.kde.org");
    KCmdLineArgs::init(argc, argv, &aboutData);
    KApplication app;

    /*
     * create a channel handler to handle incoming connections,
     */
    ChannelHandler channel_handler;

    /*
     * register the app on DBus
     */
    QDBusConnection::sessionBus().registerService(Decibel::organization_name + '.' + "textchannelgui");
    QDBusConnection::sessionBus().registerObject("/TextChannelHandler", &channel_handler);

    /*
     * start event loop
     */
    return app.exec();
}

