/* Operation.c generated by valac 0.10.0, the Vala compiler
 * generated from Operation.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008,2009 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gconf/gconf-client.h>
#include <float.h>
#include <math.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define DEJA_DUP_TYPE_OPERATION (deja_dup_operation_get_type ())
#define DEJA_DUP_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_OPERATION, DejaDupOperation))
#define DEJA_DUP_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_OPERATION, DejaDupOperationClass))
#define DEJA_DUP_IS_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_OPERATION))
#define DEJA_DUP_IS_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_OPERATION))
#define DEJA_DUP_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_OPERATION, DejaDupOperationClass))

typedef struct _DejaDupOperation DejaDupOperation;
typedef struct _DejaDupOperationClass DejaDupOperationClass;
typedef struct _DejaDupOperationPrivate DejaDupOperationPrivate;

#define DEJA_DUP_TYPE_DUPLICITY (deja_dup_duplicity_get_type ())
#define DEJA_DUP_DUPLICITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicity))
#define DEJA_DUP_DUPLICITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityClass))
#define DEJA_DUP_IS_DUPLICITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY))
#define DEJA_DUP_IS_DUPLICITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY))
#define DEJA_DUP_DUPLICITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityClass))

typedef struct _DejaDupDuplicity DejaDupDuplicity;
typedef struct _DejaDupDuplicityClass DejaDupDuplicityClass;

#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;

#define DEJA_DUP_OPERATION_TYPE_MODE (deja_dup_operation_mode_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DEJA_DUP_OPERATION_TYPE_STATE (deja_dup_operation_state_get_type ())
#define DEJA_DUP_OPERATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_OPERATION_TYPE_STATE, DejaDupOperationState))
#define DEJA_DUP_OPERATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_OPERATION_TYPE_STATE, DejaDupOperationStateClass))
#define DEJA_DUP_OPERATION_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_OPERATION_TYPE_STATE))
#define DEJA_DUP_OPERATION_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_OPERATION_TYPE_STATE))
#define DEJA_DUP_OPERATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_OPERATION_TYPE_STATE, DejaDupOperationStateClass))

typedef struct _DejaDupOperationState DejaDupOperationState;
typedef struct _DejaDupOperationStateClass DejaDupOperationStateClass;
typedef struct _DejaDupOperationStatePrivate DejaDupOperationStatePrivate;
#define _deja_dup_operation_state_unref0(var) ((var == NULL) ? NULL : (var = (deja_dup_operation_state_unref (var), NULL)))
typedef struct _DejaDupOperationStartData DejaDupOperationStartData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DejaDupOperationContinueWithPassphraseData DejaDupOperationContinueWithPassphraseData;
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))
typedef struct _DejaDupOperationOperationFinishedData DejaDupOperationOperationFinishedData;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block2Data Block2Data;

#define DEJA_DUP_TYPE_DUPLICITY_INFO (deja_dup_duplicity_info_get_type ())
#define DEJA_DUP_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfo))
#define DEJA_DUP_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))
#define DEJA_DUP_IS_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_IS_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_DUPLICITY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))

typedef struct _DejaDupDuplicityInfo DejaDupDuplicityInfo;
typedef struct _DejaDupDuplicityInfoClass DejaDupDuplicityInfoClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _DejaDupOperationSetSessionInhibitedData DejaDupOperationSetSessionInhibitedData;
typedef struct _DejaDupOperationParamSpecState DejaDupOperationParamSpecState;

struct _DejaDupOperation {
	GObject parent_instance;
	DejaDupOperationPrivate * priv;
	DejaDupDuplicity* dup;
	char* passphrase;
};

struct _DejaDupOperationClass {
	GObjectClass parent_class;
	void (*start) (DejaDupOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*start_finish) (DejaDupOperation* self, GAsyncResult* _res_, GError** error);
	void (*connect_to_dup) (DejaDupOperation* self);
	void (*operation_finished) (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*operation_finished_finish) (DejaDupOperation* self, GAsyncResult* _res_);
	GList* (*make_argv) (DejaDupOperation* self, GError** error);
};

typedef enum  {
	DEJA_DUP_OPERATION_MODE_INVALID,
	DEJA_DUP_OPERATION_MODE_BACKUP,
	DEJA_DUP_OPERATION_MODE_RESTORE,
	DEJA_DUP_OPERATION_MODE_STATUS,
	DEJA_DUP_OPERATION_MODE_LIST
} DejaDupOperationMode;

struct _DejaDupOperationPrivate {
	guint _xid;
	gboolean _needs_password;
	DejaDupBackend* _backend;
	DejaDupOperationMode _mode;
	guint bus_id;
	guint inhibit_cookie;
};

struct _DejaDupOperationState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DejaDupOperationStatePrivate * priv;
	DejaDupBackend* backend;
	char* passphrase;
};

struct _DejaDupOperationStateClass {
	GTypeClass parent_class;
	void (*finalize) (DejaDupOperationState *self);
};

typedef enum  {
	DEJA_DUP_BACKUP_ERROR_BAD_CONFIG,
	DEJA_DUP_BACKUP_ERROR_ALREADY_RUNNING
} DejaDupBackupError;
#define DEJA_DUP_BACKUP_ERROR deja_dup_backup_error_quark ()
struct _DejaDupOperationStartData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupOperation* self;
	GConfClient* client;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_;
};

struct _DejaDupOperationContinueWithPassphraseData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupOperation* self;
	char* passphrase;
	char* _tmp0_;
	GError * e;
	GError * _inner_error_;
};

struct _DejaDupOperationOperationFinishedData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupOperation* self;
	DejaDupDuplicity* dup;
	gboolean success;
	gboolean cancelled;
	gboolean _tmp0_;
	GConfClient* client;
	GError * e;
	GError * _inner_error_;
};

struct _Block2Data {
	int _ref_count_;
	DejaDupOperation * self;
	gboolean rv;
	GMainLoop* loop;
};

struct _DejaDupOperationSetSessionInhibitedData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupOperation* self;
	gboolean inhibit;
	DejaDupDuplicityInfo* _tmp0_;
	gboolean _tmp1_;
	GDBusProxy* obj;
	GVariant* cookie_val;
	char* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GError * e;
	GError * _inner_error_;
};

struct _DejaDupOperationParamSpecState {
	GParamSpec parent_instance;
};


static gpointer deja_dup_operation_state_parent_class = NULL;
static gpointer deja_dup_operation_parent_class = NULL;

GType deja_dup_operation_get_type (void) G_GNUC_CONST;
GType deja_dup_duplicity_get_type (void) G_GNUC_CONST;
GType deja_dup_backend_get_type (void) G_GNUC_CONST;
GType deja_dup_operation_mode_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_OPERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_OPERATION, DejaDupOperationPrivate))
enum  {
	DEJA_DUP_OPERATION_DUMMY_PROPERTY,
	DEJA_DUP_OPERATION_XID,
	DEJA_DUP_OPERATION_NEEDS_PASSWORD,
	DEJA_DUP_OPERATION_BACKEND,
	DEJA_DUP_OPERATION_MODE
};
char* deja_dup_operation_mode_to_string (DejaDupOperationMode mode);
gpointer deja_dup_operation_state_ref (gpointer instance);
void deja_dup_operation_state_unref (gpointer instance);
GParamSpec* deja_dup_operation_param_spec_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void deja_dup_operation_value_set_state (GValue* value, gpointer v_object);
void deja_dup_operation_value_take_state (GValue* value, gpointer v_object);
gpointer deja_dup_operation_value_get_state (const GValue* value);
GType deja_dup_operation_state_get_type (void) G_GNUC_CONST;
DejaDupOperationState* deja_dup_operation_get_state (DejaDupOperation* self);
DejaDupOperationState* deja_dup_operation_state_new (void);
DejaDupOperationState* deja_dup_operation_state_construct (GType object_type);
DejaDupBackend* deja_dup_operation_get_backend (DejaDupOperation* self);
void deja_dup_operation_set_state (DejaDupOperation* self, DejaDupOperationState* state);
static void deja_dup_operation_set_backend (DejaDupOperation* self, DejaDupBackend* value);
static void deja_dup_operation_real_start_data_free (gpointer _data);
static void deja_dup_operation_real_start (DejaDupOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_operation_start_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void deja_dup_operation_start (DejaDupOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_operation_start_finish (DejaDupOperation* self, GAsyncResult* _res_, GError** error);
static gboolean deja_dup_operation_real_start_co (DejaDupOperationStartData* data);
void deja_dup_operation_connect_to_dup (DejaDupOperation* self);
GQuark deja_dup_backup_error_quark (void);
static void deja_dup_operation_claim_bus (DejaDupOperation* self, GError** error);
static void deja_dup_operation_set_session_inhibited (DejaDupOperation* self, gboolean inhibit, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_operation_set_session_inhibited_finish (DejaDupOperation* self, GAsyncResult* _res_);
GConfClient* deja_dup_get_gconf_client (void);
#define DEJA_DUP_ENCRYPT_KEY "/apps/deja-dup/encrypt"
static void deja_dup_operation_set_needs_password (DejaDupOperation* self, gboolean value);
void deja_dup_operation_continue_with_passphrase (DejaDupOperation* self, const char* passphrase, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_operation_continue_with_passphrase_finish (DejaDupOperation* self, GAsyncResult* _res_);
void deja_dup_operation_cancel (DejaDupOperation* self);
void deja_dup_duplicity_cancel (DejaDupDuplicity* self);
void deja_dup_operation_stop (DejaDupOperation* self);
void deja_dup_duplicity_stop (DejaDupDuplicity* self);
static void deja_dup_operation_real_connect_to_dup (DejaDupOperation* self);
static void _lambda1_ (DejaDupDuplicity* d, gboolean o, gboolean c, DejaDupOperation* self);
void deja_dup_operation_operation_finished (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_operation_operation_finished_finish (DejaDupOperation* self, GAsyncResult* _res_);
static void __lambda1__deja_dup_duplicity_done (DejaDupDuplicity* _sender, gboolean success, gboolean cancelled, gpointer self);
static void _lambda2_ (DejaDupDuplicity* d, const char* s, const char* detail, DejaDupOperation* self);
static void __lambda2__deja_dup_duplicity_raise_error (DejaDupDuplicity* _sender, const char* errstr, const char* detail, gpointer self);
static void _lambda3_ (DejaDupDuplicity* d, const char* s, DejaDupOperation* self);
static void __lambda3__deja_dup_duplicity_action_desc_changed (DejaDupDuplicity* _sender, const char* action, gpointer self);
static void _lambda4_ (DejaDupDuplicity* d, GFile* f, gboolean b, DejaDupOperation* self);
static void __lambda4__deja_dup_duplicity_action_file_changed (DejaDupDuplicity* _sender, GFile* file, gboolean actual, gpointer self);
static void _lambda5_ (DejaDupDuplicity* d, double p, DejaDupOperation* self);
static void __lambda5__deja_dup_duplicity_progress (DejaDupDuplicity* _sender, double percent, gpointer self);
static void _lambda6_ (DejaDupDuplicity* d, const char* t, const char* m, DejaDupOperation* self);
static void __lambda6__deja_dup_duplicity_question (DejaDupDuplicity* _sender, const char* title, const char* msg, gpointer self);
static void _lambda7_ (DejaDupDuplicity* d, const char* t, DejaDupOperation* self);
static void __lambda7__deja_dup_duplicity_secondary_desc_changed (DejaDupDuplicity* _sender, const char* msg, gpointer self);
static void deja_dup_operation_continue_with_envp (DejaDupOperation* self, DejaDupBackend* b, gboolean success, GList* envp, const char* _error_);
static void _deja_dup_operation_continue_with_envp_deja_dup_backend_envp_ready (DejaDupBackend* _sender, gboolean success, GList* envp, const char* _error_, gpointer self);
static void deja_dup_operation_continue_with_passphrase_data_free (gpointer _data);
static void deja_dup_operation_continue_with_passphrase_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean deja_dup_operation_continue_with_passphrase_co (DejaDupOperationContinueWithPassphraseData* data);
void deja_dup_backend_get_envp (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_backend_get_envp_finish (DejaDupBackend* self, GAsyncResult* _res_, GError** error);
GList* deja_dup_operation_make_argv (DejaDupOperation* self, GError** error);
void deja_dup_backend_add_argv (DejaDupBackend* self, DejaDupOperationMode mode, GList** argv);
DejaDupOperationMode deja_dup_operation_get_mode (DejaDupOperation* self);
void deja_dup_duplicity_start (DejaDupDuplicity* self, DejaDupBackend* backend, gboolean encrypted, GList* argv, GList* envp);
static void _g_list_free_g_free (GList* self);
static void deja_dup_operation_real_operation_finished_data_free (gpointer _data);
static void deja_dup_operation_real_operation_finished (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_operation_operation_finished_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean deja_dup_operation_real_operation_finished_co (DejaDupOperationOperationFinishedData* data);
static void deja_dup_operation_unclaim_bus (DejaDupOperation* self);
static GList* deja_dup_operation_real_make_argv (DejaDupOperation* self, GError** error);
static void _lambda8_ (DejaDupOperation* self);
static void __lambda8__gbus_acquired_callback (GDBusConnection* connection, const char* name, gpointer self);
static void _lambda9_ (Block2Data* _data2_);
static void __lambda9__gbus_name_acquired_callback (GDBusConnection* connection, const char* name, gpointer self);
static void _lambda10_ (Block2Data* _data2_);
static void __lambda10__gbus_name_lost_callback (GDBusConnection* connection, const char* name, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void deja_dup_operation_set_session_inhibited_data_free (gpointer _data);
static void deja_dup_operation_set_session_inhibited_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean deja_dup_operation_set_session_inhibited_co (DejaDupOperationSetSessionInhibitedData* data);
GType deja_dup_duplicity_info_get_type (void) G_GNUC_CONST;
DejaDupDuplicityInfo* deja_dup_duplicity_info_get_default (void);
gboolean deja_dup_duplicity_info_get_can_resume (DejaDupDuplicityInfo* self);
guint deja_dup_operation_get_xid (DejaDupOperation* self);
DejaDupOperationMode deja_dup_duplicity_get_mode (DejaDupDuplicity* self);
DejaDupOperation* deja_dup_operation_construct (GType object_type);
static void deja_dup_operation_set_xid (DejaDupOperation* self, guint value);
gboolean deja_dup_operation_get_needs_password (DejaDupOperation* self);
static void deja_dup_operation_set_mode (DejaDupOperation* self, DejaDupOperationMode value);
DejaDupDuplicity* deja_dup_duplicity_new (DejaDupOperationMode mode);
DejaDupDuplicity* deja_dup_duplicity_construct (GType object_type, DejaDupOperationMode mode);
DejaDupBackend* deja_dup_backend_get_default (GError** error);
static GObject * deja_dup_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
enum  {
	DEJA_DUP_OPERATION_STATE_DUMMY_PROPERTY
};
static void deja_dup_operation_state_finalize (DejaDupOperationState* obj);
static void deja_dup_operation_finalize (GObject* obj);
static void deja_dup_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void deja_dup_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

GType deja_dup_operation_mode_get_type (void) {
	static volatile gsize deja_dup_operation_mode_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_operation_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{DEJA_DUP_OPERATION_MODE_INVALID, "DEJA_DUP_OPERATION_MODE_INVALID", "invalid"}, {DEJA_DUP_OPERATION_MODE_BACKUP, "DEJA_DUP_OPERATION_MODE_BACKUP", "backup"}, {DEJA_DUP_OPERATION_MODE_RESTORE, "DEJA_DUP_OPERATION_MODE_RESTORE", "restore"}, {DEJA_DUP_OPERATION_MODE_STATUS, "DEJA_DUP_OPERATION_MODE_STATUS", "status"}, {DEJA_DUP_OPERATION_MODE_LIST, "DEJA_DUP_OPERATION_MODE_LIST", "list"}, {0, NULL, NULL}};
		GType deja_dup_operation_mode_type_id;
		deja_dup_operation_mode_type_id = g_enum_register_static ("DejaDupOperationMode", values);
		g_once_init_leave (&deja_dup_operation_mode_type_id__volatile, deja_dup_operation_mode_type_id);
	}
	return deja_dup_operation_mode_type_id__volatile;
}


char* deja_dup_operation_mode_to_string (DejaDupOperationMode mode) {
	char* result = NULL;
	switch (mode) {
		case DEJA_DUP_OPERATION_MODE_BACKUP:
		{
			result = g_strdup (_ ("Backing up…"));
			return result;
		}
		case DEJA_DUP_OPERATION_MODE_RESTORE:
		{
			result = g_strdup (_ ("Restoring…"));
			return result;
		}
		case DEJA_DUP_OPERATION_MODE_STATUS:
		{
			result = g_strdup (_ ("Checking for backups…"));
			return result;
		}
		case DEJA_DUP_OPERATION_MODE_LIST:
		{
			result = g_strdup (_ ("Listing files…"));
			return result;
		}
		default:
		{
			result = g_strdup (_ ("Preparing…"));
			return result;
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


DejaDupOperationState* deja_dup_operation_get_state (DejaDupOperation* self) {
	DejaDupOperationState* result = NULL;
	DejaDupOperationState* rv;
	DejaDupBackend* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	rv = deja_dup_operation_state_new ();
	rv->backend = (_tmp0_ = _g_object_ref0 (self->priv->_backend), _g_object_unref0 (rv->backend), _tmp0_);
	rv->passphrase = (_tmp1_ = g_strdup (self->passphrase), _g_free0 (rv->passphrase), _tmp1_);
	result = rv;
	return result;
}


void deja_dup_operation_set_state (DejaDupOperation* self, DejaDupOperationState* state) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	deja_dup_operation_set_backend (self, state->backend);
	self->passphrase = (_tmp0_ = g_strdup (state->passphrase), _g_free0 (self->passphrase), _tmp0_);
}


static void deja_dup_operation_real_start_data_free (gpointer _data) {
	DejaDupOperationStartData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (DejaDupOperationStartData, data);
}


static void deja_dup_operation_real_start (DejaDupOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupOperationStartData* _data_;
	_data_ = g_slice_new0 (DejaDupOperationStartData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_operation_real_start);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_operation_real_start_data_free);
	_data_->self = g_object_ref (self);
	deja_dup_operation_real_start_co (_data_);
}


static void deja_dup_operation_real_start_finish (DejaDupOperation* self, GAsyncResult* _res_, GError** error) {
	DejaDupOperationStartData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_operation_start_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupOperationStartData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_operation_real_start_co (data);
}


static gboolean deja_dup_operation_real_start_co (DejaDupOperationStartData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 16:
		goto _state_16;
	}
	_state_0:
	g_signal_emit_by_name (data->self, "action-desc-changed", _ ("Preparing…"));
	if (data->self->priv->_backend == NULL) {
		g_signal_emit_by_name (data->self, "done", FALSE, FALSE);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	deja_dup_operation_connect_to_dup (data->self);
	deja_dup_operation_claim_bus (data->self, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->_state_ = 16;
	deja_dup_operation_set_session_inhibited (data->self, TRUE, deja_dup_operation_start_ready, data);
	return FALSE;
	_state_16:
	deja_dup_operation_set_session_inhibited_finish (data->self, data->_res_);
	data->client = deja_dup_get_gconf_client ();
	data->_tmp1_ = gconf_client_get_bool (data->client, DEJA_DUP_ENCRYPT_KEY, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (data->_tmp1_) {
		data->_tmp0_ = data->self->passphrase == NULL;
	} else {
		data->_tmp0_ = FALSE;
	}
	if (data->_tmp0_) {
		deja_dup_operation_set_needs_password (data->self, TRUE);
		g_signal_emit_by_name (data->self, "passphrase-required");
	} else {
		deja_dup_operation_continue_with_passphrase (data->self, data->self->passphrase, NULL, NULL);
	}
	_g_object_unref0 (data->client);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


void deja_dup_operation_start (DejaDupOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DEJA_DUP_OPERATION_GET_CLASS (self)->start (self, _callback_, _user_data_);
}


void deja_dup_operation_start_finish (DejaDupOperation* self, GAsyncResult* _res_, GError** error) {
	DEJA_DUP_OPERATION_GET_CLASS (self)->start_finish (self, _res_, error);
}


void deja_dup_operation_cancel (DejaDupOperation* self) {
	g_return_if_fail (self != NULL);
	deja_dup_duplicity_cancel (self->dup);
}


void deja_dup_operation_stop (DejaDupOperation* self) {
	g_return_if_fail (self != NULL);
	deja_dup_duplicity_stop (self->dup);
}


static void _lambda1_ (DejaDupDuplicity* d, gboolean o, gboolean c, DejaDupOperation* self) {
	g_return_if_fail (d != NULL);
	deja_dup_operation_operation_finished (self, d, o, c, NULL, NULL);
}


static void __lambda1__deja_dup_duplicity_done (DejaDupDuplicity* _sender, gboolean success, gboolean cancelled, gpointer self) {
	_lambda1_ (_sender, success, cancelled, self);
}


static void _lambda2_ (DejaDupDuplicity* d, const char* s, const char* detail, DejaDupOperation* self) {
	g_return_if_fail (d != NULL);
	g_return_if_fail (s != NULL);
	g_signal_emit_by_name (self, "raise-error", s, detail);
}


static void __lambda2__deja_dup_duplicity_raise_error (DejaDupDuplicity* _sender, const char* errstr, const char* detail, gpointer self) {
	_lambda2_ (_sender, errstr, detail, self);
}


static void _lambda3_ (DejaDupDuplicity* d, const char* s, DejaDupOperation* self) {
	g_return_if_fail (d != NULL);
	g_return_if_fail (s != NULL);
	g_signal_emit_by_name (self, "action-desc-changed", s);
}


static void __lambda3__deja_dup_duplicity_action_desc_changed (DejaDupDuplicity* _sender, const char* action, gpointer self) {
	_lambda3_ (_sender, action, self);
}


static void _lambda4_ (DejaDupDuplicity* d, GFile* f, gboolean b, DejaDupOperation* self) {
	g_return_if_fail (d != NULL);
	g_return_if_fail (f != NULL);
	g_signal_emit_by_name (self, "action-file-changed", f, b);
}


static void __lambda4__deja_dup_duplicity_action_file_changed (DejaDupDuplicity* _sender, GFile* file, gboolean actual, gpointer self) {
	_lambda4_ (_sender, file, actual, self);
}


static void _lambda5_ (DejaDupDuplicity* d, double p, DejaDupOperation* self) {
	g_return_if_fail (d != NULL);
	g_signal_emit_by_name (self, "progress", p);
}


static void __lambda5__deja_dup_duplicity_progress (DejaDupDuplicity* _sender, double percent, gpointer self) {
	_lambda5_ (_sender, percent, self);
}


static void _lambda6_ (DejaDupDuplicity* d, const char* t, const char* m, DejaDupOperation* self) {
	g_return_if_fail (d != NULL);
	g_return_if_fail (t != NULL);
	g_return_if_fail (m != NULL);
	g_signal_emit_by_name (self, "question", t, m);
}


static void __lambda6__deja_dup_duplicity_question (DejaDupDuplicity* _sender, const char* title, const char* msg, gpointer self) {
	_lambda6_ (_sender, title, msg, self);
}


static void _lambda7_ (DejaDupDuplicity* d, const char* t, DejaDupOperation* self) {
	g_return_if_fail (d != NULL);
	g_return_if_fail (t != NULL);
	g_signal_emit_by_name (self, "secondary-desc-changed", t);
}


static void __lambda7__deja_dup_duplicity_secondary_desc_changed (DejaDupDuplicity* _sender, const char* msg, gpointer self) {
	_lambda7_ (_sender, msg, self);
}


static void _deja_dup_operation_continue_with_envp_deja_dup_backend_envp_ready (DejaDupBackend* _sender, gboolean success, GList* envp, const char* _error_, gpointer self) {
	deja_dup_operation_continue_with_envp (self, _sender, success, envp, _error_);
}


static void deja_dup_operation_real_connect_to_dup (DejaDupOperation* self) {
	g_return_if_fail (self != NULL);
	g_signal_connect_object (self->dup, "done", (GCallback) __lambda1__deja_dup_duplicity_done, self, 0);
	g_signal_connect_object (self->dup, "raise-error", (GCallback) __lambda2__deja_dup_duplicity_raise_error, self, 0);
	g_signal_connect_object (self->dup, "action-desc-changed", (GCallback) __lambda3__deja_dup_duplicity_action_desc_changed, self, 0);
	g_signal_connect_object (self->dup, "action-file-changed", (GCallback) __lambda4__deja_dup_duplicity_action_file_changed, self, 0);
	g_signal_connect_object (self->dup, "progress", (GCallback) __lambda5__deja_dup_duplicity_progress, self, 0);
	g_signal_connect_object (self->dup, "question", (GCallback) __lambda6__deja_dup_duplicity_question, self, 0);
	g_signal_connect_object (self->dup, "secondary-desc-changed", (GCallback) __lambda7__deja_dup_duplicity_secondary_desc_changed, self, 0);
	g_signal_connect_object (self->priv->_backend, "envp-ready", (GCallback) _deja_dup_operation_continue_with_envp_deja_dup_backend_envp_ready, self, 0);
}


void deja_dup_operation_connect_to_dup (DejaDupOperation* self) {
	DEJA_DUP_OPERATION_GET_CLASS (self)->connect_to_dup (self);
}


static void deja_dup_operation_continue_with_passphrase_data_free (gpointer _data) {
	DejaDupOperationContinueWithPassphraseData* data;
	data = _data;
	_g_free0 (data->passphrase);
	g_object_unref (data->self);
	g_slice_free (DejaDupOperationContinueWithPassphraseData, data);
}


void deja_dup_operation_continue_with_passphrase (DejaDupOperation* self, const char* passphrase, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupOperationContinueWithPassphraseData* _data_;
	_data_ = g_slice_new0 (DejaDupOperationContinueWithPassphraseData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_operation_continue_with_passphrase);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_operation_continue_with_passphrase_data_free);
	_data_->self = g_object_ref (self);
	_data_->passphrase = g_strdup (passphrase);
	deja_dup_operation_continue_with_passphrase_co (_data_);
}


void deja_dup_operation_continue_with_passphrase_finish (DejaDupOperation* self, GAsyncResult* _res_) {
	DejaDupOperationContinueWithPassphraseData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_operation_continue_with_passphrase_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupOperationContinueWithPassphraseData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_operation_continue_with_passphrase_co (data);
}


static gboolean deja_dup_operation_continue_with_passphrase_co (DejaDupOperationContinueWithPassphraseData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 17:
		goto _state_17;
	}
	_state_0:
	deja_dup_operation_set_needs_password (data->self, FALSE);
	data->self->passphrase = (data->_tmp0_ = g_strdup (data->passphrase), _g_free0 (data->self->passphrase), data->_tmp0_);
	{
		data->_state_ = 17;
		deja_dup_backend_get_envp (data->self->priv->_backend, deja_dup_operation_continue_with_passphrase_ready, data);
		return FALSE;
		_state_17:
		deja_dup_backend_get_envp_finish (data->self->priv->_backend, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch32_g_error;
		}
	}
	goto __finally32;
	__catch32_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			g_signal_emit_by_name (data->self, "raise-error", data->e->message, NULL);
			g_signal_emit_by_name (data->self, "done", FALSE, FALSE);
			_g_error_free0 (data->e);
		}
	}
	__finally32:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static void deja_dup_operation_continue_with_envp (DejaDupOperation* self, DejaDupBackend* b, gboolean success, GList* envp, const char* _error_) {
	gboolean _tmp0_ = FALSE;
	gboolean encrypted;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	if (!success) {
		if (_error_ != NULL) {
			g_signal_emit_by_name (self, "raise-error", _error_, NULL);
		}
		g_signal_emit_by_name (self, "done", FALSE, FALSE);
		return;
	}
	if (self->passphrase != NULL) {
		_tmp0_ = _vala_strcmp0 (self->passphrase, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	encrypted = _tmp0_;
	if (encrypted) {
		envp = g_list_append (envp, g_strdup_printf ("PASSPHRASE=%s", self->passphrase));
	} else {
		envp = g_list_append (envp, g_strdup ("PASSPHRASE="));
	}
	{
		GList* argv;
		argv = deja_dup_operation_make_argv (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch33_g_error;
		}
		deja_dup_backend_add_argv (self->priv->_backend, self->priv->_mode, &argv);
		deja_dup_duplicity_start (self->dup, self->priv->_backend, encrypted, argv, envp);
		__g_list_free_g_free0 (argv);
	}
	goto __finally33;
	__catch33_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_signal_emit_by_name (self, "raise-error", e->message, NULL);
			g_signal_emit_by_name (self, "done", FALSE, FALSE);
			_g_error_free0 (e);
			return;
		}
	}
	__finally33:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void deja_dup_operation_real_operation_finished_data_free (gpointer _data) {
	DejaDupOperationOperationFinishedData* data;
	data = _data;
	_g_object_unref0 (data->dup);
	g_object_unref (data->self);
	g_slice_free (DejaDupOperationOperationFinishedData, data);
}


static void deja_dup_operation_real_operation_finished (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupOperationOperationFinishedData* _data_;
	_data_ = g_slice_new0 (DejaDupOperationOperationFinishedData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_operation_real_operation_finished);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_operation_real_operation_finished_data_free);
	_data_->self = g_object_ref (self);
	_data_->dup = _g_object_ref0 (dup);
	_data_->success = success;
	_data_->cancelled = cancelled;
	deja_dup_operation_real_operation_finished_co (_data_);
}


static void deja_dup_operation_real_operation_finished_finish (DejaDupOperation* self, GAsyncResult* _res_) {
	DejaDupOperationOperationFinishedData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_operation_operation_finished_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupOperationOperationFinishedData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_operation_real_operation_finished_co (data);
}


static gboolean deja_dup_operation_real_operation_finished_co (DejaDupOperationOperationFinishedData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 18:
		goto _state_18;
	}
	_state_0:
	data->_state_ = 18;
	deja_dup_operation_set_session_inhibited (data->self, FALSE, deja_dup_operation_operation_finished_ready, data);
	return FALSE;
	_state_18:
	deja_dup_operation_set_session_inhibited_finish (data->self, data->_res_);
	deja_dup_operation_unclaim_bus (data->self);
	if (data->success) {
		data->_tmp0_ = _vala_strcmp0 (data->self->passphrase, "") == 0;
	} else {
		data->_tmp0_ = FALSE;
	}
	if (data->_tmp0_) {
		{
			data->client = _g_object_ref0 (gconf_client_get_default ());
			gconf_client_set_bool (data->client, DEJA_DUP_ENCRYPT_KEY, FALSE, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->client);
				goto __catch34_g_error;
			}
			_g_object_unref0 (data->client);
		}
		goto __finally34;
		__catch34_g_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("Operation.vala:193: %s\n", data->e->message);
				_g_error_free0 (data->e);
			}
		}
		__finally34:
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	g_signal_emit_by_name (data->self, "done", data->success, data->cancelled);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


void deja_dup_operation_operation_finished (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DEJA_DUP_OPERATION_GET_CLASS (self)->operation_finished (self, dup, success, cancelled, _callback_, _user_data_);
}


void deja_dup_operation_operation_finished_finish (DejaDupOperation* self, GAsyncResult* _res_) {
	DEJA_DUP_OPERATION_GET_CLASS (self)->operation_finished_finish (self, _res_);
}


static GList* deja_dup_operation_real_make_argv (DejaDupOperation* self, GError** error) {
	GList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


GList* deja_dup_operation_make_argv (DejaDupOperation* self, GError** error) {
	return DEJA_DUP_OPERATION_GET_CLASS (self)->make_argv (self, error);
}


static void _lambda8_ (DejaDupOperation* self) {
}


static void __lambda8__gbus_acquired_callback (GDBusConnection* connection, const char* name, gpointer self) {
	_lambda8_ (self);
}


static void _lambda9_ (Block2Data* _data2_) {
	DejaDupOperation * self;
	self = _data2_->self;
	_data2_->rv = TRUE;
	g_main_loop_quit (_data2_->loop);
}


static void __lambda9__gbus_name_acquired_callback (GDBusConnection* connection, const char* name, gpointer self) {
	_lambda9_ (self);
}


static void _lambda10_ (Block2Data* _data2_) {
	DejaDupOperation * self;
	self = _data2_->self;
	_data2_->rv = FALSE;
	g_main_loop_quit (_data2_->loop);
}


static void __lambda10__gbus_name_lost_callback (GDBusConnection* connection, const char* name, gpointer self) {
	_lambda10_ (self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_main_loop_unref0 (_data2_->loop);
		g_slice_free (Block2Data, _data2_);
	}
}


static void deja_dup_operation_claim_bus (DejaDupOperation* self, GError** error) {
	Block2Data* _data2_;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->rv = FALSE;
	_data2_->loop = g_main_loop_new (NULL, FALSE);
	self->priv->bus_id = g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.gnome.DejaDup.Operation", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) g_cclosure_new ((GCallback) __lambda8__gbus_acquired_callback, g_object_ref (self), g_object_unref), (GClosure*) g_cclosure_new ((GCallback) __lambda9__gbus_name_acquired_callback, block2_data_ref (_data2_), block2_data_unref), (GClosure*) g_cclosure_new ((GCallback) __lambda10__gbus_name_lost_callback, block2_data_ref (_data2_), block2_data_unref));
	g_main_loop_run (_data2_->loop);
	if (self->priv->bus_id == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _data2_->rv == FALSE;
	}
	if (_tmp0_) {
		_inner_error_ = g_error_new_literal (DEJA_DUP_BACKUP_ERROR, DEJA_DUP_BACKUP_ERROR_ALREADY_RUNNING, _ ("Another Déjà Dup is already running"));
		{
			if (_inner_error_->domain == DEJA_DUP_BACKUP_ERROR) {
				g_propagate_error (error, _inner_error_);
				block2_data_unref (_data2_);
				return;
			} else {
				block2_data_unref (_data2_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	block2_data_unref (_data2_);
}


static void deja_dup_operation_unclaim_bus (DejaDupOperation* self) {
	g_return_if_fail (self != NULL);
	g_bus_unown_name (self->priv->bus_id);
}


static void deja_dup_operation_set_session_inhibited_data_free (gpointer _data) {
	DejaDupOperationSetSessionInhibitedData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (DejaDupOperationSetSessionInhibitedData, data);
}


static void deja_dup_operation_set_session_inhibited (DejaDupOperation* self, gboolean inhibit, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupOperationSetSessionInhibitedData* _data_;
	_data_ = g_slice_new0 (DejaDupOperationSetSessionInhibitedData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_operation_set_session_inhibited);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_operation_set_session_inhibited_data_free);
	_data_->self = g_object_ref (self);
	_data_->inhibit = inhibit;
	deja_dup_operation_set_session_inhibited_co (_data_);
}


static void deja_dup_operation_set_session_inhibited_finish (DejaDupOperation* self, GAsyncResult* _res_) {
	DejaDupOperationSetSessionInhibitedData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_operation_set_session_inhibited_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupOperationSetSessionInhibitedData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_operation_set_session_inhibited_co (data);
}


static gboolean deja_dup_operation_set_session_inhibited_co (DejaDupOperationSetSessionInhibitedData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 19:
		goto _state_19;
		case 20:
		goto _state_20;
	}
	_state_0:
	if ((data->_tmp1_ = deja_dup_duplicity_info_get_can_resume (data->_tmp0_ = deja_dup_duplicity_info_get_default ()), _g_object_unref0 (data->_tmp0_), data->_tmp1_)) {
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		data->obj = g_dbus_proxy_new_for_bus_sync (G_BUS_TYPE_SESSION, G_DBUS_PROXY_FLAGS_NONE, NULL, "org.gnome.SessionManager", "/org/gnome/SessionManager", "org.gnome.SessionManager", NULL, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch35_g_error;
		}
		if (data->inhibit) {
			if (data->self->priv->inhibit_cookie > 0) {
				_g_object_unref0 (data->obj);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->_state_ = 19;
			g_dbus_proxy_call (data->obj, "Inhibit", data->_tmp3_ = g_variant_ref_sink (g_variant_new ("(susu)", PACKAGE, data->self->priv->_xid, data->_tmp2_ = deja_dup_operation_mode_to_string (deja_dup_duplicity_get_mode (data->self->dup)), (guint) (1 | 4), NULL)), G_DBUS_CALL_FLAGS_NONE, -1, NULL, deja_dup_operation_set_session_inhibited_ready, data);
			return FALSE;
			_state_19:
			data->cookie_val = (data->_tmp4_ = g_dbus_proxy_call_finish (data->obj, data->_res_, &data->_inner_error_), _g_variant_unref0 (data->_tmp3_), _g_free0 (data->_tmp2_), data->_tmp4_);
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->obj);
				goto __catch35_g_error;
			}
			g_variant_get (data->cookie_val, "(u)", &data->self->priv->inhibit_cookie, NULL);
			_g_variant_unref0 (data->cookie_val);
		} else {
			if (data->self->priv->inhibit_cookie > 0) {
				data->_state_ = 20;
				g_dbus_proxy_call (data->obj, "Uninhibit", data->_tmp5_ = g_variant_ref_sink (g_variant_new ("(u)", data->self->priv->inhibit_cookie, NULL)), G_DBUS_CALL_FLAGS_NONE, -1, NULL, deja_dup_operation_set_session_inhibited_ready, data);
				return FALSE;
				_state_20:
				data->_tmp6_ = g_dbus_proxy_call_finish (data->obj, data->_res_, &data->_inner_error_);
				_g_variant_unref0 (data->_tmp6_);
				_g_variant_unref0 (data->_tmp5_);
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->obj);
					goto __catch35_g_error;
				}
				data->self->priv->inhibit_cookie = (guint) 0;
			}
		}
		_g_object_unref0 (data->obj);
	}
	goto __finally35;
	__catch35_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			g_warning ("Operation.vala:261: %s\n", data->e->message);
			_g_error_free0 (data->e);
		}
	}
	__finally35:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


DejaDupOperation* deja_dup_operation_construct (GType object_type) {
	DejaDupOperation * self;
	self = (DejaDupOperation*) g_object_new (object_type, NULL);
	return self;
}


guint deja_dup_operation_get_xid (DejaDupOperation* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_xid;
	return result;
}


static void deja_dup_operation_set_xid (DejaDupOperation* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_xid = value;
	g_object_notify ((GObject *) self, "xid");
}


gboolean deja_dup_operation_get_needs_password (DejaDupOperation* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_needs_password;
	return result;
}


static void deja_dup_operation_set_needs_password (DejaDupOperation* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_needs_password = value;
	g_object_notify ((GObject *) self, "needs-password");
}


DejaDupBackend* deja_dup_operation_get_backend (DejaDupOperation* self) {
	DejaDupBackend* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_backend;
	return result;
}


static void deja_dup_operation_set_backend (DejaDupOperation* self, DejaDupBackend* value) {
	DejaDupBackend* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_backend = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_backend), _tmp0_);
	g_object_notify ((GObject *) self, "backend");
}


DejaDupOperationMode deja_dup_operation_get_mode (DejaDupOperation* self) {
	DejaDupOperationMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}


static void deja_dup_operation_set_mode (DejaDupOperation* self, DejaDupOperationMode value) {
	g_return_if_fail (self != NULL);
	self->priv->_mode = value;
	g_object_notify ((GObject *) self, "mode");
}


static GObject * deja_dup_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupOperation * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (deja_dup_operation_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DEJA_DUP_OPERATION (obj);
	_inner_error_ = NULL;
	{
		DejaDupDuplicity* _tmp0_;
		self->dup = (_tmp0_ = deja_dup_duplicity_new (self->priv->_mode), _g_object_unref0 (self->dup), _tmp0_);
		{
			DejaDupBackend* _tmp1_;
			DejaDupBackend* _tmp2_;
			_tmp1_ = deja_dup_backend_get_default (&_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch36_g_error;
			}
			deja_dup_operation_set_backend (self, _tmp2_ = _tmp1_);
			_g_object_unref0 (_tmp2_);
		}
		goto __finally36;
		__catch36_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("Operation.vala:91: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally36:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	return obj;
}


DejaDupOperationState* deja_dup_operation_state_construct (GType object_type) {
	DejaDupOperationState* self;
	self = (DejaDupOperationState*) g_type_create_instance (object_type);
	return self;
}


DejaDupOperationState* deja_dup_operation_state_new (void) {
	return deja_dup_operation_state_construct (DEJA_DUP_OPERATION_TYPE_STATE);
}


static void deja_dup_operation_value_state_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void deja_dup_operation_value_state_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		deja_dup_operation_state_unref (value->data[0].v_pointer);
	}
}


static void deja_dup_operation_value_state_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = deja_dup_operation_state_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer deja_dup_operation_value_state_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* deja_dup_operation_value_state_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DejaDupOperationState* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = deja_dup_operation_state_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* deja_dup_operation_value_state_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DejaDupOperationState** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = deja_dup_operation_state_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* deja_dup_operation_param_spec_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DejaDupOperationParamSpecState* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DEJA_DUP_OPERATION_TYPE_STATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer deja_dup_operation_value_get_state (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DEJA_DUP_OPERATION_TYPE_STATE), NULL);
	return value->data[0].v_pointer;
}


void deja_dup_operation_value_set_state (GValue* value, gpointer v_object) {
	DejaDupOperationState* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DEJA_DUP_OPERATION_TYPE_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DEJA_DUP_OPERATION_TYPE_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		deja_dup_operation_state_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		deja_dup_operation_state_unref (old);
	}
}


void deja_dup_operation_value_take_state (GValue* value, gpointer v_object) {
	DejaDupOperationState* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DEJA_DUP_OPERATION_TYPE_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DEJA_DUP_OPERATION_TYPE_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		deja_dup_operation_state_unref (old);
	}
}


static void deja_dup_operation_state_class_init (DejaDupOperationStateClass * klass) {
	deja_dup_operation_state_parent_class = g_type_class_peek_parent (klass);
	DEJA_DUP_OPERATION_STATE_CLASS (klass)->finalize = deja_dup_operation_state_finalize;
}


static void deja_dup_operation_state_instance_init (DejaDupOperationState * self) {
	self->ref_count = 1;
}


static void deja_dup_operation_state_finalize (DejaDupOperationState* obj) {
	DejaDupOperationState * self;
	self = DEJA_DUP_OPERATION_STATE (obj);
	_g_object_unref0 (self->backend);
	_g_free0 (self->passphrase);
}


GType deja_dup_operation_state_get_type (void) {
	static volatile gsize deja_dup_operation_state_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_operation_state_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { deja_dup_operation_value_state_init, deja_dup_operation_value_state_free_value, deja_dup_operation_value_state_copy_value, deja_dup_operation_value_state_peek_pointer, "p", deja_dup_operation_value_state_collect_value, "p", deja_dup_operation_value_state_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupOperationStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_operation_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupOperationState), 0, (GInstanceInitFunc) deja_dup_operation_state_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType deja_dup_operation_state_type_id;
		deja_dup_operation_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DejaDupOperationState", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&deja_dup_operation_state_type_id__volatile, deja_dup_operation_state_type_id);
	}
	return deja_dup_operation_state_type_id__volatile;
}


gpointer deja_dup_operation_state_ref (gpointer instance) {
	DejaDupOperationState* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void deja_dup_operation_state_unref (gpointer instance) {
	DejaDupOperationState* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DEJA_DUP_OPERATION_STATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void deja_dup_operation_class_init (DejaDupOperationClass * klass) {
	deja_dup_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupOperationPrivate));
	DEJA_DUP_OPERATION_CLASS (klass)->start = deja_dup_operation_real_start;
	DEJA_DUP_OPERATION_CLASS (klass)->start_finish = deja_dup_operation_real_start_finish;
	DEJA_DUP_OPERATION_CLASS (klass)->connect_to_dup = deja_dup_operation_real_connect_to_dup;
	DEJA_DUP_OPERATION_CLASS (klass)->operation_finished = deja_dup_operation_real_operation_finished;
	DEJA_DUP_OPERATION_CLASS (klass)->operation_finished_finish = deja_dup_operation_real_operation_finished_finish;
	DEJA_DUP_OPERATION_CLASS (klass)->make_argv = deja_dup_operation_real_make_argv;
	G_OBJECT_CLASS (klass)->get_property = deja_dup_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = deja_dup_operation_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_operation_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_operation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_XID, g_param_spec_uint ("xid", "xid", "xid", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_NEEDS_PASSWORD, g_param_spec_boolean ("needs-password", "needs-password", "needs-password", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_BACKEND, g_param_spec_object ("backend", "backend", "backend", DEJA_DUP_TYPE_BACKEND, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_MODE, g_param_spec_enum ("mode", "mode", "mode", DEJA_DUP_OPERATION_TYPE_MODE, DEJA_DUP_OPERATION_MODE_INVALID, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("done", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
	g_signal_new ("raise_error", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	g_signal_new ("action_desc_changed", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("action_file_changed", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_FILE, G_TYPE_BOOLEAN);
	g_signal_new ("progress", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
	g_signal_new ("passphrase_required", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("question", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	g_signal_new ("secondary_desc_changed", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void deja_dup_operation_instance_init (DejaDupOperation * self) {
	self->priv = DEJA_DUP_OPERATION_GET_PRIVATE (self);
	self->priv->_mode = DEJA_DUP_OPERATION_MODE_INVALID;
	self->priv->bus_id = (guint) 0;
	self->priv->inhibit_cookie = (guint) 0;
}


static void deja_dup_operation_finalize (GObject* obj) {
	DejaDupOperation * self;
	self = DEJA_DUP_OPERATION (obj);
	_g_object_unref0 (self->priv->_backend);
	_g_object_unref0 (self->dup);
	_g_free0 (self->passphrase);
	G_OBJECT_CLASS (deja_dup_operation_parent_class)->finalize (obj);
}


GType deja_dup_operation_get_type (void) {
	static volatile gsize deja_dup_operation_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_operation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupOperation), 0, (GInstanceInitFunc) deja_dup_operation_instance_init, NULL };
		GType deja_dup_operation_type_id;
		deja_dup_operation_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&deja_dup_operation_type_id__volatile, deja_dup_operation_type_id);
	}
	return deja_dup_operation_type_id__volatile;
}


static void deja_dup_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupOperation * self;
	self = DEJA_DUP_OPERATION (object);
	switch (property_id) {
		case DEJA_DUP_OPERATION_XID:
		g_value_set_uint (value, deja_dup_operation_get_xid (self));
		break;
		case DEJA_DUP_OPERATION_NEEDS_PASSWORD:
		g_value_set_boolean (value, deja_dup_operation_get_needs_password (self));
		break;
		case DEJA_DUP_OPERATION_BACKEND:
		g_value_set_object (value, deja_dup_operation_get_backend (self));
		break;
		case DEJA_DUP_OPERATION_MODE:
		g_value_set_enum (value, deja_dup_operation_get_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupOperation * self;
	self = DEJA_DUP_OPERATION (object);
	switch (property_id) {
		case DEJA_DUP_OPERATION_XID:
		deja_dup_operation_set_xid (self, g_value_get_uint (value));
		break;
		case DEJA_DUP_OPERATION_NEEDS_PASSWORD:
		deja_dup_operation_set_needs_password (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_OPERATION_BACKEND:
		deja_dup_operation_set_backend (self, g_value_get_object (value));
		break;
		case DEJA_DUP_OPERATION_MODE:
		deja_dup_operation_set_mode (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (gpointer data1, gboolean arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}



