/* ConfigWidget.c generated by valac 0.10.0, the Vala compiler
 * generated from ConfigWidget.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008–2010 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gconf/gconf-client.h>
#include <stdlib.h>
#include <string.h>
#include <gconf/gconf.h>
#include <common.h>


#define DEJA_DUP_TYPE_CONFIG_WIDGET (deja_dup_config_widget_get_type ())
#define DEJA_DUP_CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidget))
#define DEJA_DUP_CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidgetClass))
#define DEJA_DUP_IS_CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET))
#define DEJA_DUP_IS_CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_WIDGET))
#define DEJA_DUP_CONFIG_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidgetClass))

typedef struct _DejaDupConfigWidget DejaDupConfigWidget;
typedef struct _DejaDupConfigWidgetClass DejaDupConfigWidgetClass;
typedef struct _DejaDupConfigWidgetPrivate DejaDupConfigWidgetPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DejaDupConfigWidget {
	GtkEventBox parent_instance;
	DejaDupConfigWidgetPrivate * priv;
	GConfClient* client;
};

struct _DejaDupConfigWidgetClass {
	GtkEventBoxClass parent_class;
	void (*set_from_config) (DejaDupConfigWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_from_config_finish) (DejaDupConfigWidget* self, GAsyncResult* _res_);
};

struct _DejaDupConfigWidgetPrivate {
	char* _key;
	GList* dirs;
};


static gpointer deja_dup_config_widget_parent_class = NULL;

GType deja_dup_config_widget_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_CONFIG_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidgetPrivate))
enum  {
	DEJA_DUP_CONFIG_WIDGET_DUMMY_PROPERTY,
	DEJA_DUP_CONFIG_WIDGET_KEY
};
static void _g_list_free_g_free (GList* self);
void deja_dup_config_widget_watch_key (DejaDupConfigWidget* self, const char* key);
static void deja_dup_config_widget_key_changed (DejaDupConfigWidget* self);
static void _deja_dup_config_widget_key_changed_gconf_client_notify_func (GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer self);
void deja_dup_config_widget_set_from_config (DejaDupConfigWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_config_widget_set_from_config_finish (DejaDupConfigWidget* self, GAsyncResult* _res_);
DejaDupConfigWidget* deja_dup_config_widget_construct (GType object_type);
const char* deja_dup_config_widget_get_key (DejaDupConfigWidget* self);
static void deja_dup_config_widget_set_key (DejaDupConfigWidget* self, const char* value);
static GObject * deja_dup_config_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void deja_dup_config_widget_finalize (GObject* obj);
static void deja_dup_config_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void deja_dup_config_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static void _deja_dup_config_widget_key_changed_gconf_client_notify_func (GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer self) {
	deja_dup_config_widget_key_changed (self);
}


void deja_dup_config_widget_watch_key (DejaDupConfigWidget* self, const char* key) {
	char* dir;
	const char* end;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	dir = g_strdup (key);
	end = g_utf8_strrchr (dir, (gssize) (-1), (gunichar) '/');
	if (end != NULL) {
		char* _tmp0_;
		dir = (_tmp0_ = string_substring (dir, (glong) 0, string_get_length (dir) - string_get_length (end)), _g_free0 (dir), _tmp0_);
	}
	{
		gconf_client_add_dir (self->client, dir, GCONF_CLIENT_PRELOAD_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch32_g_error;
		}
		gconf_client_notify_add (self->client, key, _deja_dup_config_widget_key_changed_gconf_client_notify_func, g_object_ref (self), g_object_unref, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch32_g_error;
		}
		self->priv->dirs = g_list_prepend (self->priv->dirs, g_strdup (dir));
	}
	goto __finally32;
	__catch32_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("ConfigWidget.vala:63: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally32:
	if (_inner_error_ != NULL) {
		_g_free0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (dir);
}


static void deja_dup_config_widget_key_changed (DejaDupConfigWidget* self) {
	g_return_if_fail (self != NULL);
	deja_dup_config_widget_set_from_config (self, NULL, NULL);
	g_signal_emit_by_name (self, "changed");
}


void deja_dup_config_widget_set_from_config (DejaDupConfigWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DEJA_DUP_CONFIG_WIDGET_GET_CLASS (self)->set_from_config (self, _callback_, _user_data_);
}


void deja_dup_config_widget_set_from_config_finish (DejaDupConfigWidget* self, GAsyncResult* _res_) {
	DEJA_DUP_CONFIG_WIDGET_GET_CLASS (self)->set_from_config_finish (self, _res_);
}


DejaDupConfigWidget* deja_dup_config_widget_construct (GType object_type) {
	DejaDupConfigWidget * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


const char* deja_dup_config_widget_get_key (DejaDupConfigWidget* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_key;
	return result;
}


static void deja_dup_config_widget_set_key (DejaDupConfigWidget* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_key = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_key), _tmp0_);
	g_object_notify ((GObject *) self, "key");
}


static GObject * deja_dup_config_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupConfigWidget * self;
	parent_class = G_OBJECT_CLASS (deja_dup_config_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DEJA_DUP_CONFIG_WIDGET (obj);
	{
		GConfClient* _tmp0_;
		self->client = (_tmp0_ = deja_dup_get_gconf_client (), _g_object_unref0 (self->client), _tmp0_);
		if (self->priv->_key != NULL) {
			deja_dup_config_widget_watch_key (self, self->priv->_key);
		}
	}
	return obj;
}


static void deja_dup_config_widget_class_init (DejaDupConfigWidgetClass * klass) {
	deja_dup_config_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupConfigWidgetPrivate));
	G_OBJECT_CLASS (klass)->get_property = deja_dup_config_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = deja_dup_config_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_config_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_config_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_CONFIG_WIDGET_KEY, g_param_spec_string ("key", "key", "key", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("changed", DEJA_DUP_TYPE_CONFIG_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void deja_dup_config_widget_instance_init (DejaDupConfigWidget * self) {
	self->priv = DEJA_DUP_CONFIG_WIDGET_GET_PRIVATE (self);
	self->priv->dirs = NULL;
}


static void deja_dup_config_widget_finalize (GObject* obj) {
	DejaDupConfigWidget * self;
	GError * _inner_error_;
	self = DEJA_DUP_CONFIG_WIDGET (obj);
	_inner_error_ = NULL;
	{
		{
			GList* dir_collection;
			GList* dir_it;
			dir_collection = self->priv->dirs;
			for (dir_it = dir_collection; dir_it != NULL; dir_it = dir_it->next) {
				char* dir;
				dir = g_strdup ((const char*) dir_it->data);
				{
					{
						gconf_client_remove_dir (self->client, dir, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch33_g_error;
						}
					}
					goto __finally33;
					__catch33_g_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						{
							g_warning ("ConfigWidget.vala:46: %s\n", e->message);
							_g_error_free0 (e);
						}
					}
					__finally33:
					if (_inner_error_ != NULL) {
						_g_free0 (dir);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
					}
					_g_free0 (dir);
				}
			}
		}
	}
	_g_free0 (self->priv->_key);
	__g_list_free_g_free0 (self->priv->dirs);
	_g_object_unref0 (self->client);
	G_OBJECT_CLASS (deja_dup_config_widget_parent_class)->finalize (obj);
}


GType deja_dup_config_widget_get_type (void) {
	static volatile gsize deja_dup_config_widget_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_config_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupConfigWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_config_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupConfigWidget), 0, (GInstanceInitFunc) deja_dup_config_widget_instance_init, NULL };
		GType deja_dup_config_widget_type_id;
		deja_dup_config_widget_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "DejaDupConfigWidget", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&deja_dup_config_widget_type_id__volatile, deja_dup_config_widget_type_id);
	}
	return deja_dup_config_widget_type_id__volatile;
}


static void deja_dup_config_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupConfigWidget * self;
	self = DEJA_DUP_CONFIG_WIDGET (object);
	switch (property_id) {
		case DEJA_DUP_CONFIG_WIDGET_KEY:
		g_value_set_string (value, deja_dup_config_widget_get_key (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_config_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupConfigWidget * self;
	self = DEJA_DUP_CONFIG_WIDGET (object);
	switch (property_id) {
		case DEJA_DUP_CONFIG_WIDGET_KEY:
		deja_dup_config_widget_set_key (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




