/* DuplicityInfo.c generated by valac 0.10.0, the Vala compiler
 * generated from DuplicityInfo.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008,2009 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define DEJA_DUP_TYPE_DUPLICITY_INFO (deja_dup_duplicity_info_get_type ())
#define DEJA_DUP_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfo))
#define DEJA_DUP_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))
#define DEJA_DUP_IS_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_IS_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_DUPLICITY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))

typedef struct _DejaDupDuplicityInfo DejaDupDuplicityInfo;
typedef struct _DejaDupDuplicityInfoClass DejaDupDuplicityInfoClass;
typedef struct _DejaDupDuplicityInfoPrivate DejaDupDuplicityInfoPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DejaDupDuplicityInfo {
	GObject parent_instance;
	DejaDupDuplicityInfoPrivate * priv;
};

struct _DejaDupDuplicityInfoClass {
	GObjectClass parent_class;
};

struct _DejaDupDuplicityInfoPrivate {
	gboolean _has_broken_cleanup;
	gboolean _has_backup_progress;
	gboolean _has_restore_progress;
	gboolean _has_collection_status;
	gboolean _new_time_format;
	gboolean _can_read_short_filenames;
	gboolean _has_native_gio;
	gboolean _can_resume;
	gboolean _has_rename_arg;
	gboolean _has_fixed_log_file;
	gboolean _use_empty_gpg_options;
	gboolean _can_recycle_space;
	char* version_string;
	gint major;
	gint minor;
	gint micro;
};


static DejaDupDuplicityInfo* deja_dup_duplicity_info_info;
static DejaDupDuplicityInfo* deja_dup_duplicity_info_info = NULL;
static gpointer deja_dup_duplicity_info_parent_class = NULL;

GType deja_dup_duplicity_info_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_DUPLICITY_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoPrivate))
enum  {
	DEJA_DUP_DUPLICITY_INFO_DUMMY_PROPERTY,
	DEJA_DUP_DUPLICITY_INFO_HAS_BROKEN_CLEANUP,
	DEJA_DUP_DUPLICITY_INFO_HAS_BACKUP_PROGRESS,
	DEJA_DUP_DUPLICITY_INFO_HAS_RESTORE_PROGRESS,
	DEJA_DUP_DUPLICITY_INFO_HAS_COLLECTION_STATUS,
	DEJA_DUP_DUPLICITY_INFO_NEW_TIME_FORMAT,
	DEJA_DUP_DUPLICITY_INFO_CAN_READ_SHORT_FILENAMES,
	DEJA_DUP_DUPLICITY_INFO_HAS_NATIVE_GIO,
	DEJA_DUP_DUPLICITY_INFO_CAN_RESUME,
	DEJA_DUP_DUPLICITY_INFO_HAS_RENAME_ARG,
	DEJA_DUP_DUPLICITY_INFO_HAS_FIXED_LOG_FILE,
	DEJA_DUP_DUPLICITY_INFO_USE_EMPTY_GPG_OPTIONS,
	DEJA_DUP_DUPLICITY_INFO_CAN_RECYCLE_SPACE
};
#define DEJA_DUP_DUPLICITY_INFO_REQUIRED_MAJOR 0
#define DEJA_DUP_DUPLICITY_INFO_REQUIRED_MINOR 5
#define DEJA_DUP_DUPLICITY_INFO_REQUIRED_MICRO 3
DejaDupDuplicityInfo* deja_dup_duplicity_info_get_default (void);
DejaDupDuplicityInfo* deja_dup_duplicity_info_new (void);
DejaDupDuplicityInfo* deja_dup_duplicity_info_construct (GType object_type);
gboolean deja_dup_duplicity_info_check_duplicity_version (DejaDupDuplicityInfo* self, char** header, char** msg);
static void deja_dup_duplicity_info_set_missing_duplicity_error (DejaDupDuplicityInfo* self, char** header, char** msg, const char* msg_in);
static gboolean deja_dup_duplicity_info_meets_requirements (DejaDupDuplicityInfo* self);
static void deja_dup_duplicity_info_set_bad_version_error (DejaDupDuplicityInfo* self, char** header, char** msg);
static gboolean deja_dup_duplicity_info_meets_version (DejaDupDuplicityInfo* self, gint vmaj, gint vmin, gint vmic);
static void deja_dup_duplicity_info_set_has_backup_progress (DejaDupDuplicityInfo* self, gboolean value);
static void deja_dup_duplicity_info_set_has_collection_status (DejaDupDuplicityInfo* self, gboolean value);
static gboolean deja_dup_duplicity_info_equals_version (DejaDupDuplicityInfo* self, gint vmaj, gint vmin, gint vmic);
static void deja_dup_duplicity_info_set_has_broken_cleanup (DejaDupDuplicityInfo* self, gboolean value);
static void deja_dup_duplicity_info_set_has_restore_progress (DejaDupDuplicityInfo* self, gboolean value);
static void deja_dup_duplicity_info_set_new_time_format (DejaDupDuplicityInfo* self, gboolean value);
static void deja_dup_duplicity_info_set_can_read_short_filenames (DejaDupDuplicityInfo* self, gboolean value);
static void deja_dup_duplicity_info_set_has_native_gio (DejaDupDuplicityInfo* self, gboolean value);
static void deja_dup_duplicity_info_set_has_rename_arg (DejaDupDuplicityInfo* self, gboolean value);
static void deja_dup_duplicity_info_set_has_fixed_log_file (DejaDupDuplicityInfo* self, gboolean value);
static void deja_dup_duplicity_info_set_use_empty_gpg_options (DejaDupDuplicityInfo* self, gboolean value);
gboolean deja_dup_duplicity_info_get_has_collection_status (DejaDupDuplicityInfo* self);
gboolean deja_dup_duplicity_info_get_has_backup_progress (DejaDupDuplicityInfo* self);
static void deja_dup_duplicity_info_set_can_recycle_space (DejaDupDuplicityInfo* self, gboolean value);
gboolean deja_dup_duplicity_info_get_has_broken_cleanup (DejaDupDuplicityInfo* self);
gboolean deja_dup_duplicity_info_get_has_restore_progress (DejaDupDuplicityInfo* self);
gboolean deja_dup_duplicity_info_get_new_time_format (DejaDupDuplicityInfo* self);
gboolean deja_dup_duplicity_info_get_can_read_short_filenames (DejaDupDuplicityInfo* self);
gboolean deja_dup_duplicity_info_get_has_native_gio (DejaDupDuplicityInfo* self);
gboolean deja_dup_duplicity_info_get_can_resume (DejaDupDuplicityInfo* self);
static void deja_dup_duplicity_info_set_can_resume (DejaDupDuplicityInfo* self, gboolean value);
gboolean deja_dup_duplicity_info_get_has_rename_arg (DejaDupDuplicityInfo* self);
gboolean deja_dup_duplicity_info_get_has_fixed_log_file (DejaDupDuplicityInfo* self);
gboolean deja_dup_duplicity_info_get_use_empty_gpg_options (DejaDupDuplicityInfo* self);
gboolean deja_dup_duplicity_info_get_can_recycle_space (DejaDupDuplicityInfo* self);
static void deja_dup_duplicity_info_finalize (GObject* obj);
static void deja_dup_duplicity_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void deja_dup_duplicity_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


DejaDupDuplicityInfo* deja_dup_duplicity_info_get_default (void) {
	DejaDupDuplicityInfo* result = NULL;
	if (deja_dup_duplicity_info_info == NULL) {
		DejaDupDuplicityInfo* _tmp0_;
		deja_dup_duplicity_info_info = (_tmp0_ = deja_dup_duplicity_info_new (), _g_object_unref0 (deja_dup_duplicity_info_info), _tmp0_);
	}
	result = _g_object_ref0 (deja_dup_duplicity_info_info);
	return result;
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


gboolean deja_dup_duplicity_info_check_duplicity_version (DejaDupDuplicityInfo* self, char** header, char** msg) {
	gboolean result = FALSE;
	char* output;
	gint tokens_length1;
	gint _tokens_size_;
	char** _tmp7_;
	char** _tmp6_;
	char** tokens;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	char* _tmp14_;
	gint ver_tokens_length1;
	gint _ver_tokens_size_;
	char** _tmp16_;
	char** _tmp15_;
	char** ver_tokens;
	gboolean _tmp17_ = FALSE;
	gboolean good_enough;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (header != NULL) {
		*header = NULL;
	}
	if (msg != NULL) {
		*msg = NULL;
	}
	output = NULL;
	{
		char* _tmp0_ = NULL;
		char* _tmp1_;
		g_spawn_command_line_sync ("duplicity --version", &_tmp0_, NULL, NULL, &_inner_error_);
		output = (_tmp1_ = _tmp0_, _g_free0 (output), _tmp1_);
		if (_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp2_ = NULL;
			char* _tmp3_;
			char* _tmp4_ = NULL;
			char* _tmp5_;
			(deja_dup_duplicity_info_set_missing_duplicity_error (self, &_tmp2_, &_tmp4_, e->message), *header = (_tmp3_ = _tmp2_, _g_free0 (*header), _tmp3_));
			*msg = (_tmp5_ = _tmp4_, _g_free0 (*msg), _tmp5_);
			result = FALSE;
			_g_error_free0 (e);
			_g_free0 (output);
			return result;
		}
	}
	__finally21:
	if (_inner_error_ != NULL) {
		_g_free0 (output);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	tokens = (_tmp7_ = _tmp6_ = g_strsplit (output, " ", 2), tokens_length1 = _vala_array_length (_tmp6_), _tokens_size_ = tokens_length1, _tmp7_);
	if (tokens == NULL) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = tokens[0] == NULL;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = tokens[1] == NULL;
	}
	if (_tmp8_) {
		char* _tmp10_ = NULL;
		char* _tmp11_;
		char* _tmp12_ = NULL;
		char* _tmp13_;
		(deja_dup_duplicity_info_set_missing_duplicity_error (self, &_tmp10_, &_tmp12_, NULL), *header = (_tmp11_ = _tmp10_, _g_free0 (*header), _tmp11_));
		*msg = (_tmp13_ = _tmp12_, _g_free0 (*msg), _tmp13_);
		result = FALSE;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (output);
		return result;
	}
	self->priv->version_string = (_tmp14_ = string_strip (tokens[1]), _g_free0 (self->priv->version_string), _tmp14_);
	ver_tokens = (_tmp16_ = _tmp15_ = g_strsplit (self->priv->version_string, ".", 0), ver_tokens_length1 = _vala_array_length (_tmp15_), _ver_tokens_size_ = ver_tokens_length1, _tmp16_);
	if (ver_tokens == NULL) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = ver_tokens[0] == NULL;
	}
	if (_tmp17_) {
		char* _tmp18_ = NULL;
		char* _tmp19_;
		char* _tmp20_ = NULL;
		char* _tmp21_;
		(deja_dup_duplicity_info_set_missing_duplicity_error (self, &_tmp18_, &_tmp20_, NULL), *header = (_tmp19_ = _tmp18_, _g_free0 (*header), _tmp19_));
		*msg = (_tmp21_ = _tmp20_, _g_free0 (*msg), _tmp21_);
		result = FALSE;
		ver_tokens = (_vala_array_free (ver_tokens, ver_tokens_length1, (GDestroyNotify) g_free), NULL);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (output);
		return result;
	}
	self->priv->major = atoi (ver_tokens[0]);
	if (ver_tokens[1] != NULL) {
		self->priv->minor = atoi (ver_tokens[1]);
		if (ver_tokens[2] != NULL) {
			self->priv->micro = atoi (ver_tokens[2]);
		}
	}
	good_enough = deja_dup_duplicity_info_meets_requirements (self);
	if (!good_enough) {
		char* _tmp22_ = NULL;
		char* _tmp23_;
		char* _tmp24_ = NULL;
		char* _tmp25_;
		(deja_dup_duplicity_info_set_bad_version_error (self, &_tmp22_, &_tmp24_), *header = (_tmp23_ = _tmp22_, _g_free0 (*header), _tmp23_));
		*msg = (_tmp25_ = _tmp24_, _g_free0 (*msg), _tmp25_);
		result = FALSE;
		ver_tokens = (_vala_array_free (ver_tokens, ver_tokens_length1, (GDestroyNotify) g_free), NULL);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (output);
		return result;
	}
	if (deja_dup_duplicity_info_meets_version (self, 0, 5, 4)) {
		deja_dup_duplicity_info_set_has_backup_progress (self, TRUE);
		deja_dup_duplicity_info_set_has_collection_status (self, TRUE);
	}
	if (deja_dup_duplicity_info_equals_version (self, 0, 5, 4)) {
		_tmp26_ = TRUE;
	} else {
		_tmp26_ = deja_dup_duplicity_info_equals_version (self, 0, 5, 5);
	}
	if (_tmp26_) {
		deja_dup_duplicity_info_set_has_broken_cleanup (self, TRUE);
	}
	if (deja_dup_duplicity_info_meets_version (self, 0, 5, 6)) {
		deja_dup_duplicity_info_set_has_restore_progress (self, TRUE);
	}
	if (deja_dup_duplicity_info_meets_version (self, 0, 5, 10)) {
		deja_dup_duplicity_info_set_new_time_format (self, TRUE);
	}
	if (deja_dup_duplicity_info_meets_version (self, 0, 5, 16)) {
		deja_dup_duplicity_info_set_can_read_short_filenames (self, TRUE);
	}
	if (deja_dup_duplicity_info_meets_version (self, 0, 6, 5)) {
		deja_dup_duplicity_info_set_has_native_gio (self, TRUE);
	}
	if (deja_dup_duplicity_info_meets_version (self, 0, 6, 7)) {
		deja_dup_duplicity_info_set_has_rename_arg (self, TRUE);
		deja_dup_duplicity_info_set_has_fixed_log_file (self, TRUE);
	}
	if (deja_dup_duplicity_info_equals_version (self, 0, 6, 8)) {
		deja_dup_duplicity_info_set_use_empty_gpg_options (self, TRUE);
	}
	if (self->priv->_has_collection_status) {
		_tmp27_ = self->priv->_has_backup_progress;
	} else {
		_tmp27_ = FALSE;
	}
	deja_dup_duplicity_info_set_can_recycle_space (self, _tmp27_);
	result = TRUE;
	ver_tokens = (_vala_array_free (ver_tokens, ver_tokens_length1, (GDestroyNotify) g_free), NULL);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (output);
	return result;
}


static gboolean deja_dup_duplicity_info_meets_version (DejaDupDuplicityInfo* self, gint vmaj, gint vmin, gint vmic) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->major > vmaj) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (self->priv->major == vmaj) {
			_tmp2_ = self->priv->minor > vmin;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp1_ = _tmp2_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (self->priv->major == vmaj) {
			_tmp4_ = self->priv->minor == vmin;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			_tmp3_ = self->priv->micro >= vmic;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}


static gboolean deja_dup_duplicity_info_equals_version (DejaDupDuplicityInfo* self, gint vmaj, gint vmin, gint vmic) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->major == vmaj) {
		_tmp1_ = self->priv->minor == vmin;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->micro == vmic;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean deja_dup_duplicity_info_meets_requirements (DejaDupDuplicityInfo* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = deja_dup_duplicity_info_meets_version (self, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MAJOR, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MINOR, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MICRO);
	return result;
}


static char* string_chomp (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strchomp (_result_);
	result = _result_;
	return result;
}


static void deja_dup_duplicity_info_set_missing_duplicity_error (DejaDupDuplicityInfo* self, char** header, char** msg, const char* msg_in) {
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp6_;
	g_return_if_fail (self != NULL);
	if (header != NULL) {
		*header = NULL;
	}
	if (msg != NULL) {
		*msg = NULL;
	}
	*header = (_tmp0_ = g_strdup (_ ("Could not run duplicity")), _g_free0 (*header), _tmp0_);
	*msg = (_tmp1_ = g_strdup (msg_in), _g_free0 (*msg), _tmp1_);
	if ((*msg) != NULL) {
		char* _tmp2_;
		char* _tmp3_;
		*msg = (_tmp3_ = g_strconcat (_tmp2_ = string_chomp (*msg), "\n\n", NULL), _g_free0 (*msg), _tmp3_);
		_g_free0 (_tmp2_);
	} else {
		if (self->priv->version_string == NULL) {
			char* _tmp4_;
			*msg = (_tmp4_ = g_strdup (_ ("Could not understand duplicity version.\n\n")), _g_free0 (*msg), _tmp4_);
		} else {
			char* _tmp5_;
			*msg = (_tmp5_ = g_strdup_printf (_ ("Could not understand duplicity version ‘%s’.\n\n"), self->priv->version_string), _g_free0 (*msg), _tmp5_);
		}
	}
	*msg = (_tmp6_ = g_strconcat (*msg, _ ("Without duplicity, Déjà Dup cannot function.  It will close now."), NULL), _g_free0 (*msg), _tmp6_);
}


static void deja_dup_duplicity_info_set_bad_version_error (DejaDupDuplicityInfo* self, char** header, char** msg) {
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	if (header != NULL) {
		*header = NULL;
	}
	if (msg != NULL) {
		*msg = NULL;
	}
	*header = (_tmp0_ = g_strdup (_ ("Duplicity’s version is too old")), _g_free0 (*header), _tmp0_);
	*msg = (_tmp1_ = g_strdup_printf (_ ("Déjà Dup requires at least version %d.%d.%.2d of duplicity, but only f" \
"ound version %d.%d.%.2d"), DEJA_DUP_DUPLICITY_INFO_REQUIRED_MAJOR, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MINOR, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MICRO, self->priv->major, self->priv->minor, self->priv->micro), _g_free0 (*msg), _tmp1_);
}


DejaDupDuplicityInfo* deja_dup_duplicity_info_construct (GType object_type) {
	DejaDupDuplicityInfo * self;
	self = (DejaDupDuplicityInfo*) g_object_new (object_type, NULL);
	return self;
}


DejaDupDuplicityInfo* deja_dup_duplicity_info_new (void) {
	return deja_dup_duplicity_info_construct (DEJA_DUP_TYPE_DUPLICITY_INFO);
}


gboolean deja_dup_duplicity_info_get_has_broken_cleanup (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_broken_cleanup;
	return result;
}


static void deja_dup_duplicity_info_set_has_broken_cleanup (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_broken_cleanup = value;
	g_object_notify ((GObject *) self, "has-broken-cleanup");
}


gboolean deja_dup_duplicity_info_get_has_backup_progress (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_backup_progress;
	return result;
}


static void deja_dup_duplicity_info_set_has_backup_progress (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_backup_progress = value;
	g_object_notify ((GObject *) self, "has-backup-progress");
}


gboolean deja_dup_duplicity_info_get_has_restore_progress (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_restore_progress;
	return result;
}


static void deja_dup_duplicity_info_set_has_restore_progress (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_restore_progress = value;
	g_object_notify ((GObject *) self, "has-restore-progress");
}


gboolean deja_dup_duplicity_info_get_has_collection_status (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_collection_status;
	return result;
}


static void deja_dup_duplicity_info_set_has_collection_status (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_collection_status = value;
	g_object_notify ((GObject *) self, "has-collection-status");
}


gboolean deja_dup_duplicity_info_get_new_time_format (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_new_time_format;
	return result;
}


static void deja_dup_duplicity_info_set_new_time_format (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_new_time_format = value;
	g_object_notify ((GObject *) self, "new-time-format");
}


gboolean deja_dup_duplicity_info_get_can_read_short_filenames (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_read_short_filenames;
	return result;
}


static void deja_dup_duplicity_info_set_can_read_short_filenames (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_can_read_short_filenames = value;
	g_object_notify ((GObject *) self, "can-read-short-filenames");
}


gboolean deja_dup_duplicity_info_get_has_native_gio (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_native_gio;
	return result;
}


static void deja_dup_duplicity_info_set_has_native_gio (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_native_gio = value;
	g_object_notify ((GObject *) self, "has-native-gio");
}


gboolean deja_dup_duplicity_info_get_can_resume (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_resume;
	return result;
}


static void deja_dup_duplicity_info_set_can_resume (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_can_resume = value;
	g_object_notify ((GObject *) self, "can-resume");
}


gboolean deja_dup_duplicity_info_get_has_rename_arg (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_rename_arg;
	return result;
}


static void deja_dup_duplicity_info_set_has_rename_arg (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_rename_arg = value;
	g_object_notify ((GObject *) self, "has-rename-arg");
}


gboolean deja_dup_duplicity_info_get_has_fixed_log_file (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_fixed_log_file;
	return result;
}


static void deja_dup_duplicity_info_set_has_fixed_log_file (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_fixed_log_file = value;
	g_object_notify ((GObject *) self, "has-fixed-log-file");
}


gboolean deja_dup_duplicity_info_get_use_empty_gpg_options (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_empty_gpg_options;
	return result;
}


static void deja_dup_duplicity_info_set_use_empty_gpg_options (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_use_empty_gpg_options = value;
	g_object_notify ((GObject *) self, "use-empty-gpg-options");
}


gboolean deja_dup_duplicity_info_get_can_recycle_space (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_recycle_space;
	return result;
}


static void deja_dup_duplicity_info_set_can_recycle_space (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_can_recycle_space = value;
	g_object_notify ((GObject *) self, "can-recycle-space");
}


static void deja_dup_duplicity_info_class_init (DejaDupDuplicityInfoClass * klass) {
	deja_dup_duplicity_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupDuplicityInfoPrivate));
	G_OBJECT_CLASS (klass)->get_property = deja_dup_duplicity_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = deja_dup_duplicity_info_set_property;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_duplicity_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_HAS_BROKEN_CLEANUP, g_param_spec_boolean ("has-broken-cleanup", "has-broken-cleanup", "has-broken-cleanup", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_HAS_BACKUP_PROGRESS, g_param_spec_boolean ("has-backup-progress", "has-backup-progress", "has-backup-progress", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_HAS_RESTORE_PROGRESS, g_param_spec_boolean ("has-restore-progress", "has-restore-progress", "has-restore-progress", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_HAS_COLLECTION_STATUS, g_param_spec_boolean ("has-collection-status", "has-collection-status", "has-collection-status", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_NEW_TIME_FORMAT, g_param_spec_boolean ("new-time-format", "new-time-format", "new-time-format", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_CAN_READ_SHORT_FILENAMES, g_param_spec_boolean ("can-read-short-filenames", "can-read-short-filenames", "can-read-short-filenames", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_HAS_NATIVE_GIO, g_param_spec_boolean ("has-native-gio", "has-native-gio", "has-native-gio", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_CAN_RESUME, g_param_spec_boolean ("can-resume", "can-resume", "can-resume", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_HAS_RENAME_ARG, g_param_spec_boolean ("has-rename-arg", "has-rename-arg", "has-rename-arg", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_HAS_FIXED_LOG_FILE, g_param_spec_boolean ("has-fixed-log-file", "has-fixed-log-file", "has-fixed-log-file", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_USE_EMPTY_GPG_OPTIONS, g_param_spec_boolean ("use-empty-gpg-options", "use-empty-gpg-options", "use-empty-gpg-options", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_CAN_RECYCLE_SPACE, g_param_spec_boolean ("can-recycle-space", "can-recycle-space", "can-recycle-space", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void deja_dup_duplicity_info_instance_init (DejaDupDuplicityInfo * self) {
	self->priv = DEJA_DUP_DUPLICITY_INFO_GET_PRIVATE (self);
	self->priv->_has_broken_cleanup = FALSE;
	self->priv->_has_backup_progress = FALSE;
	self->priv->_has_restore_progress = FALSE;
	self->priv->_has_collection_status = FALSE;
	self->priv->_new_time_format = FALSE;
	self->priv->_can_read_short_filenames = FALSE;
	self->priv->_has_native_gio = FALSE;
	self->priv->_can_resume = FALSE;
	self->priv->_has_rename_arg = FALSE;
	self->priv->_has_fixed_log_file = FALSE;
	self->priv->_use_empty_gpg_options = FALSE;
	self->priv->_can_recycle_space = FALSE;
	self->priv->version_string = NULL;
	self->priv->major = 0;
	self->priv->minor = 0;
	self->priv->micro = 0;
}


static void deja_dup_duplicity_info_finalize (GObject* obj) {
	DejaDupDuplicityInfo * self;
	self = DEJA_DUP_DUPLICITY_INFO (obj);
	_g_free0 (self->priv->version_string);
	G_OBJECT_CLASS (deja_dup_duplicity_info_parent_class)->finalize (obj);
}


GType deja_dup_duplicity_info_get_type (void) {
	static volatile gsize deja_dup_duplicity_info_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_duplicity_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupDuplicityInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_duplicity_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupDuplicityInfo), 0, (GInstanceInitFunc) deja_dup_duplicity_info_instance_init, NULL };
		GType deja_dup_duplicity_info_type_id;
		deja_dup_duplicity_info_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupDuplicityInfo", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_duplicity_info_type_id__volatile, deja_dup_duplicity_info_type_id);
	}
	return deja_dup_duplicity_info_type_id__volatile;
}


static void deja_dup_duplicity_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupDuplicityInfo * self;
	self = DEJA_DUP_DUPLICITY_INFO (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_INFO_HAS_BROKEN_CLEANUP:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_has_broken_cleanup (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_BACKUP_PROGRESS:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_has_backup_progress (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_RESTORE_PROGRESS:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_has_restore_progress (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_COLLECTION_STATUS:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_has_collection_status (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_NEW_TIME_FORMAT:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_new_time_format (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_CAN_READ_SHORT_FILENAMES:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_can_read_short_filenames (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_NATIVE_GIO:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_has_native_gio (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_CAN_RESUME:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_can_resume (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_RENAME_ARG:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_has_rename_arg (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_FIXED_LOG_FILE:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_has_fixed_log_file (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_USE_EMPTY_GPG_OPTIONS:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_use_empty_gpg_options (self));
		break;
		case DEJA_DUP_DUPLICITY_INFO_CAN_RECYCLE_SPACE:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_can_recycle_space (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_duplicity_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupDuplicityInfo * self;
	self = DEJA_DUP_DUPLICITY_INFO (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_INFO_HAS_BROKEN_CLEANUP:
		deja_dup_duplicity_info_set_has_broken_cleanup (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_BACKUP_PROGRESS:
		deja_dup_duplicity_info_set_has_backup_progress (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_RESTORE_PROGRESS:
		deja_dup_duplicity_info_set_has_restore_progress (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_COLLECTION_STATUS:
		deja_dup_duplicity_info_set_has_collection_status (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_NEW_TIME_FORMAT:
		deja_dup_duplicity_info_set_new_time_format (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_CAN_READ_SHORT_FILENAMES:
		deja_dup_duplicity_info_set_can_read_short_filenames (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_NATIVE_GIO:
		deja_dup_duplicity_info_set_has_native_gio (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_CAN_RESUME:
		deja_dup_duplicity_info_set_can_resume (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_RENAME_ARG:
		deja_dup_duplicity_info_set_has_rename_arg (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_HAS_FIXED_LOG_FILE:
		deja_dup_duplicity_info_set_has_fixed_log_file (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_USE_EMPTY_GPG_OPTIONS:
		deja_dup_duplicity_info_set_use_empty_gpg_options (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_INFO_CAN_RECYCLE_SPACE:
		deja_dup_duplicity_info_set_can_recycle_space (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




