/* AssistantBackup.c generated by valac 0.12.0, the Vala compiler
 * generated from AssistantBackup.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008–2010 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <common.h>
#include <stdlib.h>
#include <string.h>
#include <widgets.h>
#include <glib/gi18n-lib.h>
#include <whacks.h>
#include <gio/gio.h>


#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define ASSISTANT_TYPE_PAGE_INFO (assistant_page_info_get_type ())
#define ASSISTANT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfo))
#define ASSISTANT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))
#define ASSISTANT_IS_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_IS_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))

typedef struct _AssistantPageInfo AssistantPageInfo;
typedef struct _AssistantPageInfoClass AssistantPageInfoClass;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
typedef struct _AssistantOperationPrivate AssistantOperationPrivate;

#define TYPE_STATUS_ICON (status_icon_get_type ())
#define STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATUS_ICON, StatusIcon))
#define STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATUS_ICON, StatusIconClass))
#define IS_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATUS_ICON))
#define IS_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATUS_ICON))
#define STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATUS_ICON, StatusIconClass))

typedef struct _StatusIcon StatusIcon;
typedef struct _StatusIconClass StatusIconClass;

#define TYPE_ASSISTANT_BACKUP (assistant_backup_get_type ())
#define ASSISTANT_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_BACKUP, AssistantBackup))
#define ASSISTANT_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_BACKUP, AssistantBackupClass))
#define IS_ASSISTANT_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_BACKUP))
#define IS_ASSISTANT_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_BACKUP))
#define ASSISTANT_BACKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_BACKUP, AssistantBackupClass))

typedef struct _AssistantBackup AssistantBackup;
typedef struct _AssistantBackupClass AssistantBackupClass;
typedef struct _AssistantBackupPrivate AssistantBackupPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Assistant {
	GtkDialog parent_instance;
	AssistantPrivate * priv;
	GtkImage* header_icon;
	GtkEventBox* page_box;
	GList* current;
};

struct _AssistantClass {
	GtkDialogClass parent_class;
	void (*hide_for_now) (Assistant* self);
};

struct _AssistantOperation {
	Assistant parent_instance;
	AssistantOperationPrivate * priv;
	StatusIcon* status_icon;
	gboolean succeeded;
	GtkLabel* summary_label;
	DejaDupOperation* op;
};

struct _AssistantOperationClass {
	AssistantClass parent_class;
	GtkWidget* (*make_confirm_page) (AssistantOperation* self);
	void (*add_setup_pages) (AssistantOperation* self);
	void (*add_custom_config_pages) (AssistantOperation* self);
	DejaDupOperation* (*create_op) (AssistantOperation* self);
	gchar* (*get_progress_file_prefix) (AssistantOperation* self);
	void (*set_op_icon_name) (AssistantOperation* self);
	GtkWidget* (*make_progress_page) (AssistantOperation* self);
	void (*show_error) (AssistantOperation* self, const gchar* _error_, const gchar* detail);
	GtkWidget* (*make_summary_page) (AssistantOperation* self);
	void (*apply_finished) (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled);
	void (*do_prepare) (AssistantOperation* self, Assistant* assist, GtkWidget* page);
	void (*do_cancel) (AssistantOperation* self);
	void (*do_close) (AssistantOperation* self);
};

struct _AssistantBackup {
	AssistantOperation parent_instance;
	AssistantBackupPrivate * priv;
};

struct _AssistantBackupClass {
	AssistantOperationClass parent_class;
};

struct _AssistantBackupPrivate {
	DejaDupToggleGroup* periodic_toggle;
};

typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_SUMMARY,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;


static gpointer assistant_backup_parent_class = NULL;

GType assistant_get_type (void) G_GNUC_CONST;
static gpointer assistant_page_info_ref (gpointer instance);
static void assistant_page_info_unref (gpointer instance);
static GParamSpec* assistant_param_spec_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void assistant_value_set_page_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void assistant_value_take_page_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer assistant_value_get_page_info (const GValue* value) G_GNUC_UNUSED;
static GType assistant_page_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType assistant_operation_get_type (void) G_GNUC_CONST;
GType status_icon_get_type (void) G_GNUC_CONST;
GType assistant_backup_get_type (void) G_GNUC_CONST;
#define ASSISTANT_BACKUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASSISTANT_BACKUP, AssistantBackupPrivate))
enum  {
	ASSISTANT_BACKUP_DUMMY_PROPERTY
};
AssistantBackup* assistant_backup_new (gboolean automatic);
AssistantBackup* assistant_backup_construct (GType object_type, gboolean automatic);
static GtkWidget* assistant_backup_make_backup_location_page (AssistantBackup* self);
static GtkWidget* assistant_backup_make_include_exclude_page (AssistantBackup* self);
static void assistant_backup_real_add_custom_config_pages (AssistantOperation* base);
gboolean assistant_operation_get_automatic (AssistantOperation* self);
GType assistant_type_get_type (void) G_GNUC_CONST;
void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type);
void assistant_set_page_title (Assistant* self, GtkWidget* page, const gchar* title);
static GtkWidget* assistant_backup_real_make_confirm_page (AssistantOperation* base);
static DejaDupOperation* assistant_backup_real_create_op (AssistantOperation* base);
void assistant_operation_ensure_status_icon (AssistantOperation* self, DejaDupOperation* o);
gboolean status_icon_get_show_automatic_progress (StatusIcon* self);
static void _lambda20_ (DejaDupOperation* op, AssistantBackup* self);
static void __lambda20__deja_dup_operation_is_full (DejaDupOperation* _sender, gpointer self);
void assistant_hide_for_now (Assistant* self);
static void assistant_backup_do_resume (AssistantBackup* self);
void assistant_operation_hide_everything (AssistantOperation* self);
void assistant_operation_do_close (AssistantOperation* self);
static gchar* assistant_backup_real_get_progress_file_prefix (AssistantOperation* base);
static void assistant_backup_real_set_op_icon_name (AssistantOperation* base);
static void assistant_backup_add_periodic_widgets (AssistantBackup* self, GtkVBox* page);
static void assistant_backup_real_do_prepare (AssistantOperation* base, Assistant* assist, GtkWidget* page);
void assistant_operation_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page);
GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self);
gboolean assistant_operation_get_error_occurred (AssistantOperation* self);
static gboolean _lambda21_ (AssistantBackup* self);
static gboolean __lambda21__gsource_func (gpointer self);
static gboolean _lambda22_ (AssistantBackup* self);
void assistant_operation_force_visible (AssistantOperation* self, gboolean user_click);
static gboolean __lambda22__gsource_func (gpointer self);
GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self);
static GObject * assistant_backup_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void assistant_set_apply_text (Assistant* self, const gchar* value);
void assistant_set_resume_supported (Assistant* self, gboolean value);
static void _assistant_backup_do_resume_assistant_resumed (Assistant* _sender, gpointer self);
static void assistant_backup_finalize (GObject* obj);


AssistantBackup* assistant_backup_construct (GType object_type, gboolean automatic) {
	AssistantBackup * self = NULL;
	self = (AssistantBackup*) g_object_new (object_type, "automatic", automatic, NULL);
	return self;
}


AssistantBackup* assistant_backup_new (gboolean automatic) {
	return assistant_backup_construct (TYPE_ASSISTANT_BACKUP, automatic);
}


static GtkWidget* assistant_backup_make_backup_location_page (AssistantBackup* self) {
	GtkWidget* result = NULL;
	gint rows;
	GtkWidget* w = NULL;
	GtkWidget* label = NULL;
	GtkSizeGroup* _tmp0_ = NULL;
	GtkSizeGroup* label_sizes;
	GtkVBox* _tmp1_ = NULL;
	GtkVBox* vbox;
	GtkTable* _tmp2_ = NULL;
	GtkTable* page;
	DejaDupConfigLocation* _tmp3_ = NULL;
	DejaDupConfigLocation* location;
	const gchar* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkEventBox* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	DejaDupConfigBool* _tmp8_ = NULL;
	DejaDupConfigLabelPolicy* _tmp9_ = NULL;
	GtkRequisition req = {0};
	GtkRequisition hidden = {0};
	GtkRequisition _tmp10_ = {0};
	GtkRequisition _tmp11_ = {0};
	GtkRequisition _tmp12_ = {0};
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	_tmp0_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	label_sizes = _tmp0_;
	_tmp1_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	vbox = g_object_ref_sink (_tmp1_);
	gtk_container_set_border_width ((GtkContainer*) vbox, (guint) 12);
	_tmp2_ = (GtkTable*) gtk_table_new ((guint) rows, (guint) 2, FALSE);
	page = g_object_ref_sink (_tmp2_);
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, NULL);
	_tmp3_ = deja_dup_config_location_new (label_sizes);
	location = g_object_ref_sink (_tmp3_);
	_tmp4_ = _ ("_Backup location:");
	_tmp5_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp4_);
	_g_object_unref0 (label);
	label = (GtkWidget*) g_object_ref_sink (_tmp5_);
	g_object_set ((GObject*) label, "xalign", 0.0f, "mnemonic-widget", location, NULL);
	gtk_size_group_add_widget (label_sizes, label);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	gtk_table_attach (page, (GtkWidget*) location, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	_tmp6_ = deja_dup_config_location_get_extras (location);
	gtk_table_attach (page, (GtkWidget*) _tmp6_, (guint) 0, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	_tmp7_ = _ ("_Encrypt backup files");
	_tmp8_ = deja_dup_config_bool_new (DEJA_DUP_ENCRYPT_KEY, _tmp7_, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp8_);
	gtk_table_attach (page, w, (guint) 0, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	_tmp9_ = deja_dup_config_label_policy_new ();
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp9_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) page, TRUE, TRUE, (guint) 0);
	gtk_box_pack_end ((GtkBox*) vbox, w, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) vbox);
	hacks_get_natural_size ((GtkWidget*) vbox, &_tmp10_);
	req = _tmp10_;
	deja_dup_config_location_hidden_size (location, &_tmp11_);
	_tmp12_ = _tmp11_;
	hidden = _tmp12_;
	req.width = req.width + hidden.width;
	req.height = req.height + hidden.height;
	gtk_widget_set_size_request ((GtkWidget*) vbox, req.width, req.height);
	result = (GtkWidget*) vbox;
	_g_object_unref0 (location);
	_g_object_unref0 (page);
	_g_object_unref0 (label_sizes);
	_g_object_unref0 (label);
	_g_object_unref0 (w);
	return result;
}


static GtkWidget* assistant_backup_make_include_exclude_page (AssistantBackup* self) {
	GtkWidget* result = NULL;
	gint rows;
	GtkWidget* w = NULL;
	GtkWidget* label = NULL;
	GtkTable* _tmp0_ = NULL;
	GtkTable* page;
	DejaDupConfigList* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	DejaDupConfigList* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	_tmp0_ = (GtkTable*) gtk_table_new ((guint) rows, (guint) 2, FALSE);
	page = g_object_ref_sink (_tmp0_);
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	_tmp1_ = deja_dup_config_list_new (DEJA_DUP_INCLUDE_LIST_KEY, NULL, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp1_);
	gtk_widget_set_size_request (w, 250, 100);
	_tmp2_ = _ ("I_nclude files in folders:");
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	_g_object_unref0 (label);
	label = (GtkWidget*) g_object_ref_sink (_tmp3_);
	g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "wrap", TRUE, "width-request", 100, "xalign", 0.0f, "yalign", 0.0f, NULL);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	_tmp4_ = deja_dup_config_list_new (DEJA_DUP_EXCLUDE_LIST_KEY, NULL, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp4_);
	gtk_widget_set_size_request (w, 250, 70);
	_tmp5_ = _ ("E_xcept files in folders:");
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	_g_object_unref0 (label);
	label = (GtkWidget*) g_object_ref_sink (_tmp6_);
	g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "wrap", TRUE, "width-request", 100, "xalign", 0.0f, "yalign", 0.0f, NULL);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, (guint) 0, (guint) 0);
	rows = rows + 1;
	result = (GtkWidget*) page;
	_g_object_unref0 (label);
	_g_object_unref0 (w);
	return result;
}


static void assistant_backup_real_add_custom_config_pages (AssistantOperation* base) {
	AssistantBackup * self;
	gboolean _tmp0_;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* page;
	const gchar* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	self = (AssistantBackup*) base;
	_tmp0_ = assistant_operation_get_automatic ((AssistantOperation*) self);
	if (_tmp0_) {
		return;
	}
	_tmp1_ = assistant_backup_make_backup_location_page (self);
	page = _tmp1_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_NORMAL);
	_tmp2_ = _ ("Preferences");
	assistant_set_page_title ((Assistant*) self, page, _tmp2_);
	_tmp3_ = assistant_backup_make_include_exclude_page (self);
	_g_object_unref0 (page);
	page = _tmp3_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_NORMAL);
	_tmp4_ = _ ("Preferences");
	assistant_set_page_title ((Assistant*) self, page, _tmp4_);
	_g_object_unref0 (page);
}


static GtkWidget* assistant_backup_real_make_confirm_page (AssistantOperation* base) {
	AssistantBackup * self;
	GtkWidget* result = NULL;
	gboolean _tmp0_;
	gint rows;
	GtkWidget* label = NULL;
	GtkWidget* w = NULL;
	GtkTable* _tmp1_ = NULL;
	GtkTable* page;
	const gchar* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	DejaDupConfigLabelLocation* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	DejaDupConfigLabelBool* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	DejaDupConfigLabelList* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	DejaDupConfigLabelList* _tmp13_ = NULL;
	self = (AssistantBackup*) base;
	_tmp0_ = assistant_operation_get_automatic ((AssistantOperation*) self);
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	rows = 0;
	_tmp1_ = (GtkTable*) gtk_table_new ((guint) rows, (guint) 2, FALSE);
	page = g_object_ref_sink (_tmp1_);
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	_tmp2_ = _ ("Backup location:");
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	_g_object_unref0 (label);
	label = (GtkWidget*) g_object_ref_sink (_tmp3_);
	g_object_set ((GObject*) label, "xalign", 0.0f, NULL);
	_tmp4_ = deja_dup_config_label_location_new ();
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp4_);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	_tmp5_ = _ ("Encrypted:");
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	_g_object_unref0 (label);
	label = (GtkWidget*) g_object_ref_sink (_tmp6_);
	g_object_set ((GObject*) label, "xalign", 0.0f, NULL);
	_tmp7_ = deja_dup_config_label_bool_new (DEJA_DUP_ENCRYPT_KEY, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp7_);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, 0, (guint) 0, (guint) 0);
	rows = rows + 1;
	_tmp8_ = _ ("Include from:");
	_tmp9_ = (GtkLabel*) gtk_label_new (_tmp8_);
	_g_object_unref0 (label);
	label = (GtkWidget*) g_object_ref_sink (_tmp9_);
	g_object_set ((GObject*) label, "xalign", 0.0f, "yalign", 0.0f, NULL);
	_tmp10_ = deja_dup_config_label_list_new (DEJA_DUP_INCLUDE_LIST_KEY, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp10_);
	g_object_set ((GObject*) w, "width-request", 250, NULL);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	_tmp11_ = _ ("Except for:");
	_tmp12_ = (GtkLabel*) gtk_label_new (_tmp11_);
	_g_object_unref0 (label);
	label = (GtkWidget*) g_object_ref_sink (_tmp12_);
	g_object_set ((GObject*) label, "xalign", 0.0f, "yalign", 0.0f, NULL);
	_tmp13_ = deja_dup_config_label_list_new (DEJA_DUP_EXCLUDE_LIST_KEY, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp13_);
	g_object_set ((GObject*) w, "width-request", 250, NULL);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	result = (GtkWidget*) page;
	_g_object_unref0 (w);
	_g_object_unref0 (label);
	return result;
}


static void _lambda20_ (DejaDupOperation* op, AssistantBackup* self) {
	g_return_if_fail (op != NULL);
	deja_dup_operation_set_use_progress (op, TRUE);
}


static void __lambda20__deja_dup_operation_is_full (DejaDupOperation* _sender, gpointer self) {
	_lambda20_ (_sender, self);
}


static DejaDupOperation* assistant_backup_real_create_op (AssistantOperation* base) {
	AssistantBackup * self;
	DejaDupOperation* result = NULL;
	GdkWindow* _tmp0_ = NULL;
	glong _tmp1_;
	glong xid;
	DejaDupOperationBackup* _tmp2_ = NULL;
	DejaDupOperationBackup* rv;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp7_;
	self = (AssistantBackup*) base;
	gtk_widget_realize ((GtkWidget*) self);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = hacks_window_get_xid (_tmp0_);
	xid = _tmp1_;
	_tmp2_ = deja_dup_operation_backup_new ((guint) xid);
	rv = _tmp2_;
	assistant_operation_ensure_status_icon ((AssistantOperation*) self, (DejaDupOperation*) rv);
	_tmp4_ = assistant_operation_get_automatic ((AssistantOperation*) self);
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		if (((AssistantOperation*) self)->status_icon == NULL) {
			_tmp5_ = TRUE;
		} else {
			gboolean _tmp6_;
			_tmp6_ = status_icon_get_show_automatic_progress (((AssistantOperation*) self)->status_icon);
			_tmp5_ = !_tmp6_;
		}
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		deja_dup_operation_set_use_progress ((DejaDupOperation*) rv, FALSE);
		g_signal_connect_object ((DejaDupOperation*) rv, "is-full", (GCallback) __lambda20__deja_dup_operation_is_full, self, 0);
	}
	_tmp7_ = assistant_operation_get_automatic ((AssistantOperation*) self);
	if (_tmp7_) {
		assistant_hide_for_now ((Assistant*) self);
	}
	result = (DejaDupOperation*) rv;
	return result;
}


static void assistant_backup_do_resume (AssistantBackup* self) {
	g_return_if_fail (self != NULL);
	assistant_operation_hide_everything ((AssistantOperation*) self);
	if (((AssistantOperation*) self)->op != NULL) {
		deja_dup_operation_stop (((AssistantOperation*) self)->op);
	} else {
		((AssistantOperation*) self)->succeeded = TRUE;
		assistant_operation_do_close ((AssistantOperation*) self);
	}
}


static gchar* assistant_backup_real_get_progress_file_prefix (AssistantOperation* base) {
	AssistantBackup * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	self = (AssistantBackup*) base;
	_tmp0_ = _ ("Backing up:");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void assistant_backup_real_set_op_icon_name (AssistantOperation* base) {
	AssistantBackup * self;
	self = (AssistantBackup*) base;
	gtk_window_set_icon_name ((GtkWindow*) self, "deja-dup-backup");
}


static void assistant_backup_add_periodic_widgets (AssistantBackup* self, GtkVBox* page) {
	const gchar* _tmp0_ = NULL;
	DejaDupConfigBool* _tmp1_ = NULL;
	DejaDupConfigBool* check;
	DejaDupConfigPeriod* _tmp2_ = NULL;
	DejaDupConfigPeriod* combo;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* _tmp7_;
	GtkLabel* label;
	GtkHBox* _tmp8_ = NULL;
	GtkHBox* hbox;
	DejaDupToggleGroup* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = _ ("_Automatically back up on a regular schedule");
	_tmp1_ = deja_dup_config_bool_new (DEJA_DUP_PERIODIC_KEY, _tmp0_, "");
	check = g_object_ref_sink (_tmp1_);
	_tmp2_ = deja_dup_config_period_new (DEJA_DUP_PERIODIC_PERIOD_KEY, "");
	combo = g_object_ref_sink (_tmp2_);
	_tmp3_ = _ ("How _often to back up:");
	_tmp4_ = g_strdup_printf ("    %s", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	_tmp7_ = g_object_ref_sink (_tmp6_);
	_g_free0 (_tmp5_);
	label = _tmp7_;
	g_object_set ((GObject*) label, "mnemonic-widget", combo, "use-underline", TRUE, "xalign", 0.0f, NULL);
	_tmp8_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	hbox = g_object_ref_sink (_tmp8_);
	g_object_set ((GObject*) hbox, "child", label, "child", combo, NULL);
	gtk_box_pack_end ((GtkBox*) page, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	gtk_box_pack_end ((GtkBox*) page, (GtkWidget*) check, FALSE, FALSE, (guint) 0);
	_tmp9_ = deja_dup_toggle_group_new ((DejaDupTogglable*) check);
	_g_object_unref0 (self->priv->periodic_toggle);
	self->priv->periodic_toggle = _tmp9_;
	deja_dup_toggle_group_add_dependent (self->priv->periodic_toggle, (GtkWidget*) label);
	deja_dup_toggle_group_add_dependent (self->priv->periodic_toggle, (GtkWidget*) combo);
	deja_dup_toggle_group_check (self->priv->periodic_toggle);
	gtk_widget_show_all ((GtkWidget*) check);
	gtk_widget_show_all ((GtkWidget*) hbox);
	_g_object_unref0 (hbox);
	_g_object_unref0 (label);
	_g_object_unref0 (combo);
	_g_object_unref0 (check);
}


static gboolean _lambda21_ (AssistantBackup* self) {
	gboolean result = FALSE;
	assistant_operation_do_close ((AssistantOperation*) self);
	result = FALSE;
	return result;
}


static gboolean __lambda21__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda21_ (self);
	return result;
}


static gboolean _lambda22_ (AssistantBackup* self) {
	gboolean result = FALSE;
	assistant_operation_force_visible ((AssistantOperation*) self, FALSE);
	result = FALSE;
	return result;
}


static gboolean __lambda22__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda22_ (self);
	return result;
}


static void assistant_backup_real_do_prepare (AssistantOperation* base, Assistant* assist, GtkWidget* page) {
	AssistantBackup * self;
	GtkWidget* _tmp0_ = NULL;
	self = (AssistantBackup*) base;
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	ASSISTANT_OPERATION_CLASS (assistant_backup_parent_class)->do_prepare (ASSISTANT_OPERATION (self), assist, page);
	_tmp0_ = assistant_operation_get_summary_page ((AssistantOperation*) self);
	if (page == _tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = assistant_operation_get_error_occurred ((AssistantOperation*) self);
		if (_tmp1_) {
			const gchar* _tmp2_ = NULL;
			_tmp2_ = _ ("Backup Failed");
			assistant_set_page_title ((Assistant*) self, page, _tmp2_);
		} else {
			const gchar* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			DejaDupSimpleSettings* _tmp5_ = NULL;
			DejaDupSimpleSettings* settings;
			gboolean val;
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp3_ = _ ("Backup Finished");
			assistant_set_page_title ((Assistant*) self, page, _tmp3_);
			_tmp4_ = _ ("Your files were successfully backed up.");
			gtk_label_set_label (((AssistantOperation*) self)->summary_label, _tmp4_);
			_tmp5_ = deja_dup_get_settings (NULL);
			settings = _tmp5_;
			val = FALSE;
			_tmp6_ = g_settings_get_boolean ((GSettings*) settings, DEJA_DUP_PERIODIC_KEY);
			val = _tmp6_;
			if (!val) {
				assistant_backup_add_periodic_widgets (self, GTK_VBOX (page));
			}
			_tmp7_ = assistant_operation_get_automatic ((AssistantOperation*) self);
			if (_tmp7_) {
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda21__gsource_func, g_object_ref (self), g_object_unref);
			} else {
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda22__gsource_func, g_object_ref (self), g_object_unref);
			}
			_g_object_unref0 (settings);
		}
	} else {
		GtkWidget* _tmp8_ = NULL;
		_tmp8_ = assistant_operation_get_progress_page ((AssistantOperation*) self);
		if (page == _tmp8_) {
			const gchar* _tmp9_ = NULL;
			_tmp9_ = _ ("Backing Up…");
			assistant_set_page_title ((Assistant*) self, page, _tmp9_);
		}
	}
}


static void _assistant_backup_do_resume_assistant_resumed (Assistant* _sender, gpointer self) {
	assistant_backup_do_resume (self);
}


static GObject * assistant_backup_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AssistantBackup * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	DejaDupDuplicityInfo* _tmp2_ = NULL;
	DejaDupDuplicityInfo* _tmp3_;
	gboolean _tmp4_;
	parent_class = G_OBJECT_CLASS (assistant_backup_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ASSISTANT_BACKUP (obj);
	_tmp0_ = C_ ("back up is verb", "Back Up");
	gtk_window_set_title ((GtkWindow*) self, _tmp0_);
	_tmp1_ = C_ ("back up is verb", "_Back Up");
	assistant_set_apply_text ((Assistant*) self, _tmp1_);
	_tmp2_ = deja_dup_duplicity_info_get_default ();
	_tmp3_ = _tmp2_;
	_tmp4_ = deja_dup_duplicity_info_get_can_resume (_tmp3_);
	assistant_set_resume_supported ((Assistant*) self, _tmp4_);
	_g_object_unref0 (_tmp3_);
	g_signal_connect_object ((Assistant*) self, "resumed", (GCallback) _assistant_backup_do_resume_assistant_resumed, self, 0);
	return obj;
}


static void assistant_backup_class_init (AssistantBackupClass * klass) {
	assistant_backup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AssistantBackupPrivate));
	ASSISTANT_OPERATION_CLASS (klass)->add_custom_config_pages = assistant_backup_real_add_custom_config_pages;
	ASSISTANT_OPERATION_CLASS (klass)->make_confirm_page = assistant_backup_real_make_confirm_page;
	ASSISTANT_OPERATION_CLASS (klass)->create_op = assistant_backup_real_create_op;
	ASSISTANT_OPERATION_CLASS (klass)->get_progress_file_prefix = assistant_backup_real_get_progress_file_prefix;
	ASSISTANT_OPERATION_CLASS (klass)->set_op_icon_name = assistant_backup_real_set_op_icon_name;
	ASSISTANT_OPERATION_CLASS (klass)->do_prepare = assistant_backup_real_do_prepare;
	G_OBJECT_CLASS (klass)->constructor = assistant_backup_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_backup_finalize;
}


static void assistant_backup_instance_init (AssistantBackup * self) {
	self->priv = ASSISTANT_BACKUP_GET_PRIVATE (self);
}


static void assistant_backup_finalize (GObject* obj) {
	AssistantBackup * self;
	self = ASSISTANT_BACKUP (obj);
	_g_object_unref0 (self->priv->periodic_toggle);
	G_OBJECT_CLASS (assistant_backup_parent_class)->finalize (obj);
}


GType assistant_backup_get_type (void) {
	static volatile gsize assistant_backup_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_backup_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantBackupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_backup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantBackup), 0, (GInstanceInitFunc) assistant_backup_instance_init, NULL };
		GType assistant_backup_type_id;
		assistant_backup_type_id = g_type_register_static (TYPE_ASSISTANT_OPERATION, "AssistantBackup", &g_define_type_info, 0);
		g_once_init_leave (&assistant_backup_type_id__volatile, assistant_backup_type_id);
	}
	return assistant_backup_type_id__volatile;
}



