/* -*- Mode: C; indent-tabs-mode: nil; tab-width: 2 -*- */

#ifndef __ASSISTANTRESTORE_H__
#define __ASSISTANTRESTORE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <Operation.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <OperationStatus.h>
#include "AssistantOperation.h"

G_BEGIN_DECLS


#define TYPE_ASSISTANT_RESTORE (assistant_restore_get_type ())
#define ASSISTANT_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_RESTORE, AssistantRestore))
#define ASSISTANT_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_RESTORE, AssistantRestoreClass))
#define IS_ASSISTANT_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_RESTORE))
#define IS_ASSISTANT_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_RESTORE))
#define ASSISTANT_RESTORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_RESTORE, AssistantRestoreClass))

typedef struct _AssistantRestore AssistantRestore;
typedef struct _AssistantRestoreClass AssistantRestoreClass;
typedef struct _AssistantRestorePrivate AssistantRestorePrivate;

/*
    Déjà Dup
    © 2008—2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
struct _AssistantRestore {
	AssistantOperation parent_instance;
	AssistantRestorePrivate * priv;
};

struct _AssistantRestoreClass {
	AssistantOperationClass parent_class;
};


AssistantRestore* assistant_restore_construct_with_files (GType object_type, GList* files);
AssistantRestore* assistant_restore_new_with_files (GList* files);
void assistant_restore_handle_collection_dates (AssistantRestore* self, DejaDupOperationStatus* op, GList* dates);
void assistant_restore_query_finished (AssistantRestore* self, DejaDupOperationStatus* op, gboolean success);
void assistant_restore_do_query (AssistantRestore* self);
gint assistant_restore_do_forward (AssistantRestore* self, gint n);
AssistantRestore* assistant_restore_construct (GType object_type);
AssistantRestore* assistant_restore_new (void);
const char* assistant_restore_get_restore_location (AssistantRestore* self);
void assistant_restore_set_restore_location (AssistantRestore* self, const char* value);
GList* assistant_restore_get_restore_files (AssistantRestore* self);
void assistant_restore_set_restore_files (AssistantRestore* self, GList* value);
GType assistant_restore_get_type (void);


G_END_DECLS

#endif
