/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include "MainWindow.h"
#include <config.h>
#include <DuplicityInfo.h>
#include <libdeja-dup.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include "AssistantBackup.h"
#include "AssistantRestore.h"




struct _MainWindowPrivate {
	GtkAction* backup_action;
	GtkAction* restore_action;
};

#define MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW, MainWindowPrivate))
enum  {
	MAIN_WINDOW_DUMMY_PROPERTY
};
static gboolean main_window_check_duplicity_version (MainWindow* self);
static void main_window_on_backup (MainWindow* self, GtkAction* action);
static void main_window_ask_backup (MainWindow* self);
static void main_window_on_restore (MainWindow* self, GtkAction* action);
static void main_window_ask_restore (MainWindow* self);
static void main_window_on_about (MainWindow* self, GtkAction* action);
static void main_window_on_contents (MainWindow* self, GtkAction* action);
static void main_window_on_get_help (MainWindow* self, GtkAction* action);
static void main_window_on_translate (MainWindow* self, GtkAction* action);
static void main_window_on_report (MainWindow* self, GtkAction* action);
static void main_window_on_preferences (MainWindow* self, GtkAction* action);
static void _main_window_on_backup_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _main_window_on_restore_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _gtk_main_quit_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _main_window_on_preferences_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _main_window_on_contents_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _main_window_on_get_help_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _main_window_on_translate_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _main_window_on_report_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _main_window_on_about_gtk_action_activate (GtkAction* _sender, gpointer self);
static GtkWidget* main_window_setup_menu (MainWindow* self);
static void __lambda0 (GtkButton* b, MainWindow* self);
static void ___lambda0_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda1 (GtkButton* b, MainWindow* self);
static void ___lambda1_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean _main_window_check_duplicity_version_gsource_func (gpointer self);
static void _gtk_main_quit_gtk_object_destroy (MainWindow* _sender, gpointer self);
static GObject * main_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer main_window_parent_class = NULL;
static void main_window_finalize (GObject* obj);



/*
    Déjà Dup
    © 2008—2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
char* get_restore_icon_filename (void) {
	return g_build_filename (PKG_DATA_DIR, "document-save.svg", NULL);
}


char* get_backup_icon_filename (void) {
	return g_build_filename (PKG_DATA_DIR, "document-send.svg", NULL);
}


static gboolean main_window_check_duplicity_version (MainWindow* self) {
	DejaDupDuplicityInfo* _tmp0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0 = NULL;
	deja_dup_duplicity_info_check_duplicity_version (_tmp0 = deja_dup_duplicity_info_get_default (), (GtkWindow*) self);
	(_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL));
	return FALSE;
}


static void main_window_on_backup (MainWindow* self, GtkAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	main_window_ask_backup (self);
}


static void main_window_ask_backup (MainWindow* self) {
	AssistantBackup* dlg;
	g_return_if_fail (self != NULL);
	dlg = g_object_ref_sink (assistant_backup_new ());
	gtk_window_set_modal ((GtkWindow*) dlg, TRUE);
	gtk_window_set_transient_for ((GtkWindow*) dlg, (GtkWindow*) self);
	gtk_widget_show_all ((GtkWidget*) dlg);
	(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
}


static void main_window_on_restore (MainWindow* self, GtkAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	main_window_ask_restore (self);
}


static void main_window_ask_restore (MainWindow* self) {
	AssistantRestore* dlg;
	g_return_if_fail (self != NULL);
	dlg = g_object_ref_sink (assistant_restore_new ());
	gtk_window_set_modal ((GtkWindow*) dlg, TRUE);
	gtk_window_set_transient_for ((GtkWindow*) dlg, (GtkWindow*) self);
	gtk_widget_show_all ((GtkWidget*) dlg);
	(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
}


static void main_window_on_about (MainWindow* self, GtkAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	deja_dup_show_about ((GObject*) self, (GtkWindow*) self);
}


static void main_window_on_contents (MainWindow* self, GtkAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	deja_dup_show_uri ((GtkWindow*) self, "ghelp:deja-dup");
}


static void main_window_on_get_help (MainWindow* self, GtkAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	deja_dup_show_uri ((GtkWindow*) self, "https://answers.launchpad.net/deja-dup");
}


static void main_window_on_translate (MainWindow* self, GtkAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	deja_dup_show_uri ((GtkWindow*) self, "https://translations.launchpad.net/deja-dup");
}


static void main_window_on_report (MainWindow* self, GtkAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	deja_dup_show_uri ((GtkWindow*) self, "https://bugs.launchpad.net/deja-dup/+filebug");
}


static void main_window_on_preferences (MainWindow* self, GtkAction* action) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	inner_error = NULL;
	{
		g_spawn_command_line_async ("deja-dup-preferences", &inner_error);
		if (inner_error != NULL) {
			goto __catch7_g_error;
			goto __finally7;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			GtkMessageDialog* dlg;
			dlg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Could not open preferences"), NULL));
			gtk_message_dialog_format_secondary_text (dlg, "%s", e->message, NULL);
			gtk_dialog_run ((GtkDialog*) dlg);
			gtk_object_destroy ((GtkObject*) dlg);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
		}
	}
	__finally7:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


static void _main_window_on_backup_gtk_action_activate (GtkAction* _sender, gpointer self) {
	main_window_on_backup (self, _sender);
}


static void _main_window_on_restore_gtk_action_activate (GtkAction* _sender, gpointer self) {
	main_window_on_restore (self, _sender);
}


static void _gtk_main_quit_gtk_action_activate (GtkAction* _sender, gpointer self) {
	gtk_main_quit ();
}


static void _main_window_on_preferences_gtk_action_activate (GtkAction* _sender, gpointer self) {
	main_window_on_preferences (self, _sender);
}


static void _main_window_on_contents_gtk_action_activate (GtkAction* _sender, gpointer self) {
	main_window_on_contents (self, _sender);
}


static void _main_window_on_get_help_gtk_action_activate (GtkAction* _sender, gpointer self) {
	main_window_on_get_help (self, _sender);
}


static void _main_window_on_translate_gtk_action_activate (GtkAction* _sender, gpointer self) {
	main_window_on_translate (self, _sender);
}


static void _main_window_on_report_gtk_action_activate (GtkAction* _sender, gpointer self) {
	main_window_on_report (self, _sender);
}


static void _main_window_on_about_gtk_action_activate (GtkAction* _sender, gpointer self) {
	main_window_on_about (self, _sender);
}


static GtkWidget* main_window_setup_menu (MainWindow* self) {
	GError * inner_error;
	GtkActionGroup* action_group;
	GtkAction* action;
	GtkAction* _tmp0;
	GtkAction* _tmp2;
	GtkAction* _tmp1;
	GtkAction* _tmp3;
	GtkAction* _tmp5;
	GtkAction* _tmp4;
	GtkAction* _tmp6;
	GtkAction* _tmp7;
	GtkAction* _tmp8;
	GtkAction* _tmp9;
	GtkAction* _tmp10;
	GtkAction* _tmp11;
	GtkAction* _tmp12;
	GtkAction* _tmp13;
	GtkAction* _tmp14;
	char* ui;
	GtkUIManager* manager;
	GtkWidget* _tmp15;
	GtkWidget* _tmp16;
	g_return_val_if_fail (self != NULL, NULL);
	inner_error = NULL;
	action_group = gtk_action_group_new ("actions");
	action = gtk_action_new ("FileMenuAction", _ ("_File"), NULL, NULL);
	gtk_action_group_add_action (action_group, action);
	_tmp0 = NULL;
	action = (_tmp0 = gtk_action_new ("BackupAction", _ ("_Backup"), NULL, NULL), (action == NULL) ? NULL : (action = (g_object_unref (action), NULL)), _tmp0);
	/*action.set("icon-name", "document-send");*/
	g_signal_connect_object (action, "activate", (GCallback) _main_window_on_backup_gtk_action_activate, self, 0);
	gtk_action_group_add_action_with_accel (action_group, action, "<control>B");
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->backup_action = (_tmp2 = (_tmp1 = action, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->backup_action == NULL) ? NULL : (self->priv->backup_action = (g_object_unref (self->priv->backup_action), NULL)), _tmp2);
	_tmp3 = NULL;
	action = (_tmp3 = gtk_action_new ("RestoreAction", _ ("_Restore"), NULL, NULL), (action == NULL) ? NULL : (action = (g_object_unref (action), NULL)), _tmp3);
	/*action.set("icon-name", "document-save");*/
	g_signal_connect_object (action, "activate", (GCallback) _main_window_on_restore_gtk_action_activate, self, 0);
	gtk_action_group_add_action_with_accel (action_group, action, "<control>R");
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->priv->restore_action = (_tmp5 = (_tmp4 = action, (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4)), (self->priv->restore_action == NULL) ? NULL : (self->priv->restore_action = (g_object_unref (self->priv->restore_action), NULL)), _tmp5);
	_tmp6 = NULL;
	action = (_tmp6 = gtk_action_new ("QuitAction", NULL, NULL, GTK_STOCK_QUIT), (action == NULL) ? NULL : (action = (g_object_unref (action), NULL)), _tmp6);
	g_signal_connect (action, "activate", (GCallback) _gtk_main_quit_gtk_action_activate, NULL);
	gtk_action_group_add_action_with_accel (action_group, action, "<control>Q");
	_tmp7 = NULL;
	action = (_tmp7 = gtk_action_new ("EditMenuAction", _ ("_Edit"), NULL, NULL), (action == NULL) ? NULL : (action = (g_object_unref (action), NULL)), _tmp7);
	gtk_action_group_add_action (action_group, action);
	_tmp8 = NULL;
	action = (_tmp8 = gtk_action_new ("PreferencesAction", NULL, NULL, GTK_STOCK_PREFERENCES), (action == NULL) ? NULL : (action = (g_object_unref (action), NULL)), _tmp8);
	g_signal_connect_object (action, "activate", (GCallback) _main_window_on_preferences_gtk_action_activate, self, 0);
	gtk_action_group_add_action (action_group, action);
	_tmp9 = NULL;
	action = (_tmp9 = gtk_action_new ("HelpMenuAction", _ ("_Help"), NULL, NULL), (action == NULL) ? NULL : (action = (g_object_unref (action), NULL)), _tmp9);
	gtk_action_group_add_action (action_group, action);
	_tmp10 = NULL;
	action = (_tmp10 = gtk_action_new ("ContentsAction", _ ("Contents"), NULL, GTK_STOCK_HELP), (action == NULL) ? NULL : (action = (g_object_unref (action), NULL)), _tmp10);
	g_signal_connect_object (action, "activate", (GCallback) _main_window_on_contents_gtk_action_activate, self, 0);
	gtk_action_group_add_action_with_accel (action_group, action, "F1");
	_tmp11 = NULL;
	action = (_tmp11 = gtk_action_new ("GetHelpAction", _ ("Get Help _Online..."), NULL, NULL), (action == NULL) ? NULL : (action = (g_object_unref (action), NULL)), _tmp11);
	g_signal_connect_object (action, "activate", (GCallback) _main_window_on_get_help_gtk_action_activate, self, 0);
	gtk_action_group_add_action (action_group, action);
	_tmp12 = NULL;
	action = (_tmp12 = gtk_action_new ("TranslateAction", _ ("_Translate This Application..."), NULL, NULL), (action == NULL) ? NULL : (action = (g_object_unref (action), NULL)), _tmp12);
	g_signal_connect_object (action, "activate", (GCallback) _main_window_on_translate_gtk_action_activate, self, 0);
	gtk_action_group_add_action (action_group, action);
	_tmp13 = NULL;
	action = (_tmp13 = gtk_action_new ("ReportAction", _ ("_Report a Problem..."), NULL, NULL), (action == NULL) ? NULL : (action = (g_object_unref (action), NULL)), _tmp13);
	g_signal_connect_object (action, "activate", (GCallback) _main_window_on_report_gtk_action_activate, self, 0);
	gtk_action_group_add_action (action_group, action);
	_tmp14 = NULL;
	action = (_tmp14 = gtk_action_new ("AboutAction", NULL, NULL, GTK_STOCK_ABOUT), (action == NULL) ? NULL : (action = (g_object_unref (action), NULL)), _tmp14);
	g_signal_connect_object (action, "activate", (GCallback) _main_window_on_about_gtk_action_activate, self, 0);
	gtk_action_group_add_action (action_group, action);
	ui = g_strdup ("\n<ui>\n  <menubar>\n    <menu name=\"FileMenu\" action=\"FileMenuAction\">\n      <menuitem name=\"Backup\" action=\"BackupAction\" />\n      <menuitem name=\"Restore\" action=\"RestoreAction\" />\n      <separator />\n      <menuitem name=\"Quit\" action=\"QuitAction\" />\n    </menu>\n    <menu name=\"EditMenu\" action=\"EditMenuAction\">\n      <menuitem name=\"Preferences\" action=\"PreferencesAction\"/>\n    </menu>\n    <menu name=\"HelpMenu\" action=\"HelpMenuAction\">\n      <menuitem name=\"Contents\" action=\"ContentsAction\"/>\n      <separator/>\n      <menuitem name=\"GetHelp\" action=\"GetHelpAction\"/>\n      <menuitem name=\"Translate\" action=\"TranslateAction\"/>\n      <menuitem name=\"Report\" action=\"ReportAction\"/>\n      <separator/>\n      <menuitem name=\"About\" action=\"AboutAction\"/>\n    </menu>\n  </menubar>\n</ui>");
	manager = gtk_ui_manager_new ();
	{
		gtk_ui_manager_add_ui_from_string (manager, ui, (gssize) strlen (ui), &inner_error);
		if (inner_error != NULL) {
			goto __catch8_g_error;
			goto __finally8;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_error ("MainWindow.vala:261: Internal error: bad ui string.\n");
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally8:
	if (inner_error != NULL) {
		(action_group == NULL) ? NULL : (action_group = (g_object_unref (action_group), NULL));
		(action == NULL) ? NULL : (action = (g_object_unref (action), NULL));
		ui = (g_free (ui), NULL);
		(manager == NULL) ? NULL : (manager = (g_object_unref (manager), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return NULL;
	}
	gtk_ui_manager_insert_action_group (manager, action_group, 0);
	gtk_window_add_accel_group ((GtkWindow*) self, gtk_ui_manager_get_accel_group (manager));
	_tmp15 = NULL;
	_tmp16 = NULL;
	return (_tmp16 = (_tmp15 = gtk_ui_manager_get_widget (manager, "/ui/menubar"), (_tmp15 == NULL) ? NULL : g_object_ref (_tmp15)), (action_group == NULL) ? NULL : (action_group = (g_object_unref (action_group), NULL)), (action == NULL) ? NULL : (action = (g_object_unref (action), NULL)), ui = (g_free (ui), NULL), (manager == NULL) ? NULL : (manager = (g_object_unref (manager), NULL)), _tmp16);
}


MainWindow* main_window_construct (GType object_type) {
	MainWindow * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


MainWindow* main_window_new (void) {
	return main_window_construct (TYPE_MAIN_WINDOW);
}


static void __lambda0 (GtkButton* b, MainWindow* self) {
	g_return_if_fail (b != NULL);
	main_window_ask_restore (self);
}


static void ___lambda0_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda0 (_sender, self);
}


static void __lambda1 (GtkButton* b, MainWindow* self) {
	g_return_if_fail (b != NULL);
	main_window_ask_backup (self);
}


static void ___lambda1_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda1 (_sender, self);
}


static gboolean _main_window_check_duplicity_version_gsource_func (gpointer self) {
	return main_window_check_duplicity_version (self);
}


static void _gtk_main_quit_gtk_object_destroy (MainWindow* _sender, gpointer self) {
	gtk_main_quit ();
}


static GObject * main_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	MainWindowClass * klass;
	GObjectClass * parent_class;
	MainWindow * self;
	GError * inner_error;
	klass = MAIN_WINDOW_CLASS (g_type_class_peek (TYPE_MAIN_WINDOW));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MAIN_WINDOW (obj);
	inner_error = NULL;
	{
		GtkVBox* vb;
		GtkAlignment* restore_align;
		GtkButton* restore_button;
		GtkImage* restore_icon;
		GtkLabel* restore_label;
		GtkVBox* restore_vbox;
		GtkAlignment* backup_align;
		GtkButton* backup_button;
		GtkImage* backup_icon;
		GtkLabel* backup_label;
		GtkVBox* backup_vbox;
		GtkHBox* hbox;
		GtkWidget* _tmp0;
		vb = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
		restore_align = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 0.0f, 0.0f));
		restore_button = g_object_ref_sink ((GtkButton*) gtk_button_new ());
		g_object_set ((GObject*) restore_button, "child", restore_align, NULL);
		restore_icon = g_object_ref_sink ((GtkImage*) gtk_image_new ());
		{
			char* filename;
			GdkPixbuf* restore_pix;
			filename = get_restore_icon_filename ();
			restore_pix = gdk_pixbuf_new_from_file_at_size (filename, 128, 128, &inner_error);
			if (inner_error != NULL) {
				filename = (g_free (filename), NULL);
				goto __catch9_g_error;
				goto __finally9;
			}
			g_object_set ((GObject*) restore_icon, "pixbuf", restore_pix, NULL);
			filename = (g_free (filename), NULL);
			(restore_pix == NULL) ? NULL : (restore_pix = (g_object_unref (restore_pix), NULL));
		}
		goto __finally9;
		__catch9_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_warning ("MainWindow.vala:48: %s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally9:
		if (inner_error != NULL) {
			(vb == NULL) ? NULL : (vb = (g_object_unref (vb), NULL));
			(restore_align == NULL) ? NULL : (restore_align = (g_object_unref (restore_align), NULL));
			(restore_button == NULL) ? NULL : (restore_button = (g_object_unref (restore_button), NULL));
			(restore_icon == NULL) ? NULL : (restore_icon = (g_object_unref (restore_icon), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
		restore_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("_Restore")));
		g_object_set ((GObject*) restore_label, "use-underline", TRUE, "mnemonic-widget", restore_button, NULL);
		restore_vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
		g_object_set ((GObject*) restore_vbox, "border-width", 12, "child", restore_icon, "child", restore_label, NULL);
		gtk_container_add ((GtkContainer*) restore_align, (GtkWidget*) restore_vbox);
		backup_align = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 0.0f, 0.0f));
		backup_button = g_object_ref_sink ((GtkButton*) gtk_button_new ());
		g_object_set ((GObject*) backup_button, "child", backup_align, NULL);
		backup_icon = g_object_ref_sink ((GtkImage*) gtk_image_new ());
		{
			char* filename;
			GdkPixbuf* backup_pix;
			filename = get_backup_icon_filename ();
			backup_pix = gdk_pixbuf_new_from_file_at_size (filename, 128, 128, &inner_error);
			if (inner_error != NULL) {
				filename = (g_free (filename), NULL);
				goto __catch10_g_error;
				goto __finally10;
			}
			g_object_set ((GObject*) backup_icon, "pixbuf", backup_pix, NULL);
			filename = (g_free (filename), NULL);
			(backup_pix == NULL) ? NULL : (backup_pix = (g_object_unref (backup_pix), NULL));
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_warning ("MainWindow.vala:74: %s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally10:
		if (inner_error != NULL) {
			(vb == NULL) ? NULL : (vb = (g_object_unref (vb), NULL));
			(restore_align == NULL) ? NULL : (restore_align = (g_object_unref (restore_align), NULL));
			(restore_button == NULL) ? NULL : (restore_button = (g_object_unref (restore_button), NULL));
			(restore_icon == NULL) ? NULL : (restore_icon = (g_object_unref (restore_icon), NULL));
			(restore_label == NULL) ? NULL : (restore_label = (g_object_unref (restore_label), NULL));
			(restore_vbox == NULL) ? NULL : (restore_vbox = (g_object_unref (restore_vbox), NULL));
			(backup_align == NULL) ? NULL : (backup_align = (g_object_unref (backup_align), NULL));
			(backup_button == NULL) ? NULL : (backup_button = (g_object_unref (backup_button), NULL));
			(backup_icon == NULL) ? NULL : (backup_icon = (g_object_unref (backup_icon), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
		backup_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("_Backup")));
		g_object_set ((GObject*) backup_label, "use-underline", TRUE, "mnemonic-widget", backup_button, NULL);
		backup_vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
		g_object_set ((GObject*) backup_vbox, "border-width", 12, "child", backup_icon, "child", backup_label, NULL);
		gtk_container_add ((GtkContainer*) backup_align, (GtkWidget*) backup_vbox);
		hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (TRUE, 12));
		g_object_set ((GObject*) hbox, "border-width", 12, "child", restore_button, "child", backup_button, NULL);
		g_signal_connect (restore_button, "clicked", (GCallback) ___lambda0_gtk_button_clicked, self);
		g_signal_connect (backup_button, "clicked", (GCallback) ___lambda1_gtk_button_clicked, self);
		_tmp0 = NULL;
		gtk_box_pack_start ((GtkBox*) vb, _tmp0 = main_window_setup_menu (self), FALSE, FALSE, (guint) 0);
		(_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL));
		gtk_box_pack_start ((GtkBox*) vb, (GtkWidget*) hbox, TRUE, TRUE, (guint) 0);
		gtk_widget_grab_focus ((GtkWidget*) backup_button);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) vb);
		g_idle_add (_main_window_check_duplicity_version_gsource_func, self);
		g_signal_connect ((GtkObject*) self, "destroy", (GCallback) _gtk_main_quit_gtk_object_destroy, NULL);
		(vb == NULL) ? NULL : (vb = (g_object_unref (vb), NULL));
		(restore_align == NULL) ? NULL : (restore_align = (g_object_unref (restore_align), NULL));
		(restore_button == NULL) ? NULL : (restore_button = (g_object_unref (restore_button), NULL));
		(restore_icon == NULL) ? NULL : (restore_icon = (g_object_unref (restore_icon), NULL));
		(restore_label == NULL) ? NULL : (restore_label = (g_object_unref (restore_label), NULL));
		(restore_vbox == NULL) ? NULL : (restore_vbox = (g_object_unref (restore_vbox), NULL));
		(backup_align == NULL) ? NULL : (backup_align = (g_object_unref (backup_align), NULL));
		(backup_button == NULL) ? NULL : (backup_button = (g_object_unref (backup_button), NULL));
		(backup_icon == NULL) ? NULL : (backup_icon = (g_object_unref (backup_icon), NULL));
		(backup_label == NULL) ? NULL : (backup_label = (g_object_unref (backup_label), NULL));
		(backup_vbox == NULL) ? NULL : (backup_vbox = (g_object_unref (backup_vbox), NULL));
		(hbox == NULL) ? NULL : (hbox = (g_object_unref (hbox), NULL));
	}
	return obj;
}


static void main_window_class_init (MainWindowClass * klass) {
	main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MainWindowPrivate));
	G_OBJECT_CLASS (klass)->constructor = main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = main_window_finalize;
}


static void main_window_instance_init (MainWindow * self) {
	self->priv = MAIN_WINDOW_GET_PRIVATE (self);
}


static void main_window_finalize (GObject* obj) {
	MainWindow * self;
	self = MAIN_WINDOW (obj);
	(self->priv->backup_action == NULL) ? NULL : (self->priv->backup_action = (g_object_unref (self->priv->backup_action), NULL));
	(self->priv->restore_action == NULL) ? NULL : (self->priv->restore_action = (g_object_unref (self->priv->restore_action), NULL));
	G_OBJECT_CLASS (main_window_parent_class)->finalize (obj);
}


GType main_window_get_type (void) {
	static GType main_window_type_id = 0;
	if (main_window_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindow), 0, (GInstanceInitFunc) main_window_instance_init, NULL };
		main_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "MainWindow", &g_define_type_info, 0);
	}
	return main_window_type_id;
}




