/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include <Backend.h>
#include <gconf/gconf-client.h>
#include <libdeja-dup.h>
#include <BackendS3.h>
#include <BackendFile.h>
#include <BackendSSH.h>




struct _DejaDupBackendPrivate {
	GtkWindow* _toplevel;
};

#define DEJA_DUP_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_BACKEND, DejaDupBackendPrivate))
enum  {
	DEJA_DUP_BACKEND_DUMMY_PROPERTY,
	DEJA_DUP_BACKEND_TOPLEVEL
};
static char* deja_dup_backend_real_get_location (DejaDupBackend* self, GError** error);
static char* deja_dup_backend_real_get_location_pretty (DejaDupBackend* self, GError** error);
static void _g_list_free_g_free (GList* self);
static void deja_dup_backend_real_get_envp (DejaDupBackend* self, GError** error);
static void deja_dup_backend_real_add_argv (DejaDupBackend* self, GList** argv);
static void deja_dup_backend_real_ask_password (DejaDupBackend* self);
static DejaDupBackend* deja_dup_backend_real_clone (DejaDupBackend* self);
static void deja_dup_backend_set_toplevel (DejaDupBackend* self, GtkWindow* value);
static gpointer deja_dup_backend_parent_class = NULL;
static void deja_dup_backend_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__BOOLEAN_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static char* deja_dup_backend_real_get_location (DejaDupBackend* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `deja_dup_backend_get_location'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


char* deja_dup_backend_get_location (DejaDupBackend* self, GError** error) {
	return DEJA_DUP_BACKEND_GET_CLASS (self)->get_location (self, error);
}


static char* deja_dup_backend_real_get_location_pretty (DejaDupBackend* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `deja_dup_backend_get_location_pretty'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


char* deja_dup_backend_get_location_pretty (DejaDupBackend* self, GError** error) {
	return DEJA_DUP_BACKEND_GET_CLASS (self)->get_location_pretty (self, error);
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


/* short description for user*/
static void deja_dup_backend_real_get_envp (DejaDupBackend* self, GError** error) {
	GList* _tmp0;
	g_return_if_fail (self != NULL);
	_tmp0 = NULL;
	g_signal_emit_by_name (self, "envp-ready", TRUE, _tmp0 = NULL);
	(_tmp0 == NULL) ? NULL : (_tmp0 = (_g_list_free_g_free (_tmp0), NULL));
}


void deja_dup_backend_get_envp (DejaDupBackend* self, GError** error) {
	DEJA_DUP_BACKEND_GET_CLASS (self)->get_envp (self, error);
}


static void deja_dup_backend_real_add_argv (DejaDupBackend* self, GList** argv) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (argv != NULL);
}


void deja_dup_backend_add_argv (DejaDupBackend* self, GList** argv) {
	DEJA_DUP_BACKEND_GET_CLASS (self)->add_argv (self, argv);
}


static void deja_dup_backend_real_ask_password (DejaDupBackend* self) {
	g_return_if_fail (self != NULL);
}


void deja_dup_backend_ask_password (DejaDupBackend* self) {
	DEJA_DUP_BACKEND_GET_CLASS (self)->ask_password (self);
}


static DejaDupBackend* deja_dup_backend_real_clone (DejaDupBackend* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `deja_dup_backend_clone'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


DejaDupBackend* deja_dup_backend_clone (DejaDupBackend* self) {
	return DEJA_DUP_BACKEND_GET_CLASS (self)->clone (self);
}


DejaDupBackend* deja_dup_backend_get_default (GtkWindow* win, GError** error) {
	GError * inner_error;
	GConfClient* _tmp0;
	GConfClient* client;
	const char* _tmp1;
	char* backend_name;
	inner_error = NULL;
	_tmp0 = NULL;
	client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	_tmp1 = NULL;
	backend_name = (_tmp1 = gconf_client_get_string (client, DEJA_DUP_BACKEND_KEY, &inner_error), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		return NULL;
	}
	if (_vala_strcmp0 (backend_name, "s3") == 0) {
		DejaDupBackend* _tmp2;
		_tmp2 = NULL;
		return (_tmp2 = (DejaDupBackend*) deja_dup_backend_s3_new (win), (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), backend_name = (g_free (backend_name), NULL), _tmp2);
	} else {
		if (_vala_strcmp0 (backend_name, "file") == 0) {
			DejaDupBackend* _tmp3;
			_tmp3 = NULL;
			return (_tmp3 = (DejaDupBackend*) deja_dup_backend_file_new (win), (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), backend_name = (g_free (backend_name), NULL), _tmp3);
		} else {
			if (_vala_strcmp0 (backend_name, "ssh") == 0) {
				DejaDupBackend* _tmp4;
				_tmp4 = NULL;
				return (_tmp4 = (DejaDupBackend*) deja_dup_backend_ssh_new (win), (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), backend_name = (g_free (backend_name), NULL), _tmp4);
			} else {
				DejaDupBackend* _tmp5;
				_tmp5 = NULL;
				return (_tmp5 = NULL, (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), backend_name = (g_free (backend_name), NULL), _tmp5);
			}
		}
	}
	(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
	backend_name = (g_free (backend_name), NULL);
}


GtkWindow* deja_dup_backend_get_toplevel (DejaDupBackend* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_toplevel;
}


static void deja_dup_backend_set_toplevel (DejaDupBackend* self, GtkWindow* value) {
	GtkWindow* _tmp2;
	GtkWindow* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_toplevel = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_toplevel == NULL) ? NULL : (self->priv->_toplevel = (g_object_unref (self->priv->_toplevel), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "toplevel");
}


static void deja_dup_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupBackend * self;
	gpointer boxed;
	self = DEJA_DUP_BACKEND (object);
	switch (property_id) {
		case DEJA_DUP_BACKEND_TOPLEVEL:
		g_value_set_object (value, deja_dup_backend_get_toplevel (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_backend_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupBackend * self;
	self = DEJA_DUP_BACKEND (object);
	switch (property_id) {
		case DEJA_DUP_BACKEND_TOPLEVEL:
		deja_dup_backend_set_toplevel (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_backend_class_init (DejaDupBackendClass * klass) {
	deja_dup_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupBackendPrivate));
	G_OBJECT_CLASS (klass)->get_property = deja_dup_backend_get_property;
	G_OBJECT_CLASS (klass)->set_property = deja_dup_backend_set_property;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_backend_finalize;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location = deja_dup_backend_real_get_location;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location_pretty = deja_dup_backend_real_get_location_pretty;
	DEJA_DUP_BACKEND_CLASS (klass)->get_envp = deja_dup_backend_real_get_envp;
	DEJA_DUP_BACKEND_CLASS (klass)->add_argv = deja_dup_backend_real_add_argv;
	DEJA_DUP_BACKEND_CLASS (klass)->ask_password = deja_dup_backend_real_ask_password;
	DEJA_DUP_BACKEND_CLASS (klass)->clone = deja_dup_backend_real_clone;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_BACKEND_TOPLEVEL, g_param_spec_object ("toplevel", "toplevel", "toplevel", GTK_TYPE_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("envp_ready", DEJA_DUP_TYPE_BACKEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_POINTER, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_POINTER);
	g_signal_new ("need_password", DEJA_DUP_TYPE_BACKEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void deja_dup_backend_instance_init (DejaDupBackend * self) {
	self->priv = DEJA_DUP_BACKEND_GET_PRIVATE (self);
}


static void deja_dup_backend_finalize (GObject* obj) {
	DejaDupBackend * self;
	self = DEJA_DUP_BACKEND (obj);
	(self->priv->_toplevel == NULL) ? NULL : (self->priv->_toplevel = (g_object_unref (self->priv->_toplevel), NULL));
	G_OBJECT_CLASS (deja_dup_backend_parent_class)->finalize (obj);
}


GType deja_dup_backend_get_type (void) {
	static GType deja_dup_backend_type_id = 0;
	if (deja_dup_backend_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackend), 0, (GInstanceInitFunc) deja_dup_backend_instance_init, NULL };
		deja_dup_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupBackend", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return deja_dup_backend_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__BOOLEAN_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_POINTER) (gpointer data1, gboolean arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}



