/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#ifndef __BACKEND_H__
#define __BACKEND_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS


#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
typedef struct _DejaDupBackendPrivate DejaDupBackendPrivate;

struct _DejaDupBackend {
	GObject parent_instance;
	DejaDupBackendPrivate * priv;
};

struct _DejaDupBackendClass {
	GObjectClass parent_class;
	char* (*get_location) (DejaDupBackend* self, GError** error);
	char* (*get_location_pretty) (DejaDupBackend* self, GError** error);
	void (*get_envp) (DejaDupBackend* self, GError** error);
	void (*add_argv) (DejaDupBackend* self, GList** argv);
	void (*ask_password) (DejaDupBackend* self);
	DejaDupBackend* (*clone) (DejaDupBackend* self);
};


char* deja_dup_backend_get_location (DejaDupBackend* self, GError** error);
char* deja_dup_backend_get_location_pretty (DejaDupBackend* self, GError** error);
void deja_dup_backend_get_envp (DejaDupBackend* self, GError** error);
void deja_dup_backend_add_argv (DejaDupBackend* self, GList** argv);
void deja_dup_backend_ask_password (DejaDupBackend* self);
DejaDupBackend* deja_dup_backend_clone (DejaDupBackend* self);
DejaDupBackend* deja_dup_backend_get_default (GtkWindow* win, GError** error);
GtkWindow* deja_dup_backend_get_toplevel (DejaDupBackend* self);
GType deja_dup_backend_get_type (void);


G_END_DECLS

#endif
