/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include <BackendFile.h>
#include <gconf/gconf-client.h>
#include <glib/gi18n-lib.h>




enum  {
	DEJA_DUP_BACKEND_FILE_DUMMY_PROPERTY
};
static DejaDupBackend* deja_dup_backend_file_real_clone (DejaDupBackend* base);
static char* deja_dup_backend_file_get_location_from_gconf (DejaDupBackendFile* self, GError** error);
static char* deja_dup_backend_file_real_get_location (DejaDupBackend* base, GError** error);
static char* deja_dup_backend_file_real_get_location_pretty (DejaDupBackend* base, GError** error);
static gpointer deja_dup_backend_file_parent_class = NULL;



DejaDupBackendFile* deja_dup_backend_file_construct (GType object_type, GtkWindow* win) {
	GParameter * __params;
	GParameter * __params_it;
	DejaDupBackendFile * self;
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "toplevel";
	g_value_init (&__params_it->value, GTK_TYPE_WINDOW);
	g_value_set_object (&__params_it->value, win);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DejaDupBackendFile* deja_dup_backend_file_new (GtkWindow* win) {
	return deja_dup_backend_file_construct (DEJA_DUP_TYPE_BACKEND_FILE, win);
}


static DejaDupBackend* deja_dup_backend_file_real_clone (DejaDupBackend* base) {
	DejaDupBackendFile * self;
	self = (DejaDupBackendFile*) base;
	return (DejaDupBackend*) deja_dup_backend_file_new (deja_dup_backend_get_toplevel ((DejaDupBackend*) self));
}


static char* deja_dup_backend_file_get_location_from_gconf (DejaDupBackendFile* self, GError** error) {
	GError * inner_error;
	GConfClient* _tmp0;
	GConfClient* client;
	const char* _tmp1;
	char* path;
	char* _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	_tmp1 = NULL;
	path = (_tmp1 = gconf_client_get_string (client, DEJA_DUP_FILE_PATH_KEY, &inner_error), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		return NULL;
	}
	_tmp2 = NULL;
	return (_tmp2 = path, (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), _tmp2);
}


static char* deja_dup_backend_file_real_get_location (DejaDupBackend* base, GError** error) {
	DejaDupBackendFile * self;
	GError * inner_error;
	char* path;
	char* _tmp3;
	self = (DejaDupBackendFile*) base;
	inner_error = NULL;
	path = deja_dup_backend_file_get_location_from_gconf (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	if (path == NULL) {
		GtkFileChooserDialog* dlg;
		char* _tmp2;
		const char* _tmp1;
		dlg = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Choose backup destination"), deja_dup_backend_get_toplevel ((DejaDupBackend*) self), GTK_FILE_CHOOSER_ACTION_CREATE_FOLDER, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL));
		if (gtk_dialog_run ((GtkDialog*) dlg) != GTK_RESPONSE_ACCEPT) {
			char* _tmp0;
			gtk_object_destroy ((GtkObject*) dlg);
			_tmp0 = NULL;
			return (_tmp0 = NULL, (dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL)), path = (g_free (path), NULL), _tmp0);
		}
		_tmp2 = NULL;
		_tmp1 = NULL;
		path = (_tmp2 = (_tmp1 = gtk_file_chooser_get_filename ((GtkFileChooser*) dlg), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), path = (g_free (path), NULL), _tmp2);
		gtk_object_destroy ((GtkObject*) dlg);
		(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
	}
	_tmp3 = NULL;
	return (_tmp3 = g_strdup_printf ("file://%s", path), path = (g_free (path), NULL), _tmp3);
}


static char* deja_dup_backend_file_real_get_location_pretty (DejaDupBackend* base, GError** error) {
	DejaDupBackendFile * self;
	GError * inner_error;
	char* _tmp0;
	self = (DejaDupBackendFile*) base;
	inner_error = NULL;
	_tmp0 = deja_dup_backend_file_get_location_from_gconf (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	return _tmp0;
}


static void deja_dup_backend_file_class_init (DejaDupBackendFileClass * klass) {
	deja_dup_backend_file_parent_class = g_type_class_peek_parent (klass);
	DEJA_DUP_BACKEND_CLASS (klass)->clone = deja_dup_backend_file_real_clone;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location = deja_dup_backend_file_real_get_location;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location_pretty = deja_dup_backend_file_real_get_location_pretty;
}


static void deja_dup_backend_file_instance_init (DejaDupBackendFile * self) {
}


GType deja_dup_backend_file_get_type (void) {
	static GType deja_dup_backend_file_type_id = 0;
	if (deja_dup_backend_file_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendFile), 0, (GInstanceInitFunc) deja_dup_backend_file_instance_init, NULL };
		deja_dup_backend_file_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendFile", &g_define_type_info, 0);
	}
	return deja_dup_backend_file_type_id;
}




