/* -*- Mode: C; indent-tabs-mode: nil; tab-width: 2 -*- */

#include <BackendSSH.h>
#include <gconf/gconf-client.h>
#include <glib/gi18n-lib.h>
#include <gnome-keyring.h>
#include <libgnomeui/libgnomeui.h>
#include <OperationBackup.h>




struct _DejaDupBackendSSHPrivate {
	char* gconf_id;
	char* id;
	char* server;
	gint port;
	char* secret_key;
};

#define DEJA_DUP_BACKEND_SSH_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_BACKEND_SSH, DejaDupBackendSSHPrivate))
enum  {
	DEJA_DUP_BACKEND_SSH_DUMMY_PROPERTY
};
static DejaDupBackend* deja_dup_backend_ssh_real_clone (DejaDupBackend* base);
static void deja_dup_backend_ssh_real_add_argv (DejaDupBackend* base, GList** argv);
static gint deja_dup_backend_ssh_get_port (DejaDupBackendSSH* self, GError** error);
static char* deja_dup_backend_ssh_get_username (DejaDupBackendSSH* self, GError** error);
static char* deja_dup_backend_ssh_get_server (DejaDupBackendSSH* self, GError** error);
static char* deja_dup_backend_ssh_get_directory (DejaDupBackendSSH* self, GError** error);
static char* deja_dup_backend_ssh_real_get_location (DejaDupBackend* base, GError** error);
static char* deja_dup_backend_ssh_real_get_location_pretty (DejaDupBackend* base, GError** error);
static void _deja_dup_backend_ssh_found_password_gnome_keyring_operation_get_list_callback (GnomeKeyringResult result, GList* list, gpointer self);
static void deja_dup_backend_ssh_real_get_envp (DejaDupBackend* base, GError** error);
static void deja_dup_backend_ssh_found_password (DejaDupBackendSSH* self, GnomeKeyringResult result, GList* list);
static void deja_dup_backend_ssh_save_password_callback (DejaDupBackendSSH* self, GnomeKeyringResult result, guint32 val);
static void _g_list_free_g_free (GList* self);
static void _deja_dup_backend_ssh_save_password_callback_gnome_keyring_operation_get_int_callback (GnomeKeyringResult result, guint32 val, gpointer self);
static void deja_dup_backend_ssh_real_ask_password (DejaDupBackend* base);
static void deja_dup_backend_ssh_got_secret_key (DejaDupBackendSSH* self);
static gpointer deja_dup_backend_ssh_parent_class = NULL;
static void deja_dup_backend_ssh_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



DejaDupBackendSSH* deja_dup_backend_ssh_construct (GType object_type, GtkWindow* win) {
	GParameter * __params;
	GParameter * __params_it;
	DejaDupBackendSSH * self;
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "toplevel";
	g_value_init (&__params_it->value, GTK_TYPE_WINDOW);
	g_value_set_object (&__params_it->value, win);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DejaDupBackendSSH* deja_dup_backend_ssh_new (GtkWindow* win) {
	return deja_dup_backend_ssh_construct (DEJA_DUP_TYPE_BACKEND_SSH, win);
}


static DejaDupBackend* deja_dup_backend_ssh_real_clone (DejaDupBackend* base) {
	DejaDupBackendSSH * self;
	self = (DejaDupBackendSSH*) base;
	return (DejaDupBackend*) deja_dup_backend_ssh_new (deja_dup_backend_get_toplevel ((DejaDupBackend*) self));
}


static void deja_dup_backend_ssh_real_add_argv (DejaDupBackend* base, GList** argv) {
	DejaDupBackendSSH * self;
	self = (DejaDupBackendSSH*) base;
	g_return_if_fail (argv != NULL);
	(*argv) = g_list_append ((*argv), g_strdup ("--ssh-askpass"));
	(*argv) = g_list_append ((*argv), g_strdup ("--ssh-options=-oStrictHostKeyChecking=no"));
}


static gint deja_dup_backend_ssh_get_port (DejaDupBackendSSH* self, GError** error) {
	GError * inner_error;
	GConfClient* _tmp0;
	GConfClient* client;
	gint port;
	gint _tmp1;
	gint _tmp2;
	g_return_val_if_fail (self != NULL, 0);
	inner_error = NULL;
	_tmp0 = NULL;
	client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	port = gconf_client_get_int (client, DEJA_DUP_SSH_PORT_KEY, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		return 0;
	}
	_tmp1 = 0;
	if (port > 0) {
		_tmp1 = port;
	} else {
		_tmp1 = 22;
	}
	return (_tmp2 = _tmp1, (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), _tmp2);
}


static char* deja_dup_backend_ssh_get_username (DejaDupBackendSSH* self, GError** error) {
	GError * inner_error;
	GConfClient* _tmp0;
	GConfClient* client;
	const char* _tmp1;
	char* username;
	gboolean _tmp2;
	char* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	_tmp1 = NULL;
	username = (_tmp1 = gconf_client_get_string (client, DEJA_DUP_SSH_USERNAME_KEY, &inner_error), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		return NULL;
	}
	_tmp2 = FALSE;
	if (username == NULL) {
		_tmp2 = TRUE;
	} else {
		_tmp2 = _vala_strcmp0 (username, "") == 0;
	}
	if (_tmp2) {
		inner_error = g_error_new_literal (DEJA_DUP_BACKUP_ERROR, DEJA_DUP_BACKUP_ERROR_BAD_CONFIG, _ ("No username specified"));
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
			username = (g_free (username), NULL);
			return NULL;
		}
	}
	_tmp3 = NULL;
	return (_tmp3 = username, (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), _tmp3);
}


static char* deja_dup_backend_ssh_get_server (DejaDupBackendSSH* self, GError** error) {
	GError * inner_error;
	GConfClient* _tmp0;
	GConfClient* client;
	const char* _tmp1;
	char* server;
	gboolean _tmp2;
	char* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	_tmp1 = NULL;
	server = (_tmp1 = gconf_client_get_string (client, DEJA_DUP_SSH_SERVER_KEY, &inner_error), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		return NULL;
	}
	_tmp2 = FALSE;
	if (server == NULL) {
		_tmp2 = TRUE;
	} else {
		_tmp2 = _vala_strcmp0 (server, "") == 0;
	}
	if (_tmp2) {
		inner_error = g_error_new_literal (DEJA_DUP_BACKUP_ERROR, DEJA_DUP_BACKUP_ERROR_BAD_CONFIG, _ ("No server specified"));
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
			server = (g_free (server), NULL);
			return NULL;
		}
	}
	_tmp3 = NULL;
	return (_tmp3 = server, (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), _tmp3);
}


static char* deja_dup_backend_ssh_get_directory (DejaDupBackendSSH* self, GError** error) {
	GError * inner_error;
	GConfClient* _tmp0;
	GConfClient* client;
	const char* _tmp1;
	char* directory;
	gboolean _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	_tmp1 = NULL;
	directory = (_tmp1 = gconf_client_get_string (client, DEJA_DUP_SSH_DIRECTORY_KEY, &inner_error), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		return NULL;
	}
	_tmp2 = FALSE;
	if (directory == NULL) {
		_tmp2 = TRUE;
	} else {
		_tmp2 = _vala_strcmp0 (directory, "") == 0;
	}
	if (_tmp2) {
		char* _tmp3;
		_tmp3 = NULL;
		return (_tmp3 = g_strdup ("/"), (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), directory = (g_free (directory), NULL), _tmp3);
	} else {
		if (g_utf8_get_char (g_utf8_offset_to_pointer (directory, 0)) != '/') {
			char* _tmp4;
			_tmp4 = NULL;
			return (_tmp4 = g_strconcat ("/", directory, NULL), (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), directory = (g_free (directory), NULL), _tmp4);
		} else {
			char* _tmp5;
			_tmp5 = NULL;
			return (_tmp5 = directory, (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), _tmp5);
		}
	}
	(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
	directory = (g_free (directory), NULL);
}


static char* deja_dup_backend_ssh_real_get_location (DejaDupBackend* base, GError** error) {
	DejaDupBackendSSH * self;
	GError * inner_error;
	char* username;
	char* directory;
	char* _tmp3;
	self = (DejaDupBackendSSH*) base;
	inner_error = NULL;
	username = deja_dup_backend_ssh_get_username (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	directory = deja_dup_backend_ssh_get_directory (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		username = (g_free (username), NULL);
		return NULL;
	}
	if (self->priv->server == NULL) {
		char* _tmp0;
		char* _tmp1;
		gint _tmp2;
		_tmp0 = deja_dup_backend_ssh_get_server (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			username = (g_free (username), NULL);
			directory = (g_free (directory), NULL);
			return NULL;
		}
		/* we haven't yet got server or port from gconf*/
		_tmp1 = NULL;
		self->priv->server = (_tmp1 = _tmp0, self->priv->server = (g_free (self->priv->server), NULL), _tmp1);
		_tmp2 = deja_dup_backend_ssh_get_port (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			username = (g_free (username), NULL);
			directory = (g_free (directory), NULL);
			return NULL;
		}
		self->priv->port = _tmp2;
	}
	_tmp3 = NULL;
	return (_tmp3 = g_strdup_printf ("ssh://%s@%s:%d/%s", username, self->priv->server, self->priv->port, directory), username = (g_free (username), NULL), directory = (g_free (directory), NULL), _tmp3);
}


static char* deja_dup_backend_ssh_real_get_location_pretty (DejaDupBackend* base, GError** error) {
	DejaDupBackendSSH * self;
	GError * inner_error;
	char* username;
	char* directory;
	char* _tmp3;
	self = (DejaDupBackendSSH*) base;
	inner_error = NULL;
	username = deja_dup_backend_ssh_get_username (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	directory = deja_dup_backend_ssh_get_directory (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		username = (g_free (username), NULL);
		return NULL;
	}
	if (self->priv->server == NULL) {
		char* _tmp0;
		char* _tmp1;
		gint _tmp2;
		_tmp0 = deja_dup_backend_ssh_get_server (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			username = (g_free (username), NULL);
			directory = (g_free (directory), NULL);
			return NULL;
		}
		/* we haven't yet got server or port from gconf*/
		_tmp1 = NULL;
		self->priv->server = (_tmp1 = _tmp0, self->priv->server = (g_free (self->priv->server), NULL), _tmp1);
		_tmp2 = deja_dup_backend_ssh_get_port (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			username = (g_free (username), NULL);
			directory = (g_free (directory), NULL);
			return NULL;
		}
		self->priv->port = _tmp2;
	}
	_tmp3 = NULL;
	return (_tmp3 = g_strdup_printf (_ ("%s on ssh://%s@%s:%d"), directory, username, self->priv->server, self->priv->port), username = (g_free (username), NULL), directory = (g_free (directory), NULL), _tmp3);
}


static void _deja_dup_backend_ssh_found_password_gnome_keyring_operation_get_list_callback (GnomeKeyringResult result, GList* list, gpointer self) {
	deja_dup_backend_ssh_found_password (self, result, list);
}


static void deja_dup_backend_ssh_real_get_envp (DejaDupBackend* base, GError** error) {
	DejaDupBackendSSH * self;
	GError * inner_error;
	GConfClient* _tmp0;
	GConfClient* client;
	const char* _tmp1;
	char* _tmp3;
	const char* _tmp2;
	const char* _tmp4;
	char* _tmp6;
	const char* _tmp5;
	char* _tmp7;
	char* _tmp8;
	gint _tmp9;
	gboolean _tmp10;
	self = (DejaDupBackendSSH*) base;
	inner_error = NULL;
	_tmp0 = NULL;
	client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	_tmp1 = gconf_client_get_string (client, DEJA_DUP_SSH_USERNAME_KEY, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		return;
	}
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->gconf_id = (_tmp3 = (_tmp2 = _tmp1, (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), self->priv->gconf_id = (g_free (self->priv->gconf_id), NULL), _tmp3);
	_tmp4 = NULL;
	if (self->priv->gconf_id == NULL) {
		_tmp4 = "";
	} else {
		_tmp4 = self->priv->gconf_id;
	}
	_tmp6 = NULL;
	_tmp5 = NULL;
	self->priv->id = (_tmp6 = (_tmp5 = _tmp4, (_tmp5 == NULL) ? NULL : g_strdup (_tmp5)), self->priv->id = (g_free (self->priv->id), NULL), _tmp6);
	_tmp7 = deja_dup_backend_ssh_get_server (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		return;
	}
	_tmp8 = NULL;
	self->priv->server = (_tmp8 = _tmp7, self->priv->server = (g_free (self->priv->server), NULL), _tmp8);
	_tmp9 = deja_dup_backend_ssh_get_port (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		return;
	}
	self->priv->port = _tmp9;
	_tmp10 = FALSE;
	if (_vala_strcmp0 (self->priv->id, "") != 0) {
		_tmp10 = self->priv->secret_key != NULL;
	} else {
		_tmp10 = FALSE;
	}
	if (_tmp10) {
		/* We've already been run before and got the key*/
		deja_dup_backend_ssh_got_secret_key (self);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		return;
	}
	if (_vala_strcmp0 (self->priv->id, "") != 0) {
		char* _tmp11;
		/* First, try user's keyring*/
		_tmp11 = NULL;
		self->priv->secret_key = (_tmp11 = NULL, self->priv->secret_key = (g_free (self->priv->secret_key), NULL), _tmp11);
		gnome_keyring_find_network_password (self->priv->id, NULL, self->priv->server, NULL, "ssh", NULL, (guint32) self->priv->port, _deja_dup_backend_ssh_found_password_gnome_keyring_operation_get_list_callback, g_object_ref (self), g_object_unref);
	} else {
		g_signal_emit_by_name ((DejaDupBackend*) self, "need-password");
	}
	(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
}


static void deja_dup_backend_ssh_found_password (DejaDupBackendSSH* self, GnomeKeyringResult result, GList* list) {
	gboolean _tmp0;
	g_return_if_fail (self != NULL);
	_tmp0 = FALSE;
	if (result == GNOME_KEYRING_RESULT_OK) {
		_tmp0 = list != NULL;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		char* _tmp2;
		const char* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		self->priv->secret_key = (_tmp2 = (_tmp1 = ((GnomeKeyringNetworkPasswordData*) list->data)->password, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->secret_key = (g_free (self->priv->secret_key), NULL), _tmp2);
		deja_dup_backend_ssh_got_secret_key (self);
	} else {
		g_signal_emit_by_name ((DejaDupBackend*) self, "need-password");
	}
}


static void deja_dup_backend_ssh_save_password_callback (DejaDupBackendSSH* self, GnomeKeyringResult result, guint32 val) {
	g_return_if_fail (self != NULL);
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static void _deja_dup_backend_ssh_save_password_callback_gnome_keyring_operation_get_int_callback (GnomeKeyringResult result, guint32 val, gpointer self) {
	deja_dup_backend_ssh_save_password_callback (self, result, val);
}


static void deja_dup_backend_ssh_real_ask_password (DejaDupBackend* base) {
	DejaDupBackendSSH * self;
	char* _tmp0;
	GnomePasswordDialog* _tmp1;
	GnomePasswordDialog* dlg;
	char* _tmp4;
	const char* _tmp3;
	char* _tmp6;
	const char* _tmp5;
	GnomePasswordDialogRemember remember;
	self = (DejaDupBackendSSH*) base;
	/* Ask user*/
	_tmp0 = NULL;
	_tmp1 = NULL;
	dlg = (_tmp1 = g_object_ref_sink ((GnomePasswordDialog*) gnome_password_dialog_new (_ ("SSH Password"), _tmp0 = g_strdup_printf (_ ("Enter your SSH username and password for server %s."), self->priv->server), self->priv->id, "", FALSE)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	((GtkWindow*) dlg)->transient_parent = deja_dup_backend_get_toplevel ((DejaDupBackend*) self);
	g_object_set (dlg, "show-remember", TRUE, NULL);
	if (!gnome_password_dialog_run_and_block (dlg)) {
		GList* _tmp2;
		_tmp2 = NULL;
		g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", FALSE, _tmp2 = NULL);
		(_tmp2 == NULL) ? NULL : (_tmp2 = (_g_list_free_g_free (_tmp2), NULL));
		(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
		return;
	}
	_tmp4 = NULL;
	_tmp3 = NULL;
	self->priv->id = (_tmp4 = (_tmp3 = gnome_password_dialog_get_username (dlg), (_tmp3 == NULL) ? NULL : g_strdup (_tmp3)), self->priv->id = (g_free (self->priv->id), NULL), _tmp4);
	_tmp6 = NULL;
	_tmp5 = NULL;
	self->priv->secret_key = (_tmp6 = (_tmp5 = gnome_password_dialog_get_password (dlg), (_tmp5 == NULL) ? NULL : g_strdup (_tmp5)), self->priv->secret_key = (g_free (self->priv->secret_key), NULL), _tmp6);
	/* Save it*/
	remember = gnome_password_dialog_get_remember (dlg);
	if (remember != GNOME_PASSWORD_DIALOG_REMEMBER_NOTHING) {
		const char* _tmp7;
		const char* _tmp8;
		char* where;
		_tmp7 = NULL;
		if (remember == GNOME_PASSWORD_DIALOG_REMEMBER_SESSION) {
			_tmp7 = "session";
		} else {
			_tmp7 = GNOME_KEYRING_DEFAULT;
		}
		_tmp8 = NULL;
		where = (_tmp8 = _tmp7, (_tmp8 == NULL) ? NULL : g_strdup (_tmp8));
		gnome_keyring_set_network_password (where, self->priv->id, NULL, self->priv->server, NULL, "ssh", NULL, (guint32) self->priv->port, self->priv->secret_key, _deja_dup_backend_ssh_save_password_callback_gnome_keyring_operation_get_int_callback, g_object_ref (self), g_object_unref);
		where = (g_free (where), NULL);
	}
	deja_dup_backend_ssh_got_secret_key (self);
	(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
}


static void deja_dup_backend_ssh_got_secret_key (DejaDupBackendSSH* self) {
	GError * inner_error;
	GConfClient* _tmp0;
	GConfClient* client;
	GList* envp;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	if (_vala_strcmp0 (self->priv->id, self->priv->gconf_id) != 0) {
		{
			gconf_client_set_string (client, DEJA_DUP_SSH_USERNAME_KEY, self->priv->id, &inner_error);
			if (inner_error != NULL) {
				goto __catch2_g_error;
				goto __finally2;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_warning ("BackendSSH.vala:188: %s\n", e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally2:
		if (inner_error != NULL) {
			(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
	}
	envp = NULL;
	envp = g_list_append (envp, g_strdup_printf ("FTP_PASSWORD=%s", self->priv->secret_key));
	g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", TRUE, envp);
	(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
	(envp == NULL) ? NULL : (envp = (_g_list_free_g_free (envp), NULL));
}


static void deja_dup_backend_ssh_class_init (DejaDupBackendSSHClass * klass) {
	deja_dup_backend_ssh_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupBackendSSHPrivate));
	G_OBJECT_CLASS (klass)->finalize = deja_dup_backend_ssh_finalize;
	DEJA_DUP_BACKEND_CLASS (klass)->clone = deja_dup_backend_ssh_real_clone;
	DEJA_DUP_BACKEND_CLASS (klass)->add_argv = deja_dup_backend_ssh_real_add_argv;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location = deja_dup_backend_ssh_real_get_location;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location_pretty = deja_dup_backend_ssh_real_get_location_pretty;
	DEJA_DUP_BACKEND_CLASS (klass)->get_envp = deja_dup_backend_ssh_real_get_envp;
	DEJA_DUP_BACKEND_CLASS (klass)->ask_password = deja_dup_backend_ssh_real_ask_password;
}


static void deja_dup_backend_ssh_instance_init (DejaDupBackendSSH * self) {
	self->priv = DEJA_DUP_BACKEND_SSH_GET_PRIVATE (self);
}


static void deja_dup_backend_ssh_finalize (GObject* obj) {
	DejaDupBackendSSH * self;
	self = DEJA_DUP_BACKEND_SSH (obj);
	self->priv->gconf_id = (g_free (self->priv->gconf_id), NULL);
	self->priv->id = (g_free (self->priv->id), NULL);
	self->priv->server = (g_free (self->priv->server), NULL);
	self->priv->secret_key = (g_free (self->priv->secret_key), NULL);
	G_OBJECT_CLASS (deja_dup_backend_ssh_parent_class)->finalize (obj);
}


GType deja_dup_backend_ssh_get_type (void) {
	static GType deja_dup_backend_ssh_type_id = 0;
	if (deja_dup_backend_ssh_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendSSHClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_ssh_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendSSH), 0, (GInstanceInitFunc) deja_dup_backend_ssh_instance_init, NULL };
		deja_dup_backend_ssh_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendSSH", &g_define_type_info, 0);
	}
	return deja_dup_backend_ssh_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




