/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include <Duplicity.h>
#include <glib/gi18n-lib.h>
#include <DuplicityInstance.h>
#include <DuplicityInfo.h>
#include <BackendS3.h>




static glong string_get_length (const char* self);
struct _DejaDupDuplicityPrivate {
	GtkWindow* _toplevel;
	DejaDupOperationMode _mode;
	gboolean _error_issued;
	char* _local;
	DejaDupBackend* _backend;
	GList* _restore_files;
	DejaDupDuplicityState _state;
	DejaDupDuplicityInstance* inst;
	char* remote;
	GList* backend_argv;
	GList* saved_argv;
	GList* saved_envp;
	gboolean has_progress_total;
	double progress_total;
	double progress_count;
};

#define DEJA_DUP_DUPLICITY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityPrivate))
enum  {
	DEJA_DUP_DUPLICITY_DUMMY_PROPERTY,
	DEJA_DUP_DUPLICITY_TOPLEVEL,
	DEJA_DUP_DUPLICITY_MODE,
	DEJA_DUP_DUPLICITY_ERROR_ISSUED,
	DEJA_DUP_DUPLICITY_LOCAL,
	DEJA_DUP_DUPLICITY_BACKEND,
	DEJA_DUP_DUPLICITY_RESTORE_FILES,
	DEJA_DUP_DUPLICITY_STATE
};
static void _g_list_free_g_object_unref (GList* self);
static void _g_list_free_g_free (GList* self);
static GFile* deja_dup_duplicity_root = NULL;
static void deja_dup_duplicity_real_start (DejaDupDuplicity* self, DejaDupBackend* backend, const char* remote, gboolean encrypted, GList* argv, GList* envp);
static gboolean deja_dup_duplicity_restart (DejaDupDuplicity* self);
static gboolean deja_dup_duplicity_cleanup (DejaDupDuplicity* self);
static void deja_dup_duplicity_handle_done (DejaDupDuplicity* self, DejaDupDuplicityInstance* inst, gboolean success, gboolean cancelled);
static gboolean deja_dup_duplicity_restart_with_short_filenames_if_needed (DejaDupDuplicity* self);
static void deja_dup_duplicity_handle_message (DejaDupDuplicity* self, DejaDupDuplicityInstance* inst, char** control_line, int control_line_length1, GList* data_lines, const char* user_text);
static void deja_dup_duplicity_real_process_error (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text_in);
static void deja_dup_duplicity_process_exception (DejaDupDuplicity* self, const char* exception, const char* text);
static void deja_dup_duplicity_real_process_info (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text);
static void deja_dup_duplicity_process_diff_file (DejaDupDuplicity* self, const char* file);
static void deja_dup_duplicity_process_patch_file (DejaDupDuplicity* self, const char* file);
static void deja_dup_duplicity_process_progress (DejaDupDuplicity* self, char** firstline, int firstline_length1);
static GFile* deja_dup_duplicity_make_file_obj (DejaDupDuplicity* self, const char* file);
static void deja_dup_duplicity_process_collection_status (DejaDupDuplicity* self, GList* lines);
static void deja_dup_duplicity_real_process_warning (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text);
static void deja_dup_duplicity_show_error (DejaDupDuplicity* self, const char* errorstr);
static void _deja_dup_duplicity_handle_done_deja_dup_duplicity_instance_done (DejaDupDuplicityInstance* _sender, gboolean success, gboolean cancelled, gpointer self);
static void _deja_dup_duplicity_handle_message_deja_dup_duplicity_instance_message (DejaDupDuplicityInstance* _sender, char** control_line, int control_line_length1, GList* data_lines, const char* user_text, gpointer self);
static void deja_dup_duplicity_connect_and_start (DejaDupDuplicity* self, GList* argv_extra, GList* envp_extra, GList* argv_entire, const char* custom_local);
static void deja_dup_duplicity_set_toplevel (DejaDupDuplicity* self, GtkWindow* value);
static void deja_dup_duplicity_set_mode (DejaDupDuplicity* self, DejaDupOperationMode value);
static void deja_dup_duplicity_set_error_issued (DejaDupDuplicity* self, gboolean value);
static gpointer deja_dup_duplicity_parent_class = NULL;
static void deja_dup_duplicity_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static glong string_get_length (const char* self) {
	g_return_val_if_fail (self != NULL, 0L);
	return g_utf8_strlen (self, -1);
}



GType deja_dup_duplicity_state_get_type (void) {
	static GType deja_dup_duplicity_state_type_id = 0;
	if (G_UNLIKELY (deja_dup_duplicity_state_type_id == 0)) {
		static const GEnumValue values[] = {{DEJA_DUP_DUPLICITY_STATE_NORMAL, "DEJA_DUP_DUPLICITY_STATE_NORMAL", "normal"}, {DEJA_DUP_DUPLICITY_STATE_DRY_RUN, "DEJA_DUP_DUPLICITY_STATE_DRY_RUN", "dry-run"}, {DEJA_DUP_DUPLICITY_STATE_CLEANUP, "DEJA_DUP_DUPLICITY_STATE_CLEANUP", "cleanup"}, {0, NULL, NULL}};
		deja_dup_duplicity_state_type_id = g_enum_register_static ("DejaDupDuplicityState", values);
	}
	return deja_dup_duplicity_state_type_id;
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


/* count of how far we are along in the current instance*/
DejaDupDuplicity* deja_dup_duplicity_construct (GType object_type, DejaDupOperationMode mode, GtkWindow* win) {
	GParameter * __params;
	GParameter * __params_it;
	DejaDupDuplicity * self;
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "toplevel";
	g_value_init (&__params_it->value, GTK_TYPE_WINDOW);
	g_value_set_object (&__params_it->value, win);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	deja_dup_duplicity_set_mode (self, mode);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DejaDupDuplicity* deja_dup_duplicity_new (DejaDupOperationMode mode, GtkWindow* win) {
	return deja_dup_duplicity_construct (DEJA_DUP_TYPE_DUPLICITY, mode, win);
}


static void deja_dup_duplicity_real_start (DejaDupDuplicity* self, DejaDupBackend* backend, const char* remote, gboolean encrypted, GList* argv, GList* envp) {
	char* _tmp1;
	const char* _tmp0;
	GList* _tmp2;
	GList* _tmp3;
	GList* _tmp4;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (remote != NULL);
	/* save arguments for calling duplicity again later*/
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->remote = (_tmp1 = (_tmp0 = remote, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), self->priv->remote = (g_free (self->priv->remote), NULL), _tmp1);
	deja_dup_duplicity_set_backend (self, backend);
	_tmp2 = NULL;
	self->priv->saved_argv = (_tmp2 = NULL, (self->priv->saved_argv == NULL) ? NULL : (self->priv->saved_argv = (_g_list_free_g_free (self->priv->saved_argv), NULL)), _tmp2);
	_tmp3 = NULL;
	self->priv->saved_envp = (_tmp3 = NULL, (self->priv->saved_envp == NULL) ? NULL : (self->priv->saved_envp = (_g_list_free_g_free (self->priv->saved_envp), NULL)), _tmp3);
	_tmp4 = NULL;
	self->priv->backend_argv = (_tmp4 = NULL, (self->priv->backend_argv == NULL) ? NULL : (self->priv->backend_argv = (_g_list_free_g_free (self->priv->backend_argv), NULL)), _tmp4);
	{
		GList* s_collection;
		GList* s_it;
		s_collection = argv;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			const char* _tmp6;
			char* s;
			_tmp6 = NULL;
			s = (_tmp6 = (const char*) s_it->data, (_tmp6 == NULL) ? NULL : g_strdup (_tmp6));
			{
				const char* _tmp5;
				_tmp5 = NULL;
				self->priv->saved_argv = g_list_append (self->priv->saved_argv, (_tmp5 = s, (_tmp5 == NULL) ? NULL : g_strdup (_tmp5)));
				s = (g_free (s), NULL);
			}
		}
	}
	{
		GList* s_collection;
		GList* s_it;
		s_collection = envp;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			const char* _tmp8;
			char* s;
			_tmp8 = NULL;
			s = (_tmp8 = (const char*) s_it->data, (_tmp8 == NULL) ? NULL : g_strdup (_tmp8));
			{
				const char* _tmp7;
				_tmp7 = NULL;
				self->priv->saved_envp = g_list_append (self->priv->saved_envp, (_tmp7 = s, (_tmp7 == NULL) ? NULL : g_strdup (_tmp7)));
				s = (g_free (s), NULL);
			}
		}
	}
	deja_dup_backend_add_argv (backend, &self->priv->backend_argv);
	if (!encrypted) {
		self->priv->backend_argv = g_list_append (self->priv->backend_argv, g_strdup ("--no-encryption"));
	}
	if (!deja_dup_duplicity_restart (self)) {
		g_signal_emit_by_name (self, "done", FALSE, FALSE);
	}
}


void deja_dup_duplicity_start (DejaDupDuplicity* self, DejaDupBackend* backend, const char* remote, gboolean encrypted, GList* argv, GList* envp) {
	DEJA_DUP_DUPLICITY_GET_CLASS (self)->start (self, backend, remote, encrypted, argv, envp);
}


void deja_dup_duplicity_cancel (DejaDupDuplicity* self) {
	DejaDupOperationMode old_mode;
	g_return_if_fail (self != NULL);
	old_mode = self->priv->_mode;
	deja_dup_duplicity_set_mode (self, DEJA_DUP_OPERATION_MODE_INVALID);
	if (old_mode == DEJA_DUP_OPERATION_MODE_BACKUP) {
		if (deja_dup_duplicity_cleanup (self)) {
			return;
		}
	}
	deja_dup_duplicity_instance_cancel (self->priv->inst);
}


static gboolean deja_dup_duplicity_restart (DejaDupDuplicity* self) {
	GError * inner_error;
	GList* extra_argv;
	char* action_desc;
	char* custom_local;
	gboolean _tmp10;
	g_return_val_if_fail (self != NULL, FALSE);
	inner_error = NULL;
	deja_dup_duplicity_set_state (self, DEJA_DUP_DUPLICITY_STATE_NORMAL);
	if (self->priv->_mode == DEJA_DUP_OPERATION_MODE_INVALID) {
		return FALSE;
	}
	extra_argv = NULL;
	action_desc = NULL;
	custom_local = NULL;
	switch (self->priv->_mode) {
		case DEJA_DUP_OPERATION_MODE_BACKUP:
		{
			gboolean _tmp1;
			DejaDupDuplicityInfo* _tmp2;
			gboolean _tmp3;
			_tmp1 = FALSE;
			_tmp2 = NULL;
			if ((_tmp3 = deja_dup_duplicity_info_get_has_backup_progress (_tmp2 = deja_dup_duplicity_info_get_default ()), (_tmp2 == NULL) ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)), _tmp3)) {
				_tmp1 = !self->priv->has_progress_total;
			} else {
				_tmp1 = FALSE;
			}
			if (_tmp1) {
				char* _tmp5;
				const char* _tmp4;
				deja_dup_duplicity_set_state (self, DEJA_DUP_DUPLICITY_STATE_DRY_RUN);
				_tmp5 = NULL;
				_tmp4 = NULL;
				action_desc = (_tmp5 = (_tmp4 = _ ("Preparing..."), (_tmp4 == NULL) ? NULL : g_strdup (_tmp4)), action_desc = (g_free (action_desc), NULL), _tmp5);
				extra_argv = g_list_append (extra_argv, g_strdup ("--dry-run"));
			}
			break;
		}
		case DEJA_DUP_OPERATION_MODE_RESTORE:
		{
			if (deja_dup_duplicity_get_restore_files (self) != NULL) {
				GFile* local_file;
				GFile* root;
				char* rel_file_path;
				GFile* _tmp6;
				char* _tmp8;
				/* Just do first one.  Others will come when we're done
				 make path to specific restore file, since duplicity will just 
				 drop the file exactly where you ask it*/
				local_file = g_file_new_for_path (self->priv->_local);
				root = g_file_new_for_path ("/");
				rel_file_path = g_file_get_relative_path (root, (GFile*) deja_dup_duplicity_get_restore_files (self)->data);
				_tmp6 = NULL;
				local_file = (_tmp6 = g_file_resolve_relative_path (local_file, rel_file_path), (local_file == NULL) ? NULL : (local_file = (g_object_unref (local_file), NULL)), _tmp6);
				{
					/* won't have correct permissions...*/
					g_file_make_directory_with_parents (local_file, NULL, &inner_error);
					if (inner_error != NULL) {
						goto __catch3_g_error;
						goto __finally3;
					}
				}
				goto __finally3;
				__catch3_g_error:
				{
					GError * e;
					e = inner_error;
					inner_error = NULL;
					{
						gboolean _tmp7;
						deja_dup_duplicity_show_error (self, e->message);
						return (_tmp7 = FALSE, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), (local_file == NULL) ? NULL : (local_file = (g_object_unref (local_file), NULL)), (root == NULL) ? NULL : (root = (g_object_unref (root), NULL)), rel_file_path = (g_free (rel_file_path), NULL), (extra_argv == NULL) ? NULL : (extra_argv = (_g_list_free_g_free (extra_argv), NULL)), action_desc = (g_free (action_desc), NULL), custom_local = (g_free (custom_local), NULL), _tmp7);
					}
				}
				__finally3:
				if (inner_error != NULL) {
					(local_file == NULL) ? NULL : (local_file = (g_object_unref (local_file), NULL));
					(root == NULL) ? NULL : (root = (g_object_unref (root), NULL));
					rel_file_path = (g_free (rel_file_path), NULL);
					(extra_argv == NULL) ? NULL : (extra_argv = (_g_list_free_g_free (extra_argv), NULL));
					action_desc = (g_free (action_desc), NULL);
					custom_local = (g_free (custom_local), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
					return FALSE;
				}
				_tmp8 = NULL;
				custom_local = (_tmp8 = g_file_get_path (local_file), custom_local = (g_free (custom_local), NULL), _tmp8);
				extra_argv = g_list_append (extra_argv, g_strdup_printf ("--file-to-restore=%s", rel_file_path));
				(local_file == NULL) ? NULL : (local_file = (g_object_unref (local_file), NULL));
				(root == NULL) ? NULL : (root = (g_object_unref (root), NULL));
				rel_file_path = (g_free (rel_file_path), NULL);
			}
			break;
		}
	}
	/* Send appropriate description for what we're about to do.  Is often
	 very quickly overridden by a message like "Backing up file X"*/
	if (action_desc == NULL) {
		char* _tmp9;
		_tmp9 = NULL;
		action_desc = (_tmp9 = deja_dup_operation_mode_to_string (self->priv->_mode), action_desc = (g_free (action_desc), NULL), _tmp9);
	}
	g_signal_emit_by_name (self, "action-desc-changed", action_desc);
	deja_dup_duplicity_connect_and_start (self, extra_argv, NULL, NULL, custom_local);
	return (_tmp10 = TRUE, (extra_argv == NULL) ? NULL : (extra_argv = (_g_list_free_g_free (extra_argv), NULL)), action_desc = (g_free (action_desc), NULL), custom_local = (g_free (custom_local), NULL), _tmp10);
}


static gboolean deja_dup_duplicity_cleanup (DejaDupDuplicity* self) {
	gboolean _tmp0;
	DejaDupDuplicityInfo* _tmp1;
	gboolean _tmp2;
	GList* cleanup_argv;
	const char* _tmp4;
	gboolean _tmp5;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0 = FALSE;
	_tmp1 = NULL;
	if ((_tmp2 = deja_dup_duplicity_info_get_has_broken_cleanup (_tmp1 = deja_dup_duplicity_info_get_default ()), (_tmp1 == NULL) ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)), _tmp2)) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = self->priv->_state == DEJA_DUP_DUPLICITY_STATE_CLEANUP;
	}
	if (_tmp0) {
		return FALSE;
	}
	deja_dup_duplicity_set_state (self, DEJA_DUP_DUPLICITY_STATE_CLEANUP);
	cleanup_argv = NULL;
	cleanup_argv = g_list_append (cleanup_argv, g_strdup ("cleanup"));
	cleanup_argv = g_list_append (cleanup_argv, g_strdup ("--force"));
	_tmp4 = NULL;
	cleanup_argv = g_list_append (cleanup_argv, (_tmp4 = self->priv->remote, (_tmp4 == NULL) ? NULL : g_strdup (_tmp4)));
	g_signal_emit_by_name (self, "action-desc-changed", _ ("Cleaning up..."));
	deja_dup_duplicity_connect_and_start (self, NULL, NULL, cleanup_argv, NULL);
	return (_tmp5 = TRUE, (cleanup_argv == NULL) ? NULL : (cleanup_argv = (_g_list_free_g_free (cleanup_argv), NULL)), _tmp5);
}


static void deja_dup_duplicity_handle_done (DejaDupDuplicity* self, DejaDupDuplicityInstance* inst, gboolean success, gboolean cancelled) {
	gboolean _tmp2;
	gboolean _tmp3;
	g_return_if_fail (self != NULL);
	g_return_if_fail (inst != NULL);
	if (!cancelled) {
		switch (self->priv->_state) {
			case DEJA_DUP_DUPLICITY_STATE_DRY_RUN:
			{
				if (success) {
					self->priv->has_progress_total = TRUE;
					self->priv->progress_total = self->priv->progress_count;
					/* save max progress for next run*/
					if (deja_dup_duplicity_restart (self)) {
						return;
					}
				}
				break;
			}
			case DEJA_DUP_DUPLICITY_STATE_CLEANUP:
			{
				if (deja_dup_duplicity_restart (self)) {
					return;
				}
				success = FALSE;
				cancelled = TRUE;
				break;
			}
			case DEJA_DUP_DUPLICITY_STATE_NORMAL:
			{
				gboolean _tmp0;
				gboolean _tmp1;
				_tmp0 = FALSE;
				_tmp1 = FALSE;
				if (success) {
					_tmp1 = self->priv->_mode == DEJA_DUP_OPERATION_MODE_RESTORE;
				} else {
					_tmp1 = FALSE;
				}
				if (_tmp1) {
					_tmp0 = deja_dup_duplicity_get_restore_files (self) != NULL;
				} else {
					_tmp0 = FALSE;
				}
				if (_tmp0) {
					self->priv->_restore_files = g_list_delete_link (self->priv->_restore_files, self->priv->_restore_files);
					if (deja_dup_duplicity_get_restore_files (self) != NULL) {
						if (deja_dup_duplicity_restart (self)) {
							return;
						}
					}
				}
				break;
			}
		}
	}
	if (self->priv->_error_issued) {
		success = FALSE;
	}
	_tmp2 = FALSE;
	_tmp3 = FALSE;
	if (!success) {
		_tmp3 = !cancelled;
	} else {
		_tmp3 = FALSE;
	}
	if (_tmp3) {
		_tmp2 = !self->priv->_error_issued;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		deja_dup_duplicity_show_error (self, _ ("Failed with an unknown error."));
	}
	inst = NULL;
	g_signal_emit_by_name (self, "done", success, cancelled);
}


static gboolean deja_dup_duplicity_restart_with_short_filenames_if_needed (DejaDupDuplicity* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GList* s_collection;
		GList* s_it;
		s_collection = self->priv->backend_argv;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			const char* _tmp1;
			char* s;
			_tmp1 = NULL;
			s = (_tmp1 = (const char*) s_it->data, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
			{
				if (_vala_strcmp0 (s, "--short-filenames") == 0) {
					gboolean _tmp0;
					return (_tmp0 = FALSE, s = (g_free (s), NULL), _tmp0);
				}
				s = (g_free (s), NULL);
			}
		}
	}
	self->priv->backend_argv = g_list_append (self->priv->backend_argv, g_strdup ("--short-filenames"));
	if (!deja_dup_duplicity_restart (self)) {
		g_signal_emit_by_name (self, "done", FALSE, FALSE);
		return FALSE;
	}
	return TRUE;
}


static void deja_dup_duplicity_handle_message (DejaDupDuplicity* self, DejaDupDuplicityInstance* inst, char** control_line, int control_line_length1, GList* data_lines, const char* user_text) {
	const char* _tmp0;
	char* keyword;
	GQuark _tmp2;
	char* _tmp1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (inst != NULL);
	g_return_if_fail (user_text != NULL);
	if (control_line_length1 == 0) {
		return;
	}
	_tmp0 = NULL;
	keyword = (_tmp0 = control_line[0], (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
	_tmp1 = NULL;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	_tmp1 = keyword;
	_tmp2 = (NULL == _tmp1) ? 0 : g_quark_from_string (_tmp1);
	if (_tmp2 == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("ERROR"))))
	do {
		deja_dup_duplicity_process_error (self, control_line, control_line_length1, data_lines, user_text);
		break;
	} while (0); else if (_tmp2 == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("INFO"))))
	do {
		deja_dup_duplicity_process_info (self, control_line, control_line_length1, data_lines, user_text);
		break;
	} while (0); else if (_tmp2 == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("WARNING"))))
	do {
		deja_dup_duplicity_process_warning (self, control_line, control_line_length1, data_lines, user_text);
		break;
	} while (0);
	keyword = (g_free (keyword), NULL);
}


static void deja_dup_duplicity_real_process_error (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text_in) {
	const char* _tmp0;
	char* text;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text_in != NULL);
	_tmp0 = NULL;
	text = (_tmp0 = text_in, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
	if (firstline_length1 > 1) {
		switch (atoi (firstline[1])) {
			case DEJA_DUP_DUPLICITY_ERROR_EXCEPTION:
			{
				const char* _tmp1;
				_tmp1 = NULL;
				if (firstline_length1 > 2) {
					_tmp1 = firstline[2];
				} else {
					_tmp1 = "";
				}
				deja_dup_duplicity_process_exception (self, _tmp1, text);
				text = (g_free (text), NULL);
				return;
			}
			case DEJA_DUP_DUPLICITY_ERROR_RESTORE_DIR_NOT_FOUND:
			{
				if (deja_dup_duplicity_get_restore_files (self) != NULL) {
					char* _tmp3;
					char* _tmp2;
					_tmp3 = NULL;
					_tmp2 = NULL;
					text = (_tmp3 = g_strdup_printf (_ ("Could not restore '%s': File not found in backup"), _tmp2 = g_file_get_parse_name ((GFile*) deja_dup_duplicity_get_restore_files (self)->data)), text = (g_free (text), NULL), _tmp3);
					_tmp2 = (g_free (_tmp2), NULL);
				}
				break;
			}
		}
	}
	deja_dup_duplicity_show_error (self, text);
	text = (g_free (text), NULL);
}


void deja_dup_duplicity_process_error (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text_in) {
	DEJA_DUP_DUPLICITY_GET_CLASS (self)->process_error (self, firstline, firstline_length1, data, text_in);
}


static void deja_dup_duplicity_process_exception (DejaDupDuplicity* self, const char* exception, const char* text) {
	GError * inner_error;
	GQuark _tmp3;
	char* _tmp2;
	g_return_if_fail (self != NULL);
	g_return_if_fail (exception != NULL);
	g_return_if_fail (text != NULL);
	inner_error = NULL;
	_tmp2 = NULL;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	_tmp2 = exception;
	_tmp3 = (NULL == _tmp2) ? 0 : g_quark_from_string (_tmp2);
	if (_tmp3 == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("S3ResponseError"))))
	do {
		if (strstr (text, "<Code>InvalidAccessKeyId</Code>") != NULL) {
			deja_dup_duplicity_show_error (self, _ ("Invalid ID."));
		} else {
			if (strstr (text, "<Code>SignatureDoesNotMatch</Code>") != NULL) {
				deja_dup_duplicity_show_error (self, _ ("Invalid secret key."));
			} else {
				if (strstr (text, "<Code>NotSignedUp</Code>") != NULL) {
					deja_dup_duplicity_show_error (self, _ ("Your Amazon Web Services account is not signed up for the S3 service."));
				}
			}
		}
		break;
	} while (0); else if (_tmp3 == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("S3CreateError"))))
	do {
		if (strstr (text, "<Code>BucketAlreadyExists</Code>") != NULL) {
			if (deja_dup_backend_s3_bump_bucket ((DEJA_DUP_BACKEND_S3 (self->priv->_backend)))) {
				char* _tmp0;
				char* _tmp1;
				_tmp0 = deja_dup_backend_get_location (self->priv->_backend, &inner_error);
				if (inner_error != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
					return;
				}
				_tmp1 = NULL;
				self->priv->remote = (_tmp1 = _tmp0, self->priv->remote = (g_free (self->priv->remote), NULL), _tmp1);
				deja_dup_duplicity_restart (self);
			} else {
				deja_dup_duplicity_show_error (self, _ ("S3 bucket name is not available."));
			}
		}
		break;
	} while (0); else if (_tmp3 == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("IOError"))))
	do {
		if (strstr (text, "GnuPG") != NULL) {
			deja_dup_duplicity_show_error (self, _ ("Bad encryption password."));
		} else {
			/* Very possibly a FAT file system that can't handle the colons that 
			 duplicity likes to use.  Try again with --short-filenames
			 But first make sure we aren't already doing that.*/
			deja_dup_duplicity_restart_with_short_filenames_if_needed (self);
		}
		break;
	} while (0); else if (_tmp3 == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("CollectionsError"))))
	do {
		if (deja_dup_duplicity_restart_with_short_filenames_if_needed (self)) {
			deja_dup_duplicity_show_error (self, _ ("No backup files found"));
		}
		break;
	} while (0);
}


/* For most, don't do anything. Error string won't be useful to humans, and
 by not raising it, we'll eventually hit the 'unknown error'
 message which is slightly better than a giant exception string.*/
static void deja_dup_duplicity_real_process_info (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (firstline_length1 > 1) {
		switch (atoi (firstline[1])) {
			case DEJA_DUP_DUPLICITY_INFO_DIFF_FILE_NEW:
			case DEJA_DUP_DUPLICITY_INFO_DIFF_FILE_CHANGED:
			case DEJA_DUP_DUPLICITY_INFO_DIFF_FILE_DELETED:
			{
				if (firstline_length1 > 2) {
					deja_dup_duplicity_process_diff_file (self, firstline[2]);
				}
				break;
			}
			case DEJA_DUP_DUPLICITY_INFO_PATCH_FILE_WRITING:
			case DEJA_DUP_DUPLICITY_INFO_PATCH_FILE_PATCHING:
			{
				if (firstline_length1 > 2) {
					deja_dup_duplicity_process_patch_file (self, firstline[2]);
				}
				break;
			}
			case DEJA_DUP_DUPLICITY_INFO_PROGRESS:
			{
				deja_dup_duplicity_process_progress (self, firstline, firstline_length1);
				break;
			}
			case DEJA_DUP_DUPLICITY_INFO_COLLECTION_STATUS:
			{
				deja_dup_duplicity_process_collection_status (self, data);
				break;
			}
		}
	}
}


void deja_dup_duplicity_process_info (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text) {
	DEJA_DUP_DUPLICITY_GET_CLASS (self)->process_info (self, firstline, firstline_length1, data, text);
}


static void deja_dup_duplicity_process_diff_file (DejaDupDuplicity* self, const char* file) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	if (self->priv->_state != DEJA_DUP_DUPLICITY_STATE_DRY_RUN) {
		GFile* _tmp0;
		_tmp0 = NULL;
		g_signal_emit_by_name (self, "action-file-changed", _tmp0 = deja_dup_duplicity_make_file_obj (self, file));
		(_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL));
	}
}


static void deja_dup_duplicity_process_patch_file (DejaDupDuplicity* self, const char* file) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	if (self->priv->_state != DEJA_DUP_DUPLICITY_STATE_DRY_RUN) {
		GFile* _tmp0;
		_tmp0 = NULL;
		g_signal_emit_by_name (self, "action-file-changed", _tmp0 = deja_dup_duplicity_make_file_obj (self, file));
		(_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL));
	}
}


static void deja_dup_duplicity_process_progress (DejaDupDuplicity* self, char** firstline, int firstline_length1) {
	gboolean _tmp0;
	DejaDupDuplicityInfo* _tmp1;
	gboolean _tmp2;
	double total;
	double percent;
	g_return_if_fail (self != NULL);
	_tmp0 = FALSE;
	_tmp1 = NULL;
	if ((_tmp2 = !deja_dup_duplicity_info_get_has_restore_progress (_tmp1 = deja_dup_duplicity_info_get_default ()), (_tmp1 == NULL) ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)), _tmp2)) {
		_tmp0 = self->priv->_mode == DEJA_DUP_OPERATION_MODE_RESTORE;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		return;
	}
	total = 0.0;
	if (firstline_length1 > 2) {
		self->priv->progress_count = strtod (firstline[2], NULL);
	} else {
		return;
	}
	if (firstline_length1 > 3) {
		total = strtod (firstline[3], NULL);
	} else {
		if (self->priv->progress_total > 0) {
			total = self->priv->progress_total;
		} else {
			return;
		}
	}
	/* can't do progress without a total*/
	percent = self->priv->progress_count / ((double) total);
	if (percent > 1) {
		percent = (double) 1;
	}
	if (percent < 0) {
		percent = (double) 0;
	}
	g_signal_emit_by_name (self, "progress", percent);
}


static GFile* deja_dup_duplicity_make_file_obj (DejaDupDuplicity* self, const char* file) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	/* All files are relative to root.*/
	if (deja_dup_duplicity_root == NULL) {
		GFile* _tmp0;
		_tmp0 = NULL;
		deja_dup_duplicity_root = (_tmp0 = g_file_new_for_path ("/"), (deja_dup_duplicity_root == NULL) ? NULL : (deja_dup_duplicity_root = (g_object_unref (deja_dup_duplicity_root), NULL)), _tmp0);
	}
	return g_file_resolve_relative_path (deja_dup_duplicity_root, file);
}


static void deja_dup_duplicity_process_collection_status (DejaDupDuplicity* self, GList* lines) {
	GTimeVal _tmp0 = {0};
	GTimeVal timeval;
	GList* dates;
	gboolean in_chain;
	gboolean _tmp8;
	g_return_if_fail (self != NULL);
	/* Collection status is a bunch of lines, some of which are indented,
	 which contain information about specific chains.  We gather this all up
	 and report back to caller via a signal.
	 We're really only interested in the list of entries in the complete chain,
	 though.*/
	timeval = (g_get_current_time (&_tmp0), _tmp0);
	dates = NULL;
	in_chain = FALSE;
	{
		GList* line_collection;
		GList* line_it;
		line_collection = lines;
		for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
			const char* _tmp7;
			char* line;
			_tmp7 = NULL;
			line = (_tmp7 = (const char*) line_it->data, (_tmp7 == NULL) ? NULL : g_strdup (_tmp7));
			{
				if (_vala_strcmp0 (line, "chain-complete") == 0) {
					in_chain = TRUE;
				} else {
					gboolean _tmp1;
					gboolean _tmp2;
					_tmp1 = FALSE;
					_tmp2 = FALSE;
					if (in_chain) {
						_tmp2 = string_get_length (line) > 0;
					} else {
						_tmp2 = FALSE;
					}
					if (_tmp2) {
						_tmp1 = g_utf8_get_char (g_utf8_offset_to_pointer (line, 0)) == ' ';
					} else {
						_tmp1 = FALSE;
					}
					if (_tmp1) {
						char** _tmp4;
						gint tokens_size;
						gint tokens_length1;
						char** _tmp3;
						char** tokens;
						gboolean _tmp5;
						/* OK, appears to be a date line.  Try to parse.  Should look like:
						 ' inc TIMESTR NUMVOLS'.  Since there's a space at the beginnning,
						 when we tokenize it, we should expect an extra token at the front.*/
						_tmp4 = NULL;
						_tmp3 = NULL;
						tokens = (_tmp4 = _tmp3 = g_strsplit (line, " ", 0), tokens_length1 = _vala_array_length (_tmp3), tokens_size = tokens_length1, _tmp4);
						_tmp5 = FALSE;
						if (tokens_length1 > 2) {
							_tmp5 = g_time_val_from_iso8601 (tokens[2], &timeval);
						} else {
							_tmp5 = FALSE;
						}
						if (_tmp5) {
							const char* _tmp6;
							_tmp6 = NULL;
							dates = g_list_append (dates, (_tmp6 = tokens[2], (_tmp6 == NULL) ? NULL : g_strdup (_tmp6)));
						}
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					} else {
						if (in_chain) {
							in_chain = FALSE;
						}
					}
				}
				line = (g_free (line), NULL);
			}
		}
	}
	_tmp8 = FALSE;
	if (self->priv->_mode == DEJA_DUP_OPERATION_MODE_STATUS) {
		_tmp8 = g_list_length (dates) == 0;
	} else {
		_tmp8 = FALSE;
	}
	if (_tmp8) {
		/* may not have found short-filenamed-backups*/
		if (deja_dup_duplicity_restart_with_short_filenames_if_needed (self)) {
			(dates == NULL) ? NULL : (dates = (_g_list_free_g_free (dates), NULL));
			return;
		}
	}
	g_signal_emit_by_name (self, "collection-dates", dates);
	(dates == NULL) ? NULL : (dates = (_g_list_free_g_free (dates), NULL));
}


static void deja_dup_duplicity_real_process_warning (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (firstline_length1 > 1) {
		switch (atoi (firstline[1])) {
			case DEJA_DUP_DUPLICITY_WARNING_ORPHANED_SIG:
			case DEJA_DUP_DUPLICITY_WARNING_UNNECESSARY_SIG:
			case DEJA_DUP_DUPLICITY_WARNING_UNMATCHED_SIG:
			case DEJA_DUP_DUPLICITY_WARNING_INCOMPLETE_BACKUP:
			case DEJA_DUP_DUPLICITY_WARNING_ORPHANED_BACKUP:
			{
				deja_dup_duplicity_cleanup (self);
				break;
			}
		}
	}
}


void deja_dup_duplicity_process_warning (DejaDupDuplicity* self, char** firstline, int firstline_length1, GList* data, const char* text) {
	DEJA_DUP_DUPLICITY_GET_CLASS (self)->process_warning (self, firstline, firstline_length1, data, text);
}


static void deja_dup_duplicity_show_error (DejaDupDuplicity* self, const char* errorstr) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (errorstr != NULL);
	deja_dup_duplicity_set_error_issued (self, TRUE);
	g_signal_emit_by_name (self, "raise-error", errorstr, NULL);
}


static void _deja_dup_duplicity_handle_done_deja_dup_duplicity_instance_done (DejaDupDuplicityInstance* _sender, gboolean success, gboolean cancelled, gpointer self) {
	deja_dup_duplicity_handle_done (self, _sender, success, cancelled);
}


static void _deja_dup_duplicity_handle_message_deja_dup_duplicity_instance_message (DejaDupDuplicityInstance* _sender, char** control_line, int control_line_length1, GList* data_lines, const char* user_text, gpointer self) {
	deja_dup_duplicity_handle_message (self, _sender, control_line, control_line_length1, data_lines, user_text);
}


static void deja_dup_duplicity_connect_and_start (DejaDupDuplicity* self, GList* argv_extra, GList* envp_extra, GList* argv_entire, const char* custom_local) {
	GError * inner_error;
	DejaDupDuplicityInstance* _tmp2;
	GList* _tmp3;
	GList* master_argv;
	const char* _tmp4;
	const char* local_arg;
	GList* argv;
	GList* envp;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	if (self->priv->inst != NULL) {
		guint _tmp0;
		guint _tmp1;
		g_signal_handlers_disconnect_matched (self->priv->inst, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("done", DEJA_DUP_TYPE_DUPLICITY_INSTANCE, &_tmp0, NULL, FALSE), _tmp0), 0, NULL, (GCallback) _deja_dup_duplicity_handle_done_deja_dup_duplicity_instance_done, self);
		g_signal_handlers_disconnect_matched (self->priv->inst, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("message", DEJA_DUP_TYPE_DUPLICITY_INSTANCE, &_tmp1, NULL, FALSE), _tmp1), 0, NULL, (GCallback) _deja_dup_duplicity_handle_message_deja_dup_duplicity_instance_message, self);
		deja_dup_duplicity_instance_cancel (self->priv->inst);
	}
	_tmp2 = NULL;
	self->priv->inst = (_tmp2 = deja_dup_duplicity_instance_new (), (self->priv->inst == NULL) ? NULL : (self->priv->inst = (g_object_unref (self->priv->inst), NULL)), _tmp2);
	g_signal_connect_object (self->priv->inst, "done", (GCallback) _deja_dup_duplicity_handle_done_deja_dup_duplicity_instance_done, self, 0);
	g_signal_connect_object (self->priv->inst, "message", (GCallback) _deja_dup_duplicity_handle_message_deja_dup_duplicity_instance_message, self, 0);
	_tmp3 = NULL;
	if (argv_entire == NULL) {
		_tmp3 = self->priv->saved_argv;
	} else {
		_tmp3 = argv_entire;
	}
	master_argv = _tmp3;
	_tmp4 = NULL;
	if (custom_local == NULL) {
		_tmp4 = self->priv->_local;
	} else {
		_tmp4 = custom_local;
	}
	local_arg = _tmp4;
	argv = NULL;
	{
		GList* s_collection;
		GList* s_it;
		s_collection = master_argv;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			const char* _tmp6;
			char* s;
			_tmp6 = NULL;
			s = (_tmp6 = (const char*) s_it->data, (_tmp6 == NULL) ? NULL : g_strdup (_tmp6));
			{
				const char* _tmp5;
				_tmp5 = NULL;
				argv = g_list_append (argv, (_tmp5 = s, (_tmp5 == NULL) ? NULL : g_strdup (_tmp5)));
				s = (g_free (s), NULL);
			}
		}
	}
	{
		GList* s_collection;
		GList* s_it;
		s_collection = argv_extra;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			const char* _tmp8;
			char* s;
			_tmp8 = NULL;
			s = (_tmp8 = (const char*) s_it->data, (_tmp8 == NULL) ? NULL : g_strdup (_tmp8));
			{
				const char* _tmp7;
				_tmp7 = NULL;
				argv = g_list_append (argv, (_tmp7 = s, (_tmp7 == NULL) ? NULL : g_strdup (_tmp7)));
				s = (g_free (s), NULL);
			}
		}
	}
	{
		GList* s_collection;
		GList* s_it;
		s_collection = self->priv->backend_argv;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			const char* _tmp10;
			char* s;
			_tmp10 = NULL;
			s = (_tmp10 = (const char*) s_it->data, (_tmp10 == NULL) ? NULL : g_strdup (_tmp10));
			{
				const char* _tmp9;
				_tmp9 = NULL;
				argv = g_list_append (argv, (_tmp9 = s, (_tmp9 == NULL) ? NULL : g_strdup (_tmp9)));
				s = (g_free (s), NULL);
			}
		}
	}
	if (argv_entire == NULL) {
		/* add operation, local, and remote args*/
		switch (self->priv->_mode) {
			case DEJA_DUP_OPERATION_MODE_BACKUP:
			{
				const char* _tmp11;
				const char* _tmp12;
				_tmp11 = NULL;
				argv = g_list_append (argv, (_tmp11 = local_arg, (_tmp11 == NULL) ? NULL : g_strdup (_tmp11)));
				_tmp12 = NULL;
				argv = g_list_append (argv, (_tmp12 = self->priv->remote, (_tmp12 == NULL) ? NULL : g_strdup (_tmp12)));
				break;
			}
			case DEJA_DUP_OPERATION_MODE_RESTORE:
			{
				const char* _tmp13;
				const char* _tmp14;
				argv = g_list_prepend (argv, g_strdup ("restore"));
				_tmp13 = NULL;
				argv = g_list_append (argv, (_tmp13 = self->priv->remote, (_tmp13 == NULL) ? NULL : g_strdup (_tmp13)));
				_tmp14 = NULL;
				argv = g_list_append (argv, (_tmp14 = local_arg, (_tmp14 == NULL) ? NULL : g_strdup (_tmp14)));
				break;
			}
			case DEJA_DUP_OPERATION_MODE_STATUS:
			{
				const char* _tmp15;
				argv = g_list_prepend (argv, g_strdup ("collection-status"));
				_tmp15 = NULL;
				argv = g_list_append (argv, (_tmp15 = self->priv->remote, (_tmp15 == NULL) ? NULL : g_strdup (_tmp15)));
				break;
			}
		}
	}
	envp = NULL;
	{
		GList* s_collection;
		GList* s_it;
		s_collection = self->priv->saved_envp;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			const char* _tmp17;
			char* s;
			_tmp17 = NULL;
			s = (_tmp17 = (const char*) s_it->data, (_tmp17 == NULL) ? NULL : g_strdup (_tmp17));
			{
				const char* _tmp16;
				_tmp16 = NULL;
				envp = g_list_append (envp, (_tmp16 = s, (_tmp16 == NULL) ? NULL : g_strdup (_tmp16)));
				s = (g_free (s), NULL);
			}
		}
	}
	{
		GList* s_collection;
		GList* s_it;
		s_collection = envp_extra;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			const char* _tmp19;
			char* s;
			_tmp19 = NULL;
			s = (_tmp19 = (const char*) s_it->data, (_tmp19 == NULL) ? NULL : g_strdup (_tmp19));
			{
				const char* _tmp18;
				_tmp18 = NULL;
				envp = g_list_append (envp, (_tmp18 = s, (_tmp18 == NULL) ? NULL : g_strdup (_tmp18)));
				s = (g_free (s), NULL);
			}
		}
	}
	{
		deja_dup_duplicity_instance_start (self->priv->inst, argv, envp, &inner_error);
		if (inner_error != NULL) {
			goto __catch4_g_error;
			goto __finally4;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			deja_dup_duplicity_show_error (self, e->message);
			g_signal_emit_by_name (self, "done", FALSE, FALSE);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally4:
	if (inner_error != NULL) {
		(argv == NULL) ? NULL : (argv = (_g_list_free_g_free (argv), NULL));
		(envp == NULL) ? NULL : (envp = (_g_list_free_g_free (envp), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	(argv == NULL) ? NULL : (argv = (_g_list_free_g_free (argv), NULL));
	(envp == NULL) ? NULL : (envp = (_g_list_free_g_free (envp), NULL));
}


GtkWindow* deja_dup_duplicity_get_toplevel (DejaDupDuplicity* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_toplevel;
}


static void deja_dup_duplicity_set_toplevel (DejaDupDuplicity* self, GtkWindow* value) {
	GtkWindow* _tmp2;
	GtkWindow* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_toplevel = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_toplevel == NULL) ? NULL : (self->priv->_toplevel = (g_object_unref (self->priv->_toplevel), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "toplevel");
}


DejaDupOperationMode deja_dup_duplicity_get_mode (DejaDupDuplicity* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_mode;
}


static void deja_dup_duplicity_set_mode (DejaDupDuplicity* self, DejaDupOperationMode value) {
	g_return_if_fail (self != NULL);
	self->priv->_mode = value;
	g_object_notify ((GObject *) self, "mode");
}


gboolean deja_dup_duplicity_get_error_issued (DejaDupDuplicity* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_error_issued;
}


static void deja_dup_duplicity_set_error_issued (DejaDupDuplicity* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_error_issued = value;
	g_object_notify ((GObject *) self, "error-issued");
}


const char* deja_dup_duplicity_get_local (DejaDupDuplicity* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_local;
}


void deja_dup_duplicity_set_local (DejaDupDuplicity* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_local = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_local = (g_free (self->priv->_local), NULL), _tmp2);
	g_object_notify ((GObject *) self, "local");
}


DejaDupBackend* deja_dup_duplicity_get_backend (DejaDupDuplicity* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_backend;
}


void deja_dup_duplicity_set_backend (DejaDupDuplicity* self, DejaDupBackend* value) {
	DejaDupBackend* _tmp2;
	DejaDupBackend* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_backend = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_backend == NULL) ? NULL : (self->priv->_backend = (g_object_unref (self->priv->_backend), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "backend");
}


GList* deja_dup_duplicity_get_restore_files (DejaDupDuplicity* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_restore_files;
}


void deja_dup_duplicity_set_restore_files (DejaDupDuplicity* self, GList* value) {
	GList* _tmp2;
	g_return_if_fail (self != NULL);
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->priv->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp1;
			GFile* f;
			_tmp1 = NULL;
			f = (_tmp1 = (GFile*) f_it->data, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
			{
				g_object_unref ((GObject*) f);
				(f == NULL) ? NULL : (f = (g_object_unref (f), NULL));
			}
		}
	}
	_tmp2 = NULL;
	self->priv->_restore_files = (_tmp2 = g_list_copy (value), (self->priv->_restore_files == NULL) ? NULL : (self->priv->_restore_files = (_g_list_free_g_object_unref (self->priv->_restore_files), NULL)), _tmp2);
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->priv->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp3;
			GFile* f;
			_tmp3 = NULL;
			f = (_tmp3 = (GFile*) f_it->data, (_tmp3 == NULL) ? NULL : g_object_ref (_tmp3));
			{
				g_object_ref ((GObject*) f);
				(f == NULL) ? NULL : (f = (g_object_unref (f), NULL));
			}
		}
	}
	g_object_notify ((GObject *) self, "restore-files");
}


DejaDupDuplicityState deja_dup_duplicity_get_state (DejaDupDuplicity* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_state;
}


void deja_dup_duplicity_set_state (DejaDupDuplicity* self, DejaDupDuplicityState value) {
	g_return_if_fail (self != NULL);
	self->priv->_state = value;
	g_object_notify ((GObject *) self, "state");
}


static void deja_dup_duplicity_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupDuplicity * self;
	gpointer boxed;
	self = DEJA_DUP_DUPLICITY (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_TOPLEVEL:
		g_value_set_object (value, deja_dup_duplicity_get_toplevel (self));
		break;
		case DEJA_DUP_DUPLICITY_MODE:
		g_value_set_enum (value, deja_dup_duplicity_get_mode (self));
		break;
		case DEJA_DUP_DUPLICITY_ERROR_ISSUED:
		g_value_set_boolean (value, deja_dup_duplicity_get_error_issued (self));
		break;
		case DEJA_DUP_DUPLICITY_LOCAL:
		g_value_set_string (value, deja_dup_duplicity_get_local (self));
		break;
		case DEJA_DUP_DUPLICITY_BACKEND:
		g_value_set_object (value, deja_dup_duplicity_get_backend (self));
		break;
		case DEJA_DUP_DUPLICITY_RESTORE_FILES:
		g_value_set_pointer (value, deja_dup_duplicity_get_restore_files (self));
		break;
		case DEJA_DUP_DUPLICITY_STATE:
		g_value_set_enum (value, deja_dup_duplicity_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_duplicity_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupDuplicity * self;
	self = DEJA_DUP_DUPLICITY (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_TOPLEVEL:
		deja_dup_duplicity_set_toplevel (self, g_value_get_object (value));
		break;
		case DEJA_DUP_DUPLICITY_MODE:
		deja_dup_duplicity_set_mode (self, g_value_get_enum (value));
		break;
		case DEJA_DUP_DUPLICITY_ERROR_ISSUED:
		deja_dup_duplicity_set_error_issued (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_LOCAL:
		deja_dup_duplicity_set_local (self, g_value_get_string (value));
		break;
		case DEJA_DUP_DUPLICITY_BACKEND:
		deja_dup_duplicity_set_backend (self, g_value_get_object (value));
		break;
		case DEJA_DUP_DUPLICITY_RESTORE_FILES:
		deja_dup_duplicity_set_restore_files (self, g_value_get_pointer (value));
		break;
		case DEJA_DUP_DUPLICITY_STATE:
		deja_dup_duplicity_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_duplicity_class_init (DejaDupDuplicityClass * klass) {
	deja_dup_duplicity_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupDuplicityPrivate));
	G_OBJECT_CLASS (klass)->get_property = deja_dup_duplicity_get_property;
	G_OBJECT_CLASS (klass)->set_property = deja_dup_duplicity_set_property;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_duplicity_finalize;
	DEJA_DUP_DUPLICITY_CLASS (klass)->start = deja_dup_duplicity_real_start;
	DEJA_DUP_DUPLICITY_CLASS (klass)->process_error = deja_dup_duplicity_real_process_error;
	DEJA_DUP_DUPLICITY_CLASS (klass)->process_info = deja_dup_duplicity_real_process_info;
	DEJA_DUP_DUPLICITY_CLASS (klass)->process_warning = deja_dup_duplicity_real_process_warning;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_TOPLEVEL, g_param_spec_object ("toplevel", "toplevel", "toplevel", GTK_TYPE_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_MODE, g_param_spec_enum ("mode", "mode", "mode", DEJA_DUP_OPERATION_TYPE_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_ERROR_ISSUED, g_param_spec_boolean ("error-issued", "error-issued", "error-issued", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_LOCAL, g_param_spec_string ("local", "local", "local", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_BACKEND, g_param_spec_object ("backend", "backend", "backend", DEJA_DUP_TYPE_BACKEND, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_RESTORE_FILES, g_param_spec_pointer ("restore-files", "restore-files", "restore-files", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_STATE, g_param_spec_enum ("state", "state", "state", DEJA_DUP_DUPLICITY_TYPE_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("done", DEJA_DUP_TYPE_DUPLICITY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
	g_signal_new ("raise_error", DEJA_DUP_TYPE_DUPLICITY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	g_signal_new ("action_desc_changed", DEJA_DUP_TYPE_DUPLICITY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("action_file_changed", DEJA_DUP_TYPE_DUPLICITY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_FILE);
	g_signal_new ("progress", DEJA_DUP_TYPE_DUPLICITY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
	g_signal_new ("collection_dates", DEJA_DUP_TYPE_DUPLICITY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
}


static void deja_dup_duplicity_instance_init (DejaDupDuplicity * self) {
	self->priv = DEJA_DUP_DUPLICITY_GET_PRIVATE (self);
	self->priv->_error_issued = FALSE;
	self->priv->has_progress_total = FALSE;
}


static void deja_dup_duplicity_finalize (GObject* obj) {
	DejaDupDuplicity * self;
	self = DEJA_DUP_DUPLICITY (obj);
	(self->priv->_toplevel == NULL) ? NULL : (self->priv->_toplevel = (g_object_unref (self->priv->_toplevel), NULL));
	self->priv->_local = (g_free (self->priv->_local), NULL);
	(self->priv->_backend == NULL) ? NULL : (self->priv->_backend = (g_object_unref (self->priv->_backend), NULL));
	(self->priv->_restore_files == NULL) ? NULL : (self->priv->_restore_files = (_g_list_free_g_object_unref (self->priv->_restore_files), NULL));
	(self->priv->inst == NULL) ? NULL : (self->priv->inst = (g_object_unref (self->priv->inst), NULL));
	self->priv->remote = (g_free (self->priv->remote), NULL);
	(self->priv->backend_argv == NULL) ? NULL : (self->priv->backend_argv = (_g_list_free_g_free (self->priv->backend_argv), NULL));
	(self->priv->saved_argv == NULL) ? NULL : (self->priv->saved_argv = (_g_list_free_g_free (self->priv->saved_argv), NULL));
	(self->priv->saved_envp == NULL) ? NULL : (self->priv->saved_envp = (_g_list_free_g_free (self->priv->saved_envp), NULL));
	G_OBJECT_CLASS (deja_dup_duplicity_parent_class)->finalize (obj);
}


GType deja_dup_duplicity_get_type (void) {
	static GType deja_dup_duplicity_type_id = 0;
	if (deja_dup_duplicity_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupDuplicityClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_duplicity_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupDuplicity), 0, (GInstanceInitFunc) deja_dup_duplicity_instance_init, NULL };
		deja_dup_duplicity_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupDuplicity", &g_define_type_info, 0);
	}
	return deja_dup_duplicity_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (gpointer data1, gboolean arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}



