/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include <OperationRestore.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gconf/gconf-client.h>
#include <glib/gstdio.h>
#include <RecursiveMove.h>
#include <RecursiveOp.h>
#include <RecursiveDelete.h>




struct _DejaDupOperationRestorePrivate {
	char* dest;
	char* time;
	char* source;
	GList* errors;
	GList* _restore_files;
};

#define DEJA_DUP_OPERATION_RESTORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_OPERATION_RESTORE, DejaDupOperationRestorePrivate))
enum  {
	DEJA_DUP_OPERATION_RESTORE_DUMMY_PROPERTY,
	DEJA_DUP_OPERATION_RESTORE_RESTORE_FILES
};
static void _g_list_free_g_free (GList* self);
static void _g_list_free_g_object_unref (GList* self);
static void deja_dup_operation_restore_real_start (DejaDupOperation* base, GError** error);
static GList* deja_dup_operation_restore_real_make_argv (DejaDupOperation* base, GError** error);
static void deja_dup_operation_restore_real_operation_finished (DejaDupOperation* base, DejaDupDuplicity* dup, gboolean success, gboolean cancelled);
static void deja_dup_operation_restore_fixup_home_dir (DejaDupOperationRestore* self);
static void deja_dup_operation_restore_show_errors (DejaDupOperationRestore* self);
static void deja_dup_operation_restore_add_error (DejaDupOperationRestore* self, const char* relpath, const char* errstr);
static void deja_dup_operation_restore_mv_error (DejaDupOperationRestore* self, DejaDupRecursiveMove* move, GFile* src, GFile* dst, const char* errstr);
static void _deja_dup_operation_restore_mv_error_deja_dup_recursive_op_raise_error (DejaDupRecursiveMove* _sender, GFile* src, GFile* dst, const char* errstr, gpointer self);
static gboolean deja_dup_operation_restore_mv_source_to_dest (DejaDupOperationRestore* self);
static void deja_dup_operation_restore_cleanup_source (DejaDupOperationRestore* self);
static gpointer deja_dup_operation_restore_parent_class = NULL;
static void deja_dup_operation_restore_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


DejaDupOperationRestore* deja_dup_operation_restore_construct (GType object_type, GtkWindow* win, const char* dest_in, const char* time_in, GList* files_in, guint xid) {
	GParameter * __params;
	GParameter * __params_it;
	DejaDupOperationRestore * self;
	char* _tmp1;
	const char* _tmp0;
	char* _tmp3;
	const char* _tmp2;
	g_return_val_if_fail (dest_in != NULL, NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	__params_it->name = "toplevel";
	g_value_init (&__params_it->value, GTK_TYPE_WINDOW);
	g_value_set_object (&__params_it->value, win);
	__params_it++;
	__params_it->name = "uppermost-xid";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, xid);
	__params_it++;
	__params_it->name = "mode";
	g_value_init (&__params_it->value, DEJA_DUP_OPERATION_TYPE_MODE);
	g_value_set_enum (&__params_it->value, DEJA_DUP_OPERATION_MODE_RESTORE);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->dest = (_tmp1 = (_tmp0 = dest_in, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), self->priv->dest = (g_free (self->priv->dest), NULL), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->time = (_tmp3 = (_tmp2 = time_in, (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), self->priv->time = (g_free (self->priv->time), NULL), _tmp3);
	deja_dup_operation_restore_set_restore_files (self, files_in);
	deja_dup_duplicity_set_restore_files (((DejaDupOperation*) self)->dup, deja_dup_operation_restore_get_restore_files (self));
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DejaDupOperationRestore* deja_dup_operation_restore_new (GtkWindow* win, const char* dest_in, const char* time_in, GList* files_in, guint xid) {
	return deja_dup_operation_restore_construct (DEJA_DUP_TYPE_OPERATION_RESTORE, win, dest_in, time_in, files_in, xid);
}


static void deja_dup_operation_restore_real_start (DejaDupOperation* base, GError** error) {
	DejaDupOperationRestore * self;
	GError * inner_error;
	self = (DejaDupOperationRestore*) base;
	inner_error = NULL;
	g_signal_emit_by_name ((DejaDupOperation*) self, "action-desc-changed", _ ("Restoring files..."));
	DEJA_DUP_OPERATION_CLASS (deja_dup_operation_restore_parent_class)->start (DEJA_DUP_OPERATION (self), &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
}


static GList* deja_dup_operation_restore_real_make_argv (DejaDupOperation* base, GError** error) {
	DejaDupOperationRestore * self;
	GConfClient* _tmp0;
	GConfClient* client;
	char* _tmp1;
	char* _tmp3;
	const char* _tmp2;
	GList* argv;
	GList* _tmp4;
	self = (DejaDupOperationRestore*) base;
	_tmp0 = NULL;
	client = (_tmp0 = gconf_client_get_default (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	_tmp1 = NULL;
	self->priv->source = (_tmp1 = g_build_filename (g_get_tmp_dir (), "deja-dup-XXXXXX", NULL), self->priv->source = (g_free (self->priv->source), NULL), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->source = (_tmp3 = (_tmp2 = mkdtemp (self->priv->source), (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), self->priv->source = (g_free (self->priv->source), NULL), _tmp3);
	argv = NULL;
	if (self->priv->time != NULL) {
		argv = g_list_append (argv, g_strdup_printf ("--restore-time=%s", self->priv->time));
	}
	deja_dup_duplicity_set_local (((DejaDupOperation*) self)->dup, self->priv->source);
	_tmp4 = NULL;
	return (_tmp4 = argv, (client == NULL) ? NULL : (client = (g_object_unref (client), NULL)), _tmp4);
}


static void deja_dup_operation_restore_real_operation_finished (DejaDupOperation* base, DejaDupDuplicity* dup, gboolean success, gboolean cancelled) {
	DejaDupOperationRestore * self;
	self = (DejaDupOperationRestore*) base;
	g_return_if_fail (dup != NULL);
	if (success) {
		deja_dup_operation_restore_fixup_home_dir (self);
		if (!deja_dup_operation_restore_mv_source_to_dest (self)) {
			success = FALSE;
		}
	} else {
		if (!cancelled) {
		} else {
			deja_dup_operation_restore_cleanup_source (self);
		}
	}
	DEJA_DUP_OPERATION_CLASS (deja_dup_operation_restore_parent_class)->operation_finished (DEJA_DUP_OPERATION (self), dup, success, cancelled);
}


/**
   * The idea here is to cover the following scenario:
   *   I backup my machine as user 'bob'
   *   I recover on another machine as user 'robert'
   * For the simple case (one home dir), we can note this and correct it.
   * We even cover the case of having backed up as root, and having a home dir
   * of /root.
   * 
   * This rejiggering is all done inside the source directory before we move it
   * to its destination.
   */
static void deja_dup_operation_restore_fixup_home_dir (DejaDupOperationRestore* self) {
	GError * inner_error;
	char* ideal_home;
	char* current_home;
	char* strd;
	GDir* d;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	ideal_home = g_build_filename (self->priv->source, g_get_home_dir (), NULL);
	if (g_file_test (ideal_home, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR)) {
		ideal_home = (g_free (ideal_home), NULL);
		return;
	}
	/* We check if there is only one /home/XXXXXX directory in restored files.
	 If so, we make sure it matches current user directory.*/
	current_home = NULL;
	strd = g_build_filename (self->priv->source, "home", NULL);
	d = NULL;
	{
		GDir* _tmp0;
		GDir* _tmp1;
		_tmp0 = g_dir_open (strd, 0, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_FILE_ERROR) {
				goto __catch15_g_file_error;
			}
			goto __finally15;
		}
		_tmp1 = NULL;
		d = (_tmp1 = _tmp0, (d == NULL) ? NULL : (d = (g_dir_close (d), NULL)), _tmp1);
	}
	goto __finally15;
	__catch15_g_file_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			GDir* _tmp2;
			_tmp2 = NULL;
			d = (_tmp2 = NULL, (d == NULL) ? NULL : (d = (g_dir_close (d), NULL)), _tmp2);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally15:
	if (inner_error != NULL) {
		ideal_home = (g_free (ideal_home), NULL);
		current_home = (g_free (current_home), NULL);
		strd = (g_free (strd), NULL);
		(d == NULL) ? NULL : (d = (g_dir_close (d), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	if (d != NULL) {
		const char* _tmp3;
		char* child;
		const char* end;
		_tmp3 = NULL;
		child = (_tmp3 = g_dir_read_name (d), (_tmp3 == NULL) ? NULL : g_strdup (_tmp3));
		end = g_dir_read_name (d);
		if (end != NULL) {
			child = (g_free (child), NULL);
			ideal_home = (g_free (ideal_home), NULL);
			current_home = (g_free (current_home), NULL);
			strd = (g_free (strd), NULL);
			(d == NULL) ? NULL : (d = (g_dir_close (d), NULL));
			return;
		}
		/* more than one home dir, we don't know which they want*/
		if (child != NULL) {
			char* _tmp4;
			/* exactly one home dir, will rename*/
			_tmp4 = NULL;
			current_home = (_tmp4 = g_build_filename (strd, child, NULL), current_home = (g_free (current_home), NULL), _tmp4);
			if (!g_file_test (current_home, G_FILE_TEST_IS_DIR)) {
				char* _tmp5;
				_tmp5 = NULL;
				current_home = (_tmp5 = NULL, current_home = (g_free (current_home), NULL), _tmp5);
			}
		}
		child = (g_free (child), NULL);
	}
	if (current_home == NULL) {
		char* _tmp6;
		/* hmm, no home dirs...  Check /root*/
		_tmp6 = NULL;
		current_home = (_tmp6 = g_build_filename (self->priv->source, "root", NULL), current_home = (g_free (current_home), NULL), _tmp6);
		if (!g_file_test (current_home, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR)) {
			char* _tmp7;
			_tmp7 = NULL;
			current_home = (_tmp7 = NULL, current_home = (g_free (current_home), NULL), _tmp7);
		}
	}
	if (current_home != NULL) {
		char* dirname;
		/* Ideal home may not have all parents ("/home" part) yet*/
		dirname = g_path_get_dirname (ideal_home);
		g_mkdir_with_parents (dirname, 0755);
		g_rename (current_home, ideal_home);
		dirname = (g_free (dirname), NULL);
	}
	ideal_home = (g_free (ideal_home), NULL);
	current_home = (g_free (current_home), NULL);
	strd = (g_free (strd), NULL);
	(d == NULL) ? NULL : (d = (g_dir_close (d), NULL));
}


static void deja_dup_operation_restore_show_errors (DejaDupOperationRestore* self) {
	guint len;
	char* detail;
	char* error_text;
	g_return_if_fail (self != NULL);
	/* Various file errors piled up as we restored everything to its rightful
	 place.  Show them as a big ol' list, and let the user know that
	 they can still get the files in /tmp.*/
	len = g_list_length (self->priv->errors);
	detail = NULL;
	if (len > 1) {
		char** _tmp0;
		gint error_array_size;
		gint error_array_length1;
		char** error_array;
		gint i;
		char* _tmp5;
		char* _tmp6;
		_tmp0 = NULL;
		error_array = (_tmp0 = g_new0 (char*, (len + 1) + 1), error_array_length1 = len + 1, error_array_size = error_array_length1, _tmp0);
		i = 0;
		{
			GList* err_collection;
			GList* err_it;
			err_collection = self->priv->errors;
			for (err_it = err_collection; err_it != NULL; err_it = err_it->next) {
				const char* _tmp4;
				char* err;
				_tmp4 = NULL;
				err = (_tmp4 = (const char*) err_it->data, (_tmp4 == NULL) ? NULL : g_strdup (_tmp4));
				{
					gint _tmp3;
					char* _tmp2;
					const char* _tmp1;
					_tmp2 = NULL;
					_tmp1 = NULL;
					_tmp3 = i++;
					error_array[_tmp3] = (_tmp2 = (_tmp1 = err, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), error_array[_tmp3] = (g_free (error_array[_tmp3]), NULL), _tmp2);
					err = (g_free (err), NULL);
				}
			}
		}
		_tmp5 = NULL;
		error_array[i] = (_tmp5 = NULL, error_array[i] = (g_free (error_array[i]), NULL), _tmp5);
		_tmp6 = NULL;
		detail = (_tmp6 = g_strjoinv ("\n\n", error_array), detail = (g_free (detail), NULL), _tmp6);
		error_array = (_vala_array_free (error_array, error_array_length1, (GDestroyNotify) g_free), NULL);
	}
	error_text = g_strdup_printf (_ ("Not all files could be restored. Any files that could not be restored may still be found in %s."), self->priv->source);
	if (detail == NULL) {
		char* _tmp8;
		char* _tmp7;
		_tmp8 = NULL;
		_tmp7 = NULL;
		error_text = (_tmp8 = g_strconcat (error_text, _tmp7 = (g_strconcat ("\n\n", (const char*) self->priv->errors->data, NULL)), NULL), error_text = (g_free (error_text), NULL), _tmp8);
		_tmp7 = (g_free (_tmp7), NULL);
	}
	g_signal_emit_by_name ((DejaDupOperation*) self, "raise-error", error_text, detail);
	detail = (g_free (detail), NULL);
	error_text = (g_free (error_text), NULL);
}


static void deja_dup_operation_restore_add_error (DejaDupOperationRestore* self, const char* relpath, const char* errstr) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (relpath != NULL);
	g_return_if_fail (errstr != NULL);
	self->priv->errors = g_list_append (self->priv->errors, g_strdup_printf (_ ("Could not restore %s: %s"), relpath, errstr));
}


static void deja_dup_operation_restore_mv_error (DejaDupOperationRestore* self, DejaDupRecursiveMove* move, GFile* src, GFile* dst, const char* errstr) {
	GFile* dest_top;
	char* relative_dst;
	gboolean _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (move != NULL);
	g_return_if_fail (src != NULL);
	g_return_if_fail (dst != NULL);
	g_return_if_fail (errstr != NULL);
	dest_top = g_file_new_for_path (self->priv->dest);
	relative_dst = g_file_get_relative_path (dest_top, dst);
	_tmp0 = FALSE;
	if (relative_dst == NULL) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = _vala_strcmp0 (relative_dst, "") == 0;
	}
	if (_tmp0) {
		char* _tmp2;
		const char* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		relative_dst = (_tmp2 = (_tmp1 = self->priv->dest, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), relative_dst = (g_free (relative_dst), NULL), _tmp2);
	}
	deja_dup_operation_restore_add_error (self, relative_dst, errstr);
	(dest_top == NULL) ? NULL : (dest_top = (g_object_unref (dest_top), NULL));
	relative_dst = (g_free (relative_dst), NULL);
}


static void _deja_dup_operation_restore_mv_error_deja_dup_recursive_op_raise_error (DejaDupRecursiveMove* _sender, GFile* src, GFile* dst, const char* errstr, gpointer self) {
	deja_dup_operation_restore_mv_error (self, _sender, src, dst, errstr);
}


static gboolean deja_dup_operation_restore_mv_source_to_dest (DejaDupOperationRestore* self) {
	GList* _tmp0;
	GFile* destf;
	GFile* sourcef;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0 = NULL;
	self->priv->errors = (_tmp0 = NULL, (self->priv->errors == NULL) ? NULL : (self->priv->errors = (_g_list_free_g_free (self->priv->errors), NULL)), _tmp0);
	destf = g_file_new_for_path (self->priv->dest);
	sourcef = g_file_new_for_path (self->priv->source);
	/* If we're doing a full restore, just move the whole thing over.
	 But if we asked duplicity to restore specific files, it created
	 the parent directories itself without making sure they have the same
	 permissions as the directories in the backup.  So we go and specifically
	 move each of the specific files over, ignoring their parent directories.*/
	if (deja_dup_operation_restore_get_restore_files (self) == NULL) {
		DejaDupRecursiveMove* move;
		move = deja_dup_recursive_move_new (sourcef, destf);
		g_signal_connect_object ((DejaDupRecursiveOp*) move, "raise-error", (GCallback) _deja_dup_operation_restore_mv_error_deja_dup_recursive_op_raise_error, self, 0);
		deja_dup_recursive_op_start ((DejaDupRecursiveOp*) move);
		(move == NULL) ? NULL : (move = (g_object_unref (move), NULL));
	} else {
		GFile* root;
		root = g_file_new_for_path ("/");
		{
			GList* f_collection;
			GList* f_it;
			f_collection = deja_dup_operation_restore_get_restore_files (self);
			for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
				GFile* _tmp1;
				GFile* f;
				_tmp1 = NULL;
				f = (_tmp1 = (GFile*) f_it->data, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
				{
					char* rel_file_path;
					GFile* full_source;
					GFile* full_dest;
					DejaDupRecursiveMove* move;
					rel_file_path = g_file_get_relative_path (root, f);
					full_source = g_file_resolve_relative_path (sourcef, rel_file_path);
					full_dest = g_file_resolve_relative_path (destf, rel_file_path);
					move = deja_dup_recursive_move_new (full_source, full_dest);
					g_signal_connect_object ((DejaDupRecursiveOp*) move, "raise-error", (GCallback) _deja_dup_operation_restore_mv_error_deja_dup_recursive_op_raise_error, self, 0);
					deja_dup_recursive_op_start ((DejaDupRecursiveOp*) move);
					(f == NULL) ? NULL : (f = (g_object_unref (f), NULL));
					rel_file_path = (g_free (rel_file_path), NULL);
					(full_source == NULL) ? NULL : (full_source = (g_object_unref (full_source), NULL));
					(full_dest == NULL) ? NULL : (full_dest = (g_object_unref (full_dest), NULL));
					(move == NULL) ? NULL : (move = (g_object_unref (move), NULL));
				}
			}
		}
		(root == NULL) ? NULL : (root = (g_object_unref (root), NULL));
	}
	if (self->priv->errors != NULL) {
		gboolean _tmp2;
		deja_dup_operation_restore_show_errors (self);
		return (_tmp2 = FALSE, (destf == NULL) ? NULL : (destf = (g_object_unref (destf), NULL)), (sourcef == NULL) ? NULL : (sourcef = (g_object_unref (sourcef), NULL)), _tmp2);
	} else {
		gboolean _tmp3;
		return (_tmp3 = TRUE, (destf == NULL) ? NULL : (destf = (g_object_unref (destf), NULL)), (sourcef == NULL) ? NULL : (sourcef = (g_object_unref (sourcef), NULL)), _tmp3);
	}
	(destf == NULL) ? NULL : (destf = (g_object_unref (destf), NULL));
	(sourcef == NULL) ? NULL : (sourcef = (g_object_unref (sourcef), NULL));
}


static void deja_dup_operation_restore_cleanup_source (DejaDupOperationRestore* self) {
	GFile* sourcef;
	DejaDupRecursiveDelete* move;
	g_return_if_fail (self != NULL);
	sourcef = g_file_new_for_path (self->priv->source);
	move = deja_dup_recursive_delete_new (sourcef);
	deja_dup_recursive_op_start ((DejaDupRecursiveOp*) move);
	(sourcef == NULL) ? NULL : (sourcef = (g_object_unref (sourcef), NULL));
	(move == NULL) ? NULL : (move = (g_object_unref (move), NULL));
}


GList* deja_dup_operation_restore_get_restore_files (DejaDupOperationRestore* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_restore_files;
}


void deja_dup_operation_restore_set_restore_files (DejaDupOperationRestore* self, GList* value) {
	GList* _tmp2;
	g_return_if_fail (self != NULL);
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->priv->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp1;
			GFile* f;
			_tmp1 = NULL;
			f = (_tmp1 = (GFile*) f_it->data, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
			{
				g_object_unref ((GObject*) f);
				(f == NULL) ? NULL : (f = (g_object_unref (f), NULL));
			}
		}
	}
	_tmp2 = NULL;
	self->priv->_restore_files = (_tmp2 = g_list_copy (value), (self->priv->_restore_files == NULL) ? NULL : (self->priv->_restore_files = (_g_list_free_g_object_unref (self->priv->_restore_files), NULL)), _tmp2);
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->priv->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp3;
			GFile* f;
			_tmp3 = NULL;
			f = (_tmp3 = (GFile*) f_it->data, (_tmp3 == NULL) ? NULL : g_object_ref (_tmp3));
			{
				g_object_ref ((GObject*) f);
				(f == NULL) ? NULL : (f = (g_object_unref (f), NULL));
			}
		}
	}
	g_object_notify ((GObject *) self, "restore-files");
}


static void deja_dup_operation_restore_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupOperationRestore * self;
	gpointer boxed;
	self = DEJA_DUP_OPERATION_RESTORE (object);
	switch (property_id) {
		case DEJA_DUP_OPERATION_RESTORE_RESTORE_FILES:
		g_value_set_pointer (value, deja_dup_operation_restore_get_restore_files (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_operation_restore_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupOperationRestore * self;
	self = DEJA_DUP_OPERATION_RESTORE (object);
	switch (property_id) {
		case DEJA_DUP_OPERATION_RESTORE_RESTORE_FILES:
		deja_dup_operation_restore_set_restore_files (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_operation_restore_class_init (DejaDupOperationRestoreClass * klass) {
	deja_dup_operation_restore_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupOperationRestorePrivate));
	G_OBJECT_CLASS (klass)->get_property = deja_dup_operation_restore_get_property;
	G_OBJECT_CLASS (klass)->set_property = deja_dup_operation_restore_set_property;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_operation_restore_finalize;
	DEJA_DUP_OPERATION_CLASS (klass)->start = deja_dup_operation_restore_real_start;
	DEJA_DUP_OPERATION_CLASS (klass)->make_argv = deja_dup_operation_restore_real_make_argv;
	DEJA_DUP_OPERATION_CLASS (klass)->operation_finished = deja_dup_operation_restore_real_operation_finished;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_RESTORE_RESTORE_FILES, g_param_spec_pointer ("restore-files", "restore-files", "restore-files", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void deja_dup_operation_restore_instance_init (DejaDupOperationRestore * self) {
	self->priv = DEJA_DUP_OPERATION_RESTORE_GET_PRIVATE (self);
}


static void deja_dup_operation_restore_finalize (GObject* obj) {
	DejaDupOperationRestore * self;
	self = DEJA_DUP_OPERATION_RESTORE (obj);
	self->priv->dest = (g_free (self->priv->dest), NULL);
	self->priv->time = (g_free (self->priv->time), NULL);
	self->priv->source = (g_free (self->priv->source), NULL);
	(self->priv->errors == NULL) ? NULL : (self->priv->errors = (_g_list_free_g_free (self->priv->errors), NULL));
	(self->priv->_restore_files == NULL) ? NULL : (self->priv->_restore_files = (_g_list_free_g_object_unref (self->priv->_restore_files), NULL));
	G_OBJECT_CLASS (deja_dup_operation_restore_parent_class)->finalize (obj);
}


GType deja_dup_operation_restore_get_type (void) {
	static GType deja_dup_operation_restore_type_id = 0;
	if (deja_dup_operation_restore_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupOperationRestoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_operation_restore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupOperationRestore), 0, (GInstanceInitFunc) deja_dup_operation_restore_instance_init, NULL };
		deja_dup_operation_restore_type_id = g_type_register_static (DEJA_DUP_TYPE_OPERATION, "DejaDupOperationRestore", &g_define_type_info, 0);
	}
	return deja_dup_operation_restore_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




