/* -*- Mode: C; indent-tabs-mode: nil; tab-width: 2 -*- */

#include <RecursiveMove.h>
#include <stdlib.h>
#include <string.h>




enum  {
	DEJA_DUP_RECURSIVE_MOVE_DUMMY_PROPERTY
};
static void deja_dup_recursive_move_progress_callback (DejaDupRecursiveMove* self, gint64 current_num_bytes, gint64 total_num_bytes);
static void _deja_dup_recursive_move_progress_callback_gfile_progress_callback (gint64 current_num_bytes, gint64 total_num_bytes, gpointer self);
static void deja_dup_recursive_move_real_handle_file (DejaDupRecursiveOp* base);
static void deja_dup_recursive_move_real_handle_dir (DejaDupRecursiveOp* base);
static void deja_dup_recursive_move_real_finish_dir (DejaDupRecursiveOp* base);
static DejaDupRecursiveOp* deja_dup_recursive_move_real_clone_for_info (DejaDupRecursiveOp* base, GFileInfo* info);
static gpointer deja_dup_recursive_move_parent_class = NULL;



DejaDupRecursiveMove* deja_dup_recursive_move_construct (GType object_type, GFile* source, GFile* dest) {
	GParameter * __params;
	GParameter * __params_it;
	DejaDupRecursiveMove * self;
	g_return_val_if_fail (source != NULL, NULL);
	g_return_val_if_fail (dest != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "src";
	g_value_init (&__params_it->value, G_TYPE_FILE);
	g_value_set_object (&__params_it->value, source);
	__params_it++;
	__params_it->name = "dst";
	g_value_init (&__params_it->value, G_TYPE_FILE);
	g_value_set_object (&__params_it->value, dest);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DejaDupRecursiveMove* deja_dup_recursive_move_new (GFile* source, GFile* dest) {
	return deja_dup_recursive_move_construct (DEJA_DUP_TYPE_RECURSIVE_MOVE, source, dest);
}


static void deja_dup_recursive_move_progress_callback (DejaDupRecursiveMove* self, gint64 current_num_bytes, gint64 total_num_bytes) {
	g_return_if_fail (self != NULL);
}


static void _deja_dup_recursive_move_progress_callback_gfile_progress_callback (gint64 current_num_bytes, gint64 total_num_bytes, gpointer self) {
	deja_dup_recursive_move_progress_callback (self, current_num_bytes, total_num_bytes);
}


/* Do nothing right now*/
static void deja_dup_recursive_move_real_handle_file (DejaDupRecursiveOp* base) {
	DejaDupRecursiveMove * self;
	GError * inner_error;
	self = (DejaDupRecursiveMove*) base;
	inner_error = NULL;
	if (((DejaDupRecursiveOp*) self)->dst_type == G_FILE_TYPE_DIRECTORY) {
		{
			g_file_delete (deja_dup_recursive_op_get_dst ((DejaDupRecursiveOp*) self), NULL, &inner_error);
			if (inner_error != NULL) {
				goto __catch18_g_error;
				goto __finally18;
			}
		}
		goto __finally18;
		__catch18_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_signal_emit_by_name ((DejaDupRecursiveOp*) self, "raise-error", deja_dup_recursive_op_get_src ((DejaDupRecursiveOp*) self), deja_dup_recursive_op_get_dst ((DejaDupRecursiveOp*) self), e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
				return;
			}
		}
		__finally18:
		if (inner_error != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
	}
	{
		g_file_move (deja_dup_recursive_op_get_src ((DejaDupRecursiveOp*) self), deja_dup_recursive_op_get_dst ((DejaDupRecursiveOp*) self), (G_FILE_COPY_ALL_METADATA | G_FILE_COPY_NOFOLLOW_SYMLINKS) | G_FILE_COPY_OVERWRITE, NULL, _deja_dup_recursive_move_progress_callback_gfile_progress_callback, self, &inner_error);
		if (inner_error != NULL) {
			goto __catch19_g_error;
			goto __finally19;
		}
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_signal_emit_by_name ((DejaDupRecursiveOp*) self, "raise-error", deja_dup_recursive_op_get_src ((DejaDupRecursiveOp*) self), deja_dup_recursive_op_get_dst ((DejaDupRecursiveOp*) self), e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally19:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


static void deja_dup_recursive_move_real_handle_dir (DejaDupRecursiveOp* base) {
	DejaDupRecursiveMove * self;
	GError * inner_error;
	gboolean _tmp0;
	self = (DejaDupRecursiveMove*) base;
	inner_error = NULL;
	_tmp0 = FALSE;
	if (((DejaDupRecursiveOp*) self)->dst_type != G_FILE_TYPE_UNKNOWN) {
		_tmp0 = ((DejaDupRecursiveOp*) self)->dst_type != G_FILE_TYPE_DIRECTORY;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		{
			g_file_delete (deja_dup_recursive_op_get_dst ((DejaDupRecursiveOp*) self), NULL, &inner_error);
			if (inner_error != NULL) {
				goto __catch20_g_error;
				goto __finally20;
			}
		}
		goto __finally20;
		__catch20_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_signal_emit_by_name ((DejaDupRecursiveOp*) self, "raise-error", deja_dup_recursive_op_get_src ((DejaDupRecursiveOp*) self), deja_dup_recursive_op_get_dst ((DejaDupRecursiveOp*) self), e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
				return;
			}
		}
		__finally20:
		if (inner_error != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
		((DejaDupRecursiveOp*) self)->dst_type = G_FILE_TYPE_UNKNOWN;
	}
	/* now the file's gone*/
	if (((DejaDupRecursiveOp*) self)->dst_type == G_FILE_TYPE_UNKNOWN) {
		{
			g_file_make_directory (deja_dup_recursive_op_get_dst ((DejaDupRecursiveOp*) self), NULL, &inner_error);
			if (inner_error != NULL) {
				goto __catch21_g_error;
				goto __finally21;
			}
		}
		goto __finally21;
		__catch21_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_signal_emit_by_name ((DejaDupRecursiveOp*) self, "raise-error", deja_dup_recursive_op_get_src ((DejaDupRecursiveOp*) self), deja_dup_recursive_op_get_dst ((DejaDupRecursiveOp*) self), e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
				return;
			}
		}
		__finally21:
		if (inner_error != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
	}
	{
		g_file_copy_attributes (deja_dup_recursive_op_get_src ((DejaDupRecursiveOp*) self), deja_dup_recursive_op_get_dst ((DejaDupRecursiveOp*) self), G_FILE_COPY_NOFOLLOW_SYMLINKS | G_FILE_COPY_ALL_METADATA, NULL, &inner_error);
		if (inner_error != NULL) {
			goto __catch22_g_error;
			goto __finally22;
		}
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally22:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


/* If we fail, no big deal.  There'll often be stuff like /home that we
 can't change and don't care about changing.*/
static void deja_dup_recursive_move_real_finish_dir (DejaDupRecursiveOp* base) {
	DejaDupRecursiveMove * self;
	GError * inner_error;
	self = (DejaDupRecursiveMove*) base;
	inner_error = NULL;
	{
		g_file_delete (deja_dup_recursive_op_get_src ((DejaDupRecursiveOp*) self), NULL, &inner_error);
		if (inner_error != NULL) {
			goto __catch23_g_error;
			goto __finally23;
		}
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally23:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


/* will only be deleted if empty, so we won't
 accidentally toss files left over from a failed
 restore
 Ignore.  It's in /tmp, so it'll disappear, and most likely is just
 a non-empty directory.*/
static DejaDupRecursiveOp* deja_dup_recursive_move_real_clone_for_info (DejaDupRecursiveOp* base, GFileInfo* info) {
	DejaDupRecursiveMove * self;
	const char* _tmp0;
	char* child_name;
	GFile* src_child;
	GFile* dst_child;
	DejaDupRecursiveOp* _tmp1;
	self = (DejaDupRecursiveMove*) base;
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0 = NULL;
	child_name = (_tmp0 = g_file_info_get_name (info), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
	src_child = g_file_get_child (deja_dup_recursive_op_get_src ((DejaDupRecursiveOp*) self), child_name);
	dst_child = g_file_get_child (deja_dup_recursive_op_get_dst ((DejaDupRecursiveOp*) self), child_name);
	_tmp1 = NULL;
	return (_tmp1 = (DejaDupRecursiveOp*) deja_dup_recursive_move_new (src_child, dst_child), child_name = (g_free (child_name), NULL), (src_child == NULL) ? NULL : (src_child = (g_object_unref (src_child), NULL)), (dst_child == NULL) ? NULL : (dst_child = (g_object_unref (dst_child), NULL)), _tmp1);
}


static void deja_dup_recursive_move_class_init (DejaDupRecursiveMoveClass * klass) {
	deja_dup_recursive_move_parent_class = g_type_class_peek_parent (klass);
	DEJA_DUP_RECURSIVE_OP_CLASS (klass)->handle_file = deja_dup_recursive_move_real_handle_file;
	DEJA_DUP_RECURSIVE_OP_CLASS (klass)->handle_dir = deja_dup_recursive_move_real_handle_dir;
	DEJA_DUP_RECURSIVE_OP_CLASS (klass)->finish_dir = deja_dup_recursive_move_real_finish_dir;
	DEJA_DUP_RECURSIVE_OP_CLASS (klass)->clone_for_info = deja_dup_recursive_move_real_clone_for_info;
}


static void deja_dup_recursive_move_instance_init (DejaDupRecursiveMove * self) {
}


GType deja_dup_recursive_move_get_type (void) {
	static GType deja_dup_recursive_move_type_id = 0;
	if (deja_dup_recursive_move_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupRecursiveMoveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_recursive_move_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupRecursiveMove), 0, (GInstanceInitFunc) deja_dup_recursive_move_instance_init, NULL };
		deja_dup_recursive_move_type_id = g_type_register_static (DEJA_DUP_TYPE_RECURSIVE_OP, "DejaDupRecursiveMove", &g_define_type_info, 0);
	}
	return deja_dup_recursive_move_type_id;
}




