/* -*- Mode: C; indent-tabs-mode: nil; tab-width: 2 -*- */

#ifndef __RECURSIVEOP_H__
#define __RECURSIVEOP_H__

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define DEJA_DUP_TYPE_RECURSIVE_OP (deja_dup_recursive_op_get_type ())
#define DEJA_DUP_RECURSIVE_OP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_RECURSIVE_OP, DejaDupRecursiveOp))
#define DEJA_DUP_RECURSIVE_OP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_RECURSIVE_OP, DejaDupRecursiveOpClass))
#define DEJA_DUP_IS_RECURSIVE_OP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_RECURSIVE_OP))
#define DEJA_DUP_IS_RECURSIVE_OP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_RECURSIVE_OP))
#define DEJA_DUP_RECURSIVE_OP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_RECURSIVE_OP, DejaDupRecursiveOpClass))

typedef struct _DejaDupRecursiveOp DejaDupRecursiveOp;
typedef struct _DejaDupRecursiveOpClass DejaDupRecursiveOpClass;
typedef struct _DejaDupRecursiveOpPrivate DejaDupRecursiveOpPrivate;

struct _DejaDupRecursiveOp {
	GObject parent_instance;
	DejaDupRecursiveOpPrivate * priv;
	GFileType src_type;
	GFileType dst_type;
};

struct _DejaDupRecursiveOpClass {
	GObjectClass parent_class;
	void (*handle_file) (DejaDupRecursiveOp* self);
	void (*handle_dir) (DejaDupRecursiveOp* self);
	void (*finish_dir) (DejaDupRecursiveOp* self);
	DejaDupRecursiveOp* (*clone_for_info) (DejaDupRecursiveOp* self, GFileInfo* info);
};


void deja_dup_recursive_op_handle_file (DejaDupRecursiveOp* self);
void deja_dup_recursive_op_handle_dir (DejaDupRecursiveOp* self);
void deja_dup_recursive_op_finish_dir (DejaDupRecursiveOp* self);
DejaDupRecursiveOp* deja_dup_recursive_op_clone_for_info (DejaDupRecursiveOp* self, GFileInfo* info);
void deja_dup_recursive_op_start (DejaDupRecursiveOp* self);
void deja_dup_recursive_op_start_async (DejaDupRecursiveOp* self);
GFile* deja_dup_recursive_op_get_src (DejaDupRecursiveOp* self);
GFile* deja_dup_recursive_op_get_dst (DejaDupRecursiveOp* self);
GType deja_dup_recursive_op_get_type (void);


G_END_DECLS

#endif
